/*
 * Decompiled with CFR 0.152.
 */
package com.tobedevoured.modelcitizen.policy;

import com.tobedevoured.modelcitizen.Erector;
import com.tobedevoured.modelcitizen.ModelFactory;
import com.tobedevoured.modelcitizen.erector.Command;
import com.tobedevoured.modelcitizen.field.ModelField;
import com.tobedevoured.modelcitizen.policy.BlueprintPolicy;
import com.tobedevoured.modelcitizen.policy.PolicyException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkipReferenceFieldPolicy
implements BlueprintPolicy {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String field;
    private Class target;

    public SkipReferenceFieldPolicy(String field, Class target) {
        this.field = field;
        this.target = target;
    }

    @Override
    public Class getTarget() {
        return this.target;
    }

    @Override
    public Map<ModelField, Set<Command>> process(ModelFactory modelFactory, Erector erector, Object model) throws PolicyException {
        HashMap<ModelField, Set<Command>> modelFieldCommands = new HashMap<ModelField, Set<Command>>();
        for (ModelField modelField : erector.getModelFields()) {
            this.logger.debug("    {} {}", (Object)this.getTarget(), (Object)modelField);
            if (!modelField.getName().equals(this.field)) continue;
            HashSet<Command> commands = (HashSet<Command>)modelFieldCommands.get(modelField);
            if (commands == null) {
                commands = new HashSet<Command>();
            }
            commands.add(Command.SKIP_REFERENCE_INJECTION);
            modelFieldCommands.put(modelField, commands);
        }
        return modelFieldCommands;
    }
}

