/*
 * Decompiled with CFR 0.152.
 */
package com.tobedevoured.modelcitizen.template;

import com.tobedevoured.modelcitizen.template.BlueprintTemplate;
import com.tobedevoured.modelcitizen.template.BlueprintTemplateException;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.reflect.ConstructorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaBeanTemplate
implements BlueprintTemplate {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public <T> T construct(Class<T> modelClass) throws BlueprintTemplateException {
        try {
            return (T)ConstructorUtils.invokeConstructor(modelClass, null);
        }
        catch (NoSuchMethodException e) {
            throw new BlueprintTemplateException(e);
        }
        catch (IllegalAccessException e) {
            throw new BlueprintTemplateException(e);
        }
        catch (InvocationTargetException e) {
            throw new BlueprintTemplateException(e);
        }
        catch (InstantiationException e) {
            throw new BlueprintTemplateException(e);
        }
    }

    @Override
    public <T> T set(T model, String property, Object value) throws BlueprintTemplateException {
        try {
            PropertyUtils.setProperty(model, (String)property, (Object)value);
        }
        catch (IllegalAccessException propertyException) {
            throw new BlueprintTemplateException(propertyException);
        }
        catch (InvocationTargetException propertyException) {
            throw new BlueprintTemplateException(propertyException);
        }
        catch (NoSuchMethodException propertyException) {
            throw new BlueprintTemplateException(propertyException);
        }
        return model;
    }

    @Override
    public Object get(Object model, String property) throws BlueprintTemplateException {
        try {
            return PropertyUtils.getProperty((Object)model, (String)property);
        }
        catch (IllegalAccessException propertyException) {
            throw new BlueprintTemplateException(propertyException);
        }
        catch (InvocationTargetException propertyException) {
            throw new BlueprintTemplateException(propertyException);
        }
        catch (NoSuchMethodException propertyException) {
            throw new BlueprintTemplateException(propertyException);
        }
    }
}

