/*
 * Decompiled with CFR 0.152.
 */
package com.tobedevoured.modelcitizen.spring;

import com.tobedevoured.modelcitizen.Erector;
import com.tobedevoured.modelcitizen.ModelFactory;
import com.tobedevoured.modelcitizen.RegisterBlueprintException;
import com.tobedevoured.modelcitizen.annotation.NotSet;
import com.tobedevoured.modelcitizen.spring.annotation.SpringBlueprint;
import com.tobedevoured.modelcitizen.template.BlueprintTemplateException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ModelFactoryBean
extends ModelFactory
implements ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(ModelFactoryBean.class);
    private ApplicationContext applicationContext;
    @Autowired
    private AutowireCapableBeanFactory beanFactory;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    protected Object createNewInstance(Erector erector) throws BlueprintTemplateException {
        SpringBlueprint springBlueprint = erector.getBlueprint().getClass().getAnnotation(SpringBlueprint.class);
        if (springBlueprint != null && springBlueprint.bean()) {
            Class beanClass = springBlueprint.beanClass();
            if (beanClass.equals(NotSet.class)) {
                beanClass = erector.getTarget();
            }
            try {
                if (StringUtils.isNotBlank((String)springBlueprint.beanName())) {
                    logger.debug("Retrieving model from Spring [{},{}]", (Object)springBlueprint.beanName(), (Object)beanClass);
                    return this.applicationContext.getBean(springBlueprint.beanName(), beanClass);
                }
                logger.debug("Retrieving model from Spring [{}]", (Object)beanClass);
                return this.applicationContext.getBean(beanClass);
            }
            catch (NoSuchBeanDefinitionException e) {
                Object instance = super.createNewInstance(erector);
                this.beanFactory.autowireBean(instance);
                return instance;
            }
        }
        return super.createNewInstance(erector);
    }

    public void registerBlueprint(Object blueprint) throws RegisterBlueprintException {
        SpringBlueprint springBlueprint = blueprint.getClass().getAnnotation(SpringBlueprint.class);
        if (springBlueprint != null && springBlueprint.autowire()) {
            logger.debug("Autowiring blueprint {}", blueprint);
            this.beanFactory.autowireBean(blueprint);
        }
        super.registerBlueprint(blueprint);
    }
}

