/*
 * Decompiled with CFR 0.152.
 */
package com.toedter.spring.hateoas.jsonapi;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.toedter.spring.hateoas.jsonapi.JsonApiObject;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import lombok.Generated;
import org.springframework.hateoas.LinkRelation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class JsonApiConfiguration {
    private final boolean pluralizedTypeRendered;
    private final boolean lowerCasedTypeRendered;
    @Deprecated(since="2.0.0")
    private final boolean jsonApiVersionRendered;
    private final JsonApiObject jsonApiObject;
    private final boolean pageMetaAutomaticallyCreated;
    private final boolean typeForClassUsedForDeserialization;
    private final AffordanceType affordancesRenderedAsLinkMeta;
    private final boolean emptyAttributesObjectSerialized;
    private final String jsonApiIdNotSerializedForValue;
    private final Consumer<ObjectMapper> objectMapperCustomizer;
    private final boolean jsonApi11LinkPropertiesRemovedFromLinkMeta;
    private final boolean jsonApiCompliantLinks;
    private final Set<LinkRelation> linksNotUrlEncoded;
    private final Map<Class<?>, String> typeForClass;
    private ObjectMapper objectMapper;

    public JsonApiConfiguration customize(ObjectMapper objectMapper) {
        this.objectMapperCustomizer.accept(objectMapper);
        return this;
    }

    ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public JsonApiConfiguration withTypeForClass(Class<?> clazz, String type) {
        Assert.notNull(clazz, (String)"class must not be null!");
        Assert.notNull((Object)type, (String)"type must not be null!");
        LinkedHashMap map = new LinkedHashMap(this.typeForClass);
        map.put(clazz, type);
        return this.withTypeForClass(map);
    }

    @Nullable
    public String getTypeForClass(Class<?> clazz) {
        Assert.notNull(clazz, (String)"class must not be null!");
        return this.typeForClass.get(clazz);
    }

    @Nullable
    public Class<?> getClassForType(String type) {
        Assert.notNull((Object)type, (String)"type must not be null!");
        if (this.typeForClass.containsValue(type)) {
            for (Map.Entry<Class<?>, String> entry : this.typeForClass.entrySet()) {
                if (!entry.getValue().equals(type)) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    public JsonApiConfiguration() {
        this.pluralizedTypeRendered = true;
        this.lowerCasedTypeRendered = true;
        this.jsonApiVersionRendered = false;
        this.jsonApiObject = null;
        this.pageMetaAutomaticallyCreated = true;
        this.typeForClass = new LinkedHashMap();
        this.typeForClassUsedForDeserialization = false;
        this.emptyAttributesObjectSerialized = false;
        this.jsonApiIdNotSerializedForValue = null;
        this.affordancesRenderedAsLinkMeta = AffordanceType.NONE;
        this.jsonApi11LinkPropertiesRemovedFromLinkMeta = true;
        this.jsonApiCompliantLinks = true;
        this.linksNotUrlEncoded = new HashSet<LinkRelation>();
        this.objectMapperCustomizer = customObjectMapper -> {};
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private JsonApiConfiguration(boolean pluralizedTypeRendered, boolean lowerCasedTypeRendered, boolean jsonApiVersionRendered, JsonApiObject jsonApiObject, boolean pageMetaAutomaticallyCreated, boolean typeForClassUsedForDeserialization, AffordanceType affordancesRenderedAsLinkMeta, boolean emptyAttributesObjectSerialized, String jsonApiIdNotSerializedForValue, Consumer<ObjectMapper> objectMapperCustomizer, boolean jsonApi11LinkPropertiesRemovedFromLinkMeta, boolean jsonApiCompliantLinks, Set<LinkRelation> linksNotUrlEncoded, Map<Class<?>, String> typeForClass, ObjectMapper objectMapper) {
        this.pluralizedTypeRendered = pluralizedTypeRendered;
        this.lowerCasedTypeRendered = lowerCasedTypeRendered;
        this.jsonApiVersionRendered = jsonApiVersionRendered;
        this.jsonApiObject = jsonApiObject;
        this.pageMetaAutomaticallyCreated = pageMetaAutomaticallyCreated;
        this.typeForClassUsedForDeserialization = typeForClassUsedForDeserialization;
        this.affordancesRenderedAsLinkMeta = affordancesRenderedAsLinkMeta;
        this.emptyAttributesObjectSerialized = emptyAttributesObjectSerialized;
        this.jsonApiIdNotSerializedForValue = jsonApiIdNotSerializedForValue;
        this.objectMapperCustomizer = objectMapperCustomizer;
        this.jsonApi11LinkPropertiesRemovedFromLinkMeta = jsonApi11LinkPropertiesRemovedFromLinkMeta;
        this.jsonApiCompliantLinks = jsonApiCompliantLinks;
        this.linksNotUrlEncoded = linksNotUrlEncoded;
        this.typeForClass = typeForClass;
        this.objectMapper = objectMapper;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public JsonApiConfiguration withPluralizedTypeRendered(boolean pluralizedTypeRendered) {
        return this.pluralizedTypeRendered == pluralizedTypeRendered ? this : new JsonApiConfiguration(pluralizedTypeRendered, this.lowerCasedTypeRendered, this.jsonApiVersionRendered, this.jsonApiObject, this.pageMetaAutomaticallyCreated, this.typeForClassUsedForDeserialization, this.affordancesRenderedAsLinkMeta, this.emptyAttributesObjectSerialized, this.jsonApiIdNotSerializedForValue, this.objectMapperCustomizer, this.jsonApi11LinkPropertiesRemovedFromLinkMeta, this.jsonApiCompliantLinks, this.linksNotUrlEncoded, this.typeForClass, this.objectMapper);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isPluralizedTypeRendered() {
        return this.pluralizedTypeRendered;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public JsonApiConfiguration withLowerCasedTypeRendered(boolean lowerCasedTypeRendered) {
        return this.lowerCasedTypeRendered == lowerCasedTypeRendered ? this : new JsonApiConfiguration(this.pluralizedTypeRendered, lowerCasedTypeRendered, this.jsonApiVersionRendered, this.jsonApiObject, this.pageMetaAutomaticallyCreated, this.typeForClassUsedForDeserialization, this.affordancesRenderedAsLinkMeta, this.emptyAttributesObjectSerialized, this.jsonApiIdNotSerializedForValue, this.objectMapperCustomizer, this.jsonApi11LinkPropertiesRemovedFromLinkMeta, this.jsonApiCompliantLinks, this.linksNotUrlEncoded, this.typeForClass, this.objectMapper);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isLowerCasedTypeRendered() {
        return this.lowerCasedTypeRendered;
    }

    @Deprecated
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public JsonApiConfiguration withJsonApiVersionRendered(boolean jsonApiVersionRendered) {
        return this.jsonApiVersionRendered == jsonApiVersionRendered ? this : new JsonApiConfiguration(this.pluralizedTypeRendered, this.lowerCasedTypeRendered, jsonApiVersionRendered, this.jsonApiObject, this.pageMetaAutomaticallyCreated, this.typeForClassUsedForDeserialization, this.affordancesRenderedAsLinkMeta, this.emptyAttributesObjectSerialized, this.jsonApiIdNotSerializedForValue, this.objectMapperCustomizer, this.jsonApi11LinkPropertiesRemovedFromLinkMeta, this.jsonApiCompliantLinks, this.linksNotUrlEncoded, this.typeForClass, this.objectMapper);
    }

    @Deprecated
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isJsonApiVersionRendered() {
        return this.jsonApiVersionRendered;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public JsonApiConfiguration withJsonApiObject(JsonApiObject jsonApiObject) {
        return this.jsonApiObject == jsonApiObject ? this : new JsonApiConfiguration(this.pluralizedTypeRendered, this.lowerCasedTypeRendered, this.jsonApiVersionRendered, jsonApiObject, this.pageMetaAutomaticallyCreated, this.typeForClassUsedForDeserialization, this.affordancesRenderedAsLinkMeta, this.emptyAttributesObjectSerialized, this.jsonApiIdNotSerializedForValue, this.objectMapperCustomizer, this.jsonApi11LinkPropertiesRemovedFromLinkMeta, this.jsonApiCompliantLinks, this.linksNotUrlEncoded, this.typeForClass, this.objectMapper);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public JsonApiObject getJsonApiObject() {
        return this.jsonApiObject;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public JsonApiConfiguration withPageMetaAutomaticallyCreated(boolean pageMetaAutomaticallyCreated) {
        return this.pageMetaAutomaticallyCreated == pageMetaAutomaticallyCreated ? this : new JsonApiConfiguration(this.pluralizedTypeRendered, this.lowerCasedTypeRendered, this.jsonApiVersionRendered, this.jsonApiObject, pageMetaAutomaticallyCreated, this.typeForClassUsedForDeserialization, this.affordancesRenderedAsLinkMeta, this.emptyAttributesObjectSerialized, this.jsonApiIdNotSerializedForValue, this.objectMapperCustomizer, this.jsonApi11LinkPropertiesRemovedFromLinkMeta, this.jsonApiCompliantLinks, this.linksNotUrlEncoded, this.typeForClass, this.objectMapper);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isPageMetaAutomaticallyCreated() {
        return this.pageMetaAutomaticallyCreated;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public JsonApiConfiguration withTypeForClassUsedForDeserialization(boolean typeForClassUsedForDeserialization) {
        return this.typeForClassUsedForDeserialization == typeForClassUsedForDeserialization ? this : new JsonApiConfiguration(this.pluralizedTypeRendered, this.lowerCasedTypeRendered, this.jsonApiVersionRendered, this.jsonApiObject, this.pageMetaAutomaticallyCreated, typeForClassUsedForDeserialization, this.affordancesRenderedAsLinkMeta, this.emptyAttributesObjectSerialized, this.jsonApiIdNotSerializedForValue, this.objectMapperCustomizer, this.jsonApi11LinkPropertiesRemovedFromLinkMeta, this.jsonApiCompliantLinks, this.linksNotUrlEncoded, this.typeForClass, this.objectMapper);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isTypeForClassUsedForDeserialization() {
        return this.typeForClassUsedForDeserialization;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public JsonApiConfiguration withAffordancesRenderedAsLinkMeta(AffordanceType affordancesRenderedAsLinkMeta) {
        return this.affordancesRenderedAsLinkMeta == affordancesRenderedAsLinkMeta ? this : new JsonApiConfiguration(this.pluralizedTypeRendered, this.lowerCasedTypeRendered, this.jsonApiVersionRendered, this.jsonApiObject, this.pageMetaAutomaticallyCreated, this.typeForClassUsedForDeserialization, affordancesRenderedAsLinkMeta, this.emptyAttributesObjectSerialized, this.jsonApiIdNotSerializedForValue, this.objectMapperCustomizer, this.jsonApi11LinkPropertiesRemovedFromLinkMeta, this.jsonApiCompliantLinks, this.linksNotUrlEncoded, this.typeForClass, this.objectMapper);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public AffordanceType getAffordancesRenderedAsLinkMeta() {
        return this.affordancesRenderedAsLinkMeta;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public JsonApiConfiguration withEmptyAttributesObjectSerialized(boolean emptyAttributesObjectSerialized) {
        return this.emptyAttributesObjectSerialized == emptyAttributesObjectSerialized ? this : new JsonApiConfiguration(this.pluralizedTypeRendered, this.lowerCasedTypeRendered, this.jsonApiVersionRendered, this.jsonApiObject, this.pageMetaAutomaticallyCreated, this.typeForClassUsedForDeserialization, this.affordancesRenderedAsLinkMeta, emptyAttributesObjectSerialized, this.jsonApiIdNotSerializedForValue, this.objectMapperCustomizer, this.jsonApi11LinkPropertiesRemovedFromLinkMeta, this.jsonApiCompliantLinks, this.linksNotUrlEncoded, this.typeForClass, this.objectMapper);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isEmptyAttributesObjectSerialized() {
        return this.emptyAttributesObjectSerialized;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public JsonApiConfiguration withJsonApiIdNotSerializedForValue(String jsonApiIdNotSerializedForValue) {
        return this.jsonApiIdNotSerializedForValue == jsonApiIdNotSerializedForValue ? this : new JsonApiConfiguration(this.pluralizedTypeRendered, this.lowerCasedTypeRendered, this.jsonApiVersionRendered, this.jsonApiObject, this.pageMetaAutomaticallyCreated, this.typeForClassUsedForDeserialization, this.affordancesRenderedAsLinkMeta, this.emptyAttributesObjectSerialized, jsonApiIdNotSerializedForValue, this.objectMapperCustomizer, this.jsonApi11LinkPropertiesRemovedFromLinkMeta, this.jsonApiCompliantLinks, this.linksNotUrlEncoded, this.typeForClass, this.objectMapper);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getJsonApiIdNotSerializedForValue() {
        return this.jsonApiIdNotSerializedForValue;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public JsonApiConfiguration withObjectMapperCustomizer(Consumer<ObjectMapper> objectMapperCustomizer) {
        return this.objectMapperCustomizer == objectMapperCustomizer ? this : new JsonApiConfiguration(this.pluralizedTypeRendered, this.lowerCasedTypeRendered, this.jsonApiVersionRendered, this.jsonApiObject, this.pageMetaAutomaticallyCreated, this.typeForClassUsedForDeserialization, this.affordancesRenderedAsLinkMeta, this.emptyAttributesObjectSerialized, this.jsonApiIdNotSerializedForValue, objectMapperCustomizer, this.jsonApi11LinkPropertiesRemovedFromLinkMeta, this.jsonApiCompliantLinks, this.linksNotUrlEncoded, this.typeForClass, this.objectMapper);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public JsonApiConfiguration withJsonApi11LinkPropertiesRemovedFromLinkMeta(boolean jsonApi11LinkPropertiesRemovedFromLinkMeta) {
        return this.jsonApi11LinkPropertiesRemovedFromLinkMeta == jsonApi11LinkPropertiesRemovedFromLinkMeta ? this : new JsonApiConfiguration(this.pluralizedTypeRendered, this.lowerCasedTypeRendered, this.jsonApiVersionRendered, this.jsonApiObject, this.pageMetaAutomaticallyCreated, this.typeForClassUsedForDeserialization, this.affordancesRenderedAsLinkMeta, this.emptyAttributesObjectSerialized, this.jsonApiIdNotSerializedForValue, this.objectMapperCustomizer, jsonApi11LinkPropertiesRemovedFromLinkMeta, this.jsonApiCompliantLinks, this.linksNotUrlEncoded, this.typeForClass, this.objectMapper);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isJsonApi11LinkPropertiesRemovedFromLinkMeta() {
        return this.jsonApi11LinkPropertiesRemovedFromLinkMeta;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public JsonApiConfiguration withJsonApiCompliantLinks(boolean jsonApiCompliantLinks) {
        return this.jsonApiCompliantLinks == jsonApiCompliantLinks ? this : new JsonApiConfiguration(this.pluralizedTypeRendered, this.lowerCasedTypeRendered, this.jsonApiVersionRendered, this.jsonApiObject, this.pageMetaAutomaticallyCreated, this.typeForClassUsedForDeserialization, this.affordancesRenderedAsLinkMeta, this.emptyAttributesObjectSerialized, this.jsonApiIdNotSerializedForValue, this.objectMapperCustomizer, this.jsonApi11LinkPropertiesRemovedFromLinkMeta, jsonApiCompliantLinks, this.linksNotUrlEncoded, this.typeForClass, this.objectMapper);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isJsonApiCompliantLinks() {
        return this.jsonApiCompliantLinks;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public JsonApiConfiguration withLinksNotUrlEncoded(Set<LinkRelation> linksNotUrlEncoded) {
        return this.linksNotUrlEncoded == linksNotUrlEncoded ? this : new JsonApiConfiguration(this.pluralizedTypeRendered, this.lowerCasedTypeRendered, this.jsonApiVersionRendered, this.jsonApiObject, this.pageMetaAutomaticallyCreated, this.typeForClassUsedForDeserialization, this.affordancesRenderedAsLinkMeta, this.emptyAttributesObjectSerialized, this.jsonApiIdNotSerializedForValue, this.objectMapperCustomizer, this.jsonApi11LinkPropertiesRemovedFromLinkMeta, this.jsonApiCompliantLinks, linksNotUrlEncoded, this.typeForClass, this.objectMapper);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Set<LinkRelation> getLinksNotUrlEncoded() {
        return this.linksNotUrlEncoded;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private JsonApiConfiguration withTypeForClass(Map<Class<?>, String> typeForClass) {
        return this.typeForClass == typeForClass ? this : new JsonApiConfiguration(this.pluralizedTypeRendered, this.lowerCasedTypeRendered, this.jsonApiVersionRendered, this.jsonApiObject, this.pageMetaAutomaticallyCreated, this.typeForClassUsedForDeserialization, this.affordancesRenderedAsLinkMeta, this.emptyAttributesObjectSerialized, this.jsonApiIdNotSerializedForValue, this.objectMapperCustomizer, this.jsonApi11LinkPropertiesRemovedFromLinkMeta, this.jsonApiCompliantLinks, this.linksNotUrlEncoded, typeForClass, this.objectMapper);
    }

    public static enum AffordanceType {
        NONE,
        SPRING_HATEOAS,
        HAL_FORMS;

    }
}

