/*
 * Decompiled with CFR 0.152.
 */
package com.toedter.spring.hateoas.jsonapi;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.toedter.spring.hateoas.jsonapi.Jackson2JsonApiModule;
import com.toedter.spring.hateoas.jsonapi.JsonApiConfiguration;
import com.toedter.spring.hateoas.jsonapi.JsonApiHandlerInstantiator;
import com.toedter.spring.hateoas.jsonapi.MediaTypes;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.hateoas.config.HypermediaMappingInformation;
import org.springframework.http.MediaType;
import org.springframework.lang.NonNull;

@Configuration
public class JsonApiMediaTypeConfiguration
implements HypermediaMappingInformation {
    private final ObjectProvider<JsonApiConfiguration> configuration;
    private final AutowireCapableBeanFactory beanFactory;

    @NonNull
    public List<MediaType> getMediaTypes() {
        return Collections.singletonList(MediaTypes.JSON_API);
    }

    public Module getJacksonModule() {
        return new Jackson2JsonApiModule();
    }

    @NonNull
    public ObjectMapper configureObjectMapper(@NonNull ObjectMapper mapper) {
        return this.configureObjectMapper(mapper, (JsonApiConfiguration)this.configuration.getIfAvailable(JsonApiConfiguration::new));
    }

    @NonNull
    ObjectMapper configureObjectMapper(@NonNull ObjectMapper mapper, JsonApiConfiguration configuration) {
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.registerModule((Module)new Jackson2JsonApiModule(configuration));
        mapper.setHandlerInstantiator((HandlerInstantiator)new JsonApiHandlerInstantiator(configuration, this.beanFactory));
        configuration.customize(mapper);
        configuration.setObjectMapper(mapper);
        return mapper;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public JsonApiMediaTypeConfiguration(ObjectProvider<JsonApiConfiguration> configuration, AutowireCapableBeanFactory beanFactory) {
        this.configuration = configuration;
        this.beanFactory = beanFactory;
    }
}

