/*
 * Decompiled with CFR 0.152.
 */
package com.toedter.spring.hateoas.jsonapi;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.toedter.spring.hateoas.jsonapi.AbstractJsonApiModelDeserializer;
import com.toedter.spring.hateoas.jsonapi.JsonApiConfiguration;
import com.toedter.spring.hateoas.jsonapi.JsonApiDocument;
import java.util.List;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.util.Assert;

class JsonApiRepresentationModelDeserializer
extends AbstractJsonApiModelDeserializer<RepresentationModel<?>>
implements ContextualDeserializer {
    public static final String CANNOT_DESERIALIZE_INPUT_TO_REPRESENTATION_MODEL = "Cannot deserialize input to RepresentationModel";

    public JsonApiRepresentationModelDeserializer(JsonApiConfiguration jsonApiConfiguration) {
        super(jsonApiConfiguration);
    }

    protected JsonApiRepresentationModelDeserializer(JavaType contentType, JsonApiConfiguration jsonApiConfiguration) {
        super(contentType, jsonApiConfiguration);
    }

    @Override
    protected RepresentationModel<?> convertToRepresentationModel(List<Object> resources, JsonApiDocument doc) {
        Assert.notNull((Object)doc, (String)"JsonApiDocument must not be null!");
        Links links = doc.getLinks();
        if (resources.size() == 1) {
            RepresentationModel representationModel;
            if (resources.get(0) instanceof RepresentationModel) {
                representationModel = (RepresentationModel)resources.get(0);
            } else if (resources.get(0) == null) {
                representationModel = new RepresentationModel();
            } else {
                throw new IllegalArgumentException(CANNOT_DESERIALIZE_INPUT_TO_REPRESENTATION_MODEL);
            }
            representationModel.add((Iterable)links);
            return representationModel;
        }
        throw new IllegalArgumentException(CANNOT_DESERIALIZE_INPUT_TO_REPRESENTATION_MODEL);
    }

    @Override
    protected JsonDeserializer<?> createJsonDeserializer(JavaType type) {
        return new JsonApiRepresentationModelDeserializer(type, this.jsonApiConfiguration);
    }
}

