/*
 * Decompiled with CFR 0.152.
 */
package com.opentok;

import com.opentok.Archive;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ArchiveProperties {
    private String name = null;
    private boolean hasAudio;
    private boolean hasVideo;
    private Archive.OutputMode outputMode;

    private ArchiveProperties(Builder builder) {
        this.name = builder.name;
        this.hasAudio = builder.hasAudio;
        this.hasVideo = builder.hasVideo;
        this.outputMode = builder.outputMode;
    }

    public String name() {
        return this.name;
    }

    public boolean hasVideo() {
        return this.hasVideo;
    }

    public boolean hasAudio() {
        return this.hasAudio;
    }

    public Archive.OutputMode outputMode() {
        return this.outputMode;
    }

    public Map<String, Collection<String>> toMap() {
        ArrayList<String> valueList;
        HashMap<String, Collection<String>> params = new HashMap<String, Collection<String>>();
        if (null != this.name) {
            valueList = new ArrayList<String>();
            valueList.add(this.name);
            params.put("name", valueList);
        }
        valueList = new ArrayList();
        valueList.add(Boolean.toString(this.hasAudio));
        params.put("hasAudio", valueList);
        valueList = new ArrayList();
        valueList.add(Boolean.toString(this.hasVideo));
        params.put("hasVideo", valueList);
        valueList = new ArrayList();
        valueList.add(this.outputMode.toString());
        params.put("outputMode", valueList);
        return params;
    }

    public static class Builder {
        private String name = null;
        private boolean hasAudio = true;
        private boolean hasVideo = true;
        private Archive.OutputMode outputMode = Archive.OutputMode.COMPOSED;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder hasAudio(boolean hasAudio) {
            this.hasAudio = hasAudio;
            return this;
        }

        public Builder hasVideo(boolean hasVideo) {
            this.hasVideo = hasVideo;
            return this;
        }

        public Builder outputMode(Archive.OutputMode outputMode) {
            this.outputMode = outputMode;
            return this;
        }

        public ArchiveProperties build() {
            return new ArchiveProperties(this);
        }
    }
}

