/*
 * Decompiled with CFR 0.152.
 */
package com.opentok;

public class CaptionProperties {
    private final String statusCallbackUrl;
    private final String languageCode;
    private final int maxDuration;
    private final boolean partialCaptions;

    private CaptionProperties(Builder builder) {
        this.statusCallbackUrl = builder.statusCallbackUrl;
        this.languageCode = builder.languageCode;
        this.maxDuration = builder.maxDuration;
        this.partialCaptions = builder.partialCaptions;
    }

    public String getStatusCallbackUrl() {
        return this.statusCallbackUrl;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public int getMaxDuration() {
        return this.maxDuration;
    }

    public boolean partialCaptions() {
        return this.partialCaptions;
    }

    public static Builder Builder() {
        return new Builder();
    }

    public static class Builder {
        private String languageCode = "en-US";
        private String statusCallbackUrl;
        private int maxDuration = 14400;
        private boolean partialCaptions = true;

        private Builder() {
        }

        public Builder languageCode(String languageCode) {
            if (languageCode == null || languageCode.length() != 5 || languageCode.charAt(2) != '-') {
                throw new IllegalArgumentException("Invalid language code.");
            }
            this.languageCode = languageCode;
            return this;
        }

        public Builder statusCallbackUrl(String statusCallbackUrl) {
            if (statusCallbackUrl == null || statusCallbackUrl.length() < 15 || statusCallbackUrl.length() > 2048) {
                throw new IllegalArgumentException("Status callback URL must be between 15 and 2048 characters.");
            }
            this.statusCallbackUrl = statusCallbackUrl;
            return this;
        }

        public Builder maxDuration(int maxDuration) {
            this.maxDuration = maxDuration;
            if (this.maxDuration < 0 || maxDuration > 14400) {
                throw new IllegalArgumentException("Max duration must be positive and less than 14400 seconds.");
            }
            return this;
        }

        public Builder partialCaptions(boolean partialCaptions) {
            this.partialCaptions = partialCaptions;
            return this;
        }

        public CaptionProperties build() {
            return new CaptionProperties(this);
        }
    }
}

