/*
 * Decompiled with CFR 0.152.
 */
package com.opentok;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.opentok.Archive;
import com.opentok.ArchiveList;
import com.opentok.ArchiveProperties;
import com.opentok.AudioConnector;
import com.opentok.AudioConnectorProperties;
import com.opentok.Broadcast;
import com.opentok.BroadcastProperties;
import com.opentok.Caption;
import com.opentok.CaptionProperties;
import com.opentok.CreatedSession;
import com.opentok.MuteAllProperties;
import com.opentok.Render;
import com.opentok.RenderProperties;
import com.opentok.Session;
import com.opentok.SessionProperties;
import com.opentok.SignalProperties;
import com.opentok.Sip;
import com.opentok.SipProperties;
import com.opentok.Stream;
import com.opentok.StreamList;
import com.opentok.StreamListProperties;
import com.opentok.TokenOptions;
import com.opentok.constants.DefaultUserAgent;
import com.opentok.exception.InvalidArgumentException;
import com.opentok.exception.OpenTokException;
import com.opentok.exception.RequestException;
import com.opentok.util.Crypto;
import com.opentok.util.HttpClient;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Proxy;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class OpenTok {
    private final int apiKey;
    private final String apiSecret;
    protected HttpClient client;
    protected static final ObjectReader archiveReader = new ObjectMapper().readerFor(Archive.class);
    protected static final ObjectReader archiveListReader = new ObjectMapper().readerFor(ArchiveList.class);
    protected static final ObjectReader createdSessionReader = new ObjectMapper().readerFor(CreatedSession[].class);
    protected static final ObjectReader streamReader = new ObjectMapper().readerFor(Stream.class);
    protected static final ObjectReader streamListReader = new ObjectMapper().readerFor(StreamList.class);
    protected static final ObjectReader sipReader = new ObjectMapper().readerFor(Sip.class);
    protected static final ObjectReader broadcastReader = new ObjectMapper().readerFor(Broadcast.class);
    protected static final ObjectReader renderReader = new ObjectMapper().readerFor(Render.class);
    protected static final ObjectReader renderListReader = new ObjectMapper().readerForListOf(Render.class);
    protected static final ObjectReader connectReader = new ObjectMapper().readerFor(AudioConnector.class);
    protected static final ObjectReader captionReader = new ObjectMapper().readerFor(Caption.class);
    static final String defaultApiUrl = "https://api.opentok.com";

    public OpenTok(int apiKey, String apiSecret) {
        this(apiKey, apiSecret, new HttpClient.Builder(apiKey, apiSecret).build());
    }

    private OpenTok(int apiKey, String apiSecret, HttpClient httpClient) {
        this.apiKey = apiKey;
        this.apiSecret = apiSecret.trim();
        this.client = httpClient;
    }

    public String generateToken(String sessionId, TokenOptions tokenOptions) throws OpenTokException {
        List<String> sessionIdParts;
        if (sessionId == null || sessionId.isEmpty()) {
            throw new InvalidArgumentException("Session not valid");
        }
        try {
            sessionIdParts = Crypto.decodeSessionId(sessionId);
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidArgumentException("Session ID was not valid");
        }
        if (!sessionIdParts.contains(Integer.toString(this.apiKey))) {
            throw new InvalidArgumentException("Session ID was not valid");
        }
        Session session = new Session(sessionId, this.apiKey, this.apiSecret);
        return session.generateToken(tokenOptions);
    }

    public String generateToken(String sessionId) throws OpenTokException {
        return this.generateToken(sessionId, new TokenOptions.Builder().build());
    }

    public Session createSession(SessionProperties properties) throws OpenTokException {
        SessionProperties _properties = properties != null ? properties : new SessionProperties.Builder().build();
        Map<String, List<String>> params = _properties.toMap();
        String response = this.client.createSession(params);
        try {
            CreatedSession[] sessions = (CreatedSession[])createdSessionReader.readValue(response);
            if (sessions.length != 1) {
                throw new OpenTokException(String.format("Unexpected number of sessions created %d", sessions.length));
            }
            return new Session(sessions[0].getId(), this.apiKey, this.apiSecret, _properties);
        }
        catch (IOException e) {
            throw new OpenTokException("Cannot create session. Could not read the response: " + response);
        }
    }

    public Session createSession() throws OpenTokException {
        return this.createSession(null);
    }

    public void signal(String sessionId, SignalProperties props) throws OpenTokException {
        if (sessionId == null || sessionId.isEmpty()) {
            throw new InvalidArgumentException("Session string null or empty");
        }
        this.client.signal(sessionId, null, props);
    }

    public void signal(String sessionId, String connectionId, SignalProperties props) throws OpenTokException {
        if (sessionId == null || sessionId.isEmpty() || connectionId == null || connectionId.isEmpty()) {
            throw new InvalidArgumentException("Session or Connection string null or empty");
        }
        this.client.signal(sessionId, connectionId, props);
    }

    public Archive getArchive(String archiveId) throws OpenTokException {
        String archive = this.client.getArchive(archiveId);
        try {
            return (Archive)archiveReader.readValue(archive);
        }
        catch (Exception e) {
            throw new RequestException("Exception mapping json: " + e.getMessage());
        }
    }

    public ArchiveList listArchives() throws OpenTokException {
        return this.listArchives("", 0, 1000);
    }

    public ArchiveList listArchives(String sessionId) throws OpenTokException {
        if (sessionId == null || sessionId.isEmpty()) {
            throw new InvalidArgumentException("Session Id cannot be null or empty");
        }
        return this.listArchives(sessionId, 0, 1000);
    }

    public ArchiveList listArchives(int offset, int count) throws OpenTokException {
        return this.listArchives("", offset, count);
    }

    public ArchiveList listArchives(String sessionId, int offset, int count) throws OpenTokException {
        String archives = this.client.getArchives(sessionId, offset, count);
        try {
            return (ArchiveList)archiveListReader.readValue(archives);
        }
        catch (JsonProcessingException e) {
            throw new RequestException("Exception mapping json: " + e.getMessage());
        }
    }

    public Archive startArchive(String sessionId, ArchiveProperties properties) throws OpenTokException {
        boolean hasResolution;
        if (sessionId == null || sessionId.isEmpty()) {
            throw new InvalidArgumentException("Session not valid");
        }
        boolean bl = hasResolution = properties != null && properties.resolution() != null && !properties.resolution().isEmpty();
        if (properties != null && properties.outputMode().equals((Object)Archive.OutputMode.INDIVIDUAL) && hasResolution) {
            throw new InvalidArgumentException("The resolution cannot be specified for individual output mode.");
        }
        String archive = this.client.startArchive(sessionId, properties);
        try {
            return (Archive)archiveReader.readValue(archive);
        }
        catch (Exception e) {
            throw new RequestException("Exception mapping json: " + e.getMessage());
        }
    }

    public Archive startArchive(String sessionId) throws OpenTokException {
        return this.startArchive(sessionId, new ArchiveProperties.Builder().build());
    }

    public Archive startArchive(String sessionId, String name) throws OpenTokException {
        ArchiveProperties properties = new ArchiveProperties.Builder().name(name).build();
        return this.startArchive(sessionId, properties);
    }

    public Archive stopArchive(String archiveId) throws OpenTokException {
        String archive = this.client.stopArchive(archiveId);
        try {
            return (Archive)archiveReader.readValue(archive);
        }
        catch (Exception e) {
            throw new RequestException("Exception mapping json: " + e.getMessage());
        }
    }

    public void deleteArchive(String archiveId) throws OpenTokException {
        this.client.deleteArchive(archiveId);
    }

    public void addArchiveStream(String archiveId, String streamId, boolean hasAudio, boolean hasVideo) throws OpenTokException {
        this.client.patchArchive(archiveId, streamId, null, hasAudio, hasVideo);
    }

    public void removeArchiveStream(String archiveId, String streamId) throws OpenTokException {
        this.client.patchArchive(archiveId, null, streamId, false, false);
    }

    public void setArchiveLayout(String archiveId, ArchiveProperties properties) throws OpenTokException {
        if (StringUtils.isEmpty((String)archiveId) || properties == null) {
            throw new InvalidArgumentException("ArchiveId is not valid or properties are null");
        }
        this.client.setArchiveLayout(archiveId, properties);
    }

    public Broadcast startBroadcast(String sessionId, BroadcastProperties properties) throws OpenTokException {
        if (StringUtils.isEmpty((String)sessionId) || properties == null) {
            throw new InvalidArgumentException("Session not valid or broadcast properties is null");
        }
        String broadcast = this.client.startBroadcast(sessionId, properties);
        try {
            return (Broadcast)broadcastReader.readValue(broadcast);
        }
        catch (Exception e) {
            throw new RequestException("Exception mapping json: " + e.getMessage());
        }
    }

    public Broadcast stopBroadcast(String broadcastId) throws OpenTokException {
        if (StringUtils.isEmpty((String)broadcastId)) {
            throw new InvalidArgumentException("Broadcast id is null or empty");
        }
        String broadcast = this.client.stopBroadcast(broadcastId);
        try {
            return (Broadcast)broadcastReader.readValue(broadcast);
        }
        catch (Exception e) {
            throw new RequestException("Exception mapping json: " + e.getMessage());
        }
    }

    public Broadcast getBroadcast(String broadcastId) throws OpenTokException {
        if (StringUtils.isEmpty((String)broadcastId)) {
            throw new InvalidArgumentException("Broadcast id is null or empty");
        }
        String stream = this.client.getBroadcast(broadcastId);
        try {
            return (Broadcast)broadcastReader.readValue(stream);
        }
        catch (Exception e) {
            throw new RequestException("Exception mapping json: " + e.getMessage());
        }
    }

    public void setBroadcastLayout(String broadcastId, BroadcastProperties properties) throws OpenTokException {
        if (StringUtils.isEmpty((String)broadcastId) || properties == null) {
            throw new InvalidArgumentException("BroadcastId is not valid or properties are null");
        }
        this.client.setBroadcastLayout(broadcastId, properties);
    }

    public void addBroadcastStream(String broadcastId, String streamId, boolean hasAudio, boolean hasVideo) throws OpenTokException {
        this.client.patchBroadcast(broadcastId, streamId, null, hasAudio, hasVideo);
    }

    public void removeBroadcastStream(String broadcastId, String streamId) throws OpenTokException {
        this.client.patchBroadcast(broadcastId, null, streamId, false, false);
    }

    public void setStreamLayouts(String sessionId, StreamListProperties properties) throws OpenTokException {
        if (StringUtils.isEmpty((String)sessionId) || properties == null) {
            throw new InvalidArgumentException("SessionId is not valid or properties are null");
        }
        this.client.setStreamLayouts(sessionId, properties);
    }

    public void forceDisconnect(String sessionId, String connectionId) throws OpenTokException {
        if (sessionId == null || sessionId.isEmpty() || connectionId == null || connectionId.isEmpty()) {
            throw new InvalidArgumentException("Session or Connection string null or empty");
        }
        this.client.forceDisconnect(sessionId, connectionId);
    }

    public void forceMuteStream(String sessionId, String streamId) throws OpenTokException {
        if (sessionId == null || sessionId.isEmpty() || streamId == null || streamId.isEmpty()) {
            throw new InvalidArgumentException("Session or Connection string null or empty");
        }
        this.client.forceMuteStream(sessionId, streamId);
    }

    public void forceMuteAll(String sessionId, MuteAllProperties properties) throws OpenTokException {
        if (sessionId == null || sessionId.isEmpty()) {
            throw new InvalidArgumentException("Session or Connection string null or empty");
        }
        this.client.forceMuteAllStream(sessionId, properties);
    }

    public void disableForceMute(String sessionId) throws OpenTokException {
        if (sessionId == null || sessionId.isEmpty()) {
            throw new InvalidArgumentException("Session or Connection string null or empty");
        }
        this.client.disableForceMute(sessionId);
    }

    public Stream getStream(String sessionId, String streamId) throws OpenTokException {
        String stream = this.client.getStream(sessionId, streamId);
        try {
            return (Stream)streamReader.readValue(stream);
        }
        catch (Exception e) {
            throw new RequestException("Exception mapping json: " + e.getMessage());
        }
    }

    public StreamList listStreams(String sessionId) throws OpenTokException {
        String streams = this.client.listStreams(sessionId);
        try {
            return (StreamList)streamListReader.readValue(streams);
        }
        catch (JsonProcessingException e) {
            throw new RequestException("Exception mapping json: " + e.getMessage());
        }
    }

    public Sip dial(String sessionId, String token, SipProperties properties) throws OpenTokException {
        if (StringUtils.isEmpty((String)sessionId) || StringUtils.isEmpty((String)token) || properties == null || StringUtils.isEmpty((String)properties.sipUri())) {
            throw new InvalidArgumentException("Session id or token is null or empty or sip properties is null or sip uri empty or null.");
        }
        String sip = this.client.sipDial(sessionId, token, properties);
        try {
            return (Sip)sipReader.readValue(sip);
        }
        catch (JsonProcessingException e) {
            throw new RequestException("Exception mapping json: " + e.getMessage());
        }
    }

    public void playDTMF(String sessionId, String dtmfDigits) throws OpenTokException {
        this.client.playDtmfAll(sessionId, dtmfDigits);
    }

    public void playDTMF(String sessionId, String connectionId, String dtmfDigits) throws OpenTokException {
        this.client.playDtmfSingle(sessionId, connectionId, dtmfDigits);
    }

    public AudioConnector connectAudioStream(String sessionId, String token, AudioConnectorProperties properties) throws OpenTokException {
        try {
            return (AudioConnector)connectReader.readValue(this.client.connectAudioStream(sessionId, token, properties));
        }
        catch (JsonProcessingException ex) {
            throw new RequestException("Exception mapping json: " + ex.getMessage(), ex);
        }
    }

    public Render startRender(String sessionId, String token, RenderProperties properties) throws OpenTokException {
        if (StringUtils.isEmpty((String)sessionId) || StringUtils.isEmpty((String)token) || properties == null) {
            throw new InvalidArgumentException("Session id, token and properties are all required.");
        }
        String render = this.client.startRender(sessionId, token, properties);
        try {
            return (Render)renderReader.readValue(render);
        }
        catch (JsonProcessingException e) {
            throw new RequestException("Exception mapping json: " + e.getMessage());
        }
    }

    public Render getRender(String renderId) throws OpenTokException {
        if (StringUtils.isEmpty((String)renderId)) {
            throw new InvalidArgumentException("Render id is required.");
        }
        String render = this.client.getRender(renderId);
        try {
            return (Render)renderReader.readValue(render);
        }
        catch (JsonProcessingException e) {
            throw new RequestException("Exception mapping json: " + e.getMessage());
        }
    }

    public void stopRender(String renderId) throws OpenTokException {
        if (StringUtils.isEmpty((String)renderId)) {
            throw new InvalidArgumentException("Render id is required.");
        }
        this.client.stopRender(renderId);
    }

    public List<Render> listRenders() throws OpenTokException {
        return this.listRenders(null, null);
    }

    public List<Render> listRenders(Integer offset, Integer count) throws OpenTokException {
        String response = this.client.listRenders(offset, count);
        try {
            JsonNode root = new ObjectMapper().readTree(response);
            return (List)renderListReader.readValue(root.get("items"));
        }
        catch (IOException e) {
            throw new RequestException("Exception mapping json: " + e.getMessage());
        }
    }

    public Caption startCaptions(String sessionId, String token, CaptionProperties properties) throws OpenTokException {
        if (StringUtils.isEmpty((String)sessionId)) {
            throw new InvalidArgumentException("Session ID is required.");
        }
        if (StringUtils.isEmpty((String)token)) {
            throw new InvalidArgumentException("Token is required.");
        }
        String captions = this.client.startCaption(sessionId, token, properties != null ? properties : CaptionProperties.Builder().build());
        try {
            return (Caption)captionReader.readValue(captions);
        }
        catch (JsonProcessingException e) {
            throw new RequestException("Exception mapping json: " + e.getMessage());
        }
    }

    public void stopCaptions(String captionsId) throws OpenTokException {
        if (StringUtils.isEmpty((String)captionsId)) {
            throw new InvalidArgumentException("Captions id is required.");
        }
        this.client.stopCaption(captionsId);
    }

    public void close() {
        this.client.close();
    }

    public static class Builder {
        private int apiKey;
        private String apiSecret;
        private String apiUrl;
        private String appendUserAgent;
        private Proxy proxy;
        private HttpClient.ProxyAuthScheme proxyAuthScheme;
        private String principal;
        private String password;
        private int requestTimeout;

        public Builder(int apiKey, String apiSecret) {
            this.apiKey = apiKey;
            this.apiSecret = apiSecret;
        }

        public Builder apiUrl(String apiUrl) {
            this.apiUrl = apiUrl;
            return this;
        }

        public Builder proxy(Proxy proxy) {
            this.proxy(proxy, null, null, null);
            return this;
        }

        public Builder requestTimeout(int requestTimeout) {
            this.requestTimeout = requestTimeout * 1000;
            return this;
        }

        public Builder proxy(Proxy proxy, HttpClient.ProxyAuthScheme proxyAuthScheme, String principal, String password) {
            this.proxy = proxy;
            this.proxyAuthScheme = proxyAuthScheme;
            this.principal = principal;
            this.password = password;
            return this;
        }

        public Builder appendToUserAgent(String appendUserAgent) {
            this.appendUserAgent = appendUserAgent;
            return this;
        }

        public OpenTok build() {
            HttpClient.Builder clientBuilder = new HttpClient.Builder(this.apiKey, this.apiSecret);
            if (this.apiUrl != null) {
                clientBuilder.apiUrl(this.apiUrl);
            }
            if (this.proxy != null) {
                clientBuilder.proxy(this.proxy, this.proxyAuthScheme, this.principal, this.password);
            }
            if (this.requestTimeout != 0) {
                clientBuilder.requestTimeoutMS(this.requestTimeout);
            }
            if (this.appendUserAgent != null && !this.appendUserAgent.trim().isEmpty()) {
                clientBuilder.userAgent(DefaultUserAgent.DEFAULT_USER_AGENT + " " + this.appendUserAgent);
            }
            return new OpenTok(this.apiKey, this.apiSecret, clientBuilder.build());
        }
    }
}

