/*
 * Decompiled with CFR 0.152.
 */
package com.opentok;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum Resolution {
    SD_HORIZONTAL("640x480"),
    SD_VERTICAL("480x640"),
    HD_HORIZONTAL("1280x720"),
    HD_VERTICAL("720x1280"),
    FHD_HORIZONTAL("1920x1080"),
    FHD_VERTICAL("1080x1920");

    private static final Map<String, Resolution> RESOLUTION_INDEX;
    private final String value;

    private Resolution(String value) {
        this.value = value;
    }

    @JsonValue
    public String toString() {
        return this.value;
    }

    @JsonCreator
    public static Resolution fromString(String resolution) {
        return RESOLUTION_INDEX.getOrDefault(resolution, null);
    }

    static {
        RESOLUTION_INDEX = Arrays.stream(Resolution.values()).collect(Collectors.toMap(Resolution::toString, Function.identity()));
    }
}

