/*
 * Decompiled with CFR 0.152.
 */
package com.opentok;

import com.opentok.Role;
import com.opentok.SessionProperties;
import com.opentok.TokenOptions;
import com.opentok.exception.InvalidArgumentException;
import com.opentok.exception.OpenTokException;
import com.opentok.util.Crypto;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.Random;
import org.apache.commons.codec.binary.Base64;

public class Session {
    private String sessionId;
    private int apiKey;
    private String apiSecret;
    private SessionProperties properties;

    protected Session(String sessionId, int apiKey, String apiSecret) {
        this(sessionId, apiKey, apiSecret, new SessionProperties.Builder().build());
    }

    protected Session(String sessionId, int apiKey, String apiSecret, SessionProperties properties) {
        this.sessionId = sessionId;
        this.apiKey = apiKey;
        this.apiSecret = apiSecret;
        this.properties = properties;
    }

    public int getApiKey() {
        return this.apiKey;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public SessionProperties getProperties() {
        return this.properties;
    }

    public String generateToken() throws OpenTokException {
        return this.generateToken(new TokenOptions.Builder().build());
    }

    public String generateToken(TokenOptions tokenOptions) throws OpenTokException {
        if (tokenOptions == null) {
            throw new InvalidArgumentException("Token options cannot be null");
        }
        Role role = tokenOptions.getRole();
        double expireTime = tokenOptions.getExpireTime();
        String data = tokenOptions.getData();
        long create_time = System.currentTimeMillis() / 1000L;
        StringBuilder dataStringBuilder = new StringBuilder();
        Random random = new Random();
        int nonce = random.nextInt();
        dataStringBuilder.append("session_id=").append(this.sessionId).append("&create_time=").append(create_time).append("&nonce=").append(nonce).append("&role=").append((Object)role);
        if (tokenOptions.getInitialLayoutClassList() != null) {
            dataStringBuilder.append("&initial_layout_class_list=");
            dataStringBuilder.append(String.join((CharSequence)" ", tokenOptions.getInitialLayoutClassList()));
        }
        long now = System.currentTimeMillis() / 1000L;
        if (expireTime == 0.0) {
            expireTime = now + 86400L;
        } else {
            if (expireTime < (double)now) {
                throw new InvalidArgumentException("Expire time must be in the future. Relative time: " + (expireTime - (double)now));
            }
            if (expireTime > (double)(now + 2592000L)) {
                throw new InvalidArgumentException("Expire time must be in the next 30 days. Too large by " + (expireTime - (double)(now + 2592000L)));
            }
        }
        dataStringBuilder.append(String.format("&expire_time=%.0f", expireTime));
        if (data != null) {
            if (data.length() > 1000) {
                throw new InvalidArgumentException("Connection data must be less than 1000 characters. length: " + data.length());
            }
            dataStringBuilder.append("&connection_data=");
            try {
                dataStringBuilder.append(URLEncoder.encode(data, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new InvalidArgumentException("Error during URL encode of your connection data: " + e.getMessage());
            }
        }
        StringBuilder tokenStringBuilder = new StringBuilder();
        try {
            tokenStringBuilder.append("T1==");
            String innerBuilder = "partner_id=" + this.apiKey + "&sig=" + Crypto.signData(dataStringBuilder.toString(), this.apiSecret) + ":" + dataStringBuilder;
            tokenStringBuilder.append(Base64.encodeBase64String((byte[])innerBuilder.getBytes(StandardCharsets.UTF_8)).replace("+", "-").replace("/", "_"));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new OpenTokException("Could not generate token, a signing error occurred.", e);
        }
        return tokenStringBuilder.toString();
    }
}

