/*
 * Decompiled with CFR 0.152.
 */
package com.opentok;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.opentok.Rtmp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Broadcast {
    @JsonProperty
    private String id;
    @JsonProperty
    private String sessionId;
    @JsonProperty
    private int projectId;
    @JsonProperty
    private long createdAt;
    @JsonProperty
    private long updatedAt;
    @JsonProperty
    private int maxDuration;
    @JsonProperty
    private int maxBitrate;
    @JsonProperty
    private String resolution;
    @JsonProperty
    private String status;
    @JsonProperty
    private String hlsStatus;
    @JsonProperty
    private String multiBroadcastTag;
    @JsonProperty
    private boolean hasAudio = true;
    @JsonProperty
    private boolean hasVideo = true;
    @JsonProperty
    private StreamMode streamMode = StreamMode.AUTO;
    private List<Rtmp> rtmpList = new ArrayList<Rtmp>(5);
    private String hls;

    protected Broadcast() {
    }

    @JsonCreator
    public static Broadcast makeBroadcast() {
        return new Broadcast();
    }

    public String getId() {
        return this.id;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public int getProjectId() {
        return this.projectId;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public long getUpdatedAt() {
        return this.updatedAt;
    }

    public int getMaxDuration() {
        return this.maxDuration;
    }

    public int getMaxBitrate() {
        return this.maxBitrate;
    }

    public String getResolution() {
        return this.resolution;
    }

    public String getStatus() {
        return this.status;
    }

    public String getMultiBroadcastTag() {
        return this.multiBroadcastTag;
    }

    @JsonProperty(value="broadcastUrls")
    private void unpack(Map<String, Object> broadcastUrls) {
        if (broadcastUrls == null) {
            return;
        }
        this.hls = (String)broadcastUrls.get("hls");
        this.hlsStatus = (String)broadcastUrls.get("hlsStatus");
        Iterable rtmpResponse = (Iterable)broadcastUrls.get("rtmp");
        if (rtmpResponse == null) {
            return;
        }
        for (Map element : rtmpResponse) {
            Rtmp rtmp = new Rtmp();
            rtmp.setId((String)element.get("id"));
            rtmp.setServerUrl((String)element.get("serverUrl"));
            rtmp.setStreamName((String)element.get("streamName"));
            rtmp.setStatus((String)element.get("status"));
            this.rtmpList.add(rtmp);
        }
    }

    public String getHls() {
        return this.hls;
    }

    public String getHlsStatus() {
        return this.hlsStatus;
    }

    public List<Rtmp> getRtmpList() {
        return this.rtmpList;
    }

    public boolean hasAudio() {
        return this.hasAudio;
    }

    public boolean hasVideo() {
        return this.hasVideo;
    }

    public StreamMode getStreamMode() {
        return this.streamMode;
    }

    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            return "";
        }
    }

    public static enum StreamMode {
        AUTO,
        MANUAL;


        @JsonValue
        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

