/*
 * Decompiled with CFR 0.152.
 */
package com.opentok;

import com.opentok.ArchiveLayout;
import com.opentok.Broadcast;
import com.opentok.BroadcastLayout;
import com.opentok.Hls;
import com.opentok.RtmpProperties;
import com.opentok.exception.InvalidArgumentException;
import java.util.ArrayList;
import java.util.List;

public class BroadcastProperties {
    private final BroadcastLayout layout;
    private final int maxDuration;
    private final int maxBitrate;
    private final boolean hasHls;
    private final boolean hasAudio;
    private final boolean hasVideo;
    private final List<RtmpProperties> rtmpList;
    private final String resolution;
    private final String multiBroadcastTag;
    private final Broadcast.StreamMode streamMode;
    private final Hls hls;

    private BroadcastProperties(Builder builder) {
        this.layout = builder.layout;
        this.maxDuration = builder.maxDuration;
        this.maxBitrate = builder.maxBitrate;
        this.hasHls = builder.hasHls;
        this.hasAudio = builder.hasAudio;
        this.hasVideo = builder.hasVideo;
        this.hls = builder.hls;
        this.rtmpList = builder.rtmpList;
        this.resolution = builder.resolution;
        this.streamMode = builder.streamMode;
        this.multiBroadcastTag = builder.multiBroadcastTag;
    }

    public BroadcastLayout layout() {
        return this.layout;
    }

    public int maxDuration() {
        return this.maxDuration;
    }

    public int maxBitrate() {
        return this.maxBitrate;
    }

    public boolean hasHls() {
        return this.hasHls;
    }

    public boolean hasAudio() {
        return this.hasAudio;
    }

    public boolean hasVideo() {
        return this.hasVideo;
    }

    public Hls hls() {
        return this.hls;
    }

    public List<RtmpProperties> rtmpList() {
        return this.rtmpList;
    }

    public String resolution() {
        return this.resolution;
    }

    public String getMultiBroadcastTag() {
        return this.multiBroadcastTag;
    }

    public Broadcast.StreamMode streamMode() {
        return this.streamMode;
    }

    public static class Builder {
        private BroadcastLayout layout = new BroadcastLayout(ArchiveLayout.Type.BESTFIT);
        private int maxDuration = 7200;
        private int maxBitrate = 2000000;
        private boolean hasHls = false;
        private boolean hasAudio = true;
        private boolean hasVideo = true;
        private String multiBroadcastTag;
        private Hls hls;
        private final List<RtmpProperties> rtmpList = new ArrayList<RtmpProperties>(5);
        private String resolution = "640x480";
        private Broadcast.StreamMode streamMode = Broadcast.StreamMode.AUTO;

        public Builder layout(BroadcastLayout layout) {
            this.layout = layout;
            return this;
        }

        public Builder maxDuration(int maxDuration) throws InvalidArgumentException {
            if (maxDuration < 60 || maxDuration > 36000) {
                throw new InvalidArgumentException("maxDuration value must be between 60 and 36000 (inclusive).");
            }
            this.maxDuration = maxDuration;
            return this;
        }

        public Builder maxBitrate(int maxBitrate) throws InvalidArgumentException {
            if (maxBitrate < 100000 || maxBitrate > 6000000) {
                throw new InvalidArgumentException("maxBitrate value must be between 100_000 and 6_000_000.");
            }
            this.maxBitrate = maxBitrate;
            return this;
        }

        public Builder hasHls(boolean hasHls) {
            this.hasHls = hasHls;
            return this;
        }

        public Builder hls(Hls hls) {
            this.hls = hls;
            return this.hasHls(this.hls != null);
        }

        public Builder hasAudio(boolean hasAudio) {
            this.hasAudio = hasAudio;
            return this;
        }

        public Builder hasVideo(boolean hasVideo) {
            this.hasVideo = hasVideo;
            return this;
        }

        public Builder addRtmpProperties(RtmpProperties rtmpProps) throws InvalidArgumentException {
            if (this.rtmpList.size() >= 5) {
                throw new InvalidArgumentException("Cannot add more than 5 RtmpProperties properties");
            }
            this.rtmpList.add(rtmpProps);
            return this;
        }

        public Builder resolution(String resolution) {
            this.resolution = resolution;
            return this;
        }

        public Builder streamMode(Broadcast.StreamMode streamMode) {
            this.streamMode = streamMode;
            return this;
        }

        public Builder multiBroadcastTag(String multiBroadcastTag) {
            this.multiBroadcastTag = multiBroadcastTag;
            return this;
        }

        public BroadcastProperties build() {
            return new BroadcastProperties(this);
        }
    }
}

