/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.fontbox.cff;

import com.tom_roush.fontbox.FontBoxFont;
import com.tom_roush.fontbox.cff.CFFCharset;
import com.tom_roush.fontbox.cff.IndexData;
import com.tom_roush.fontbox.cff.Type2CharString;
import com.tom_roush.fontbox.util.BoundingBox;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class CFFFont
implements FontBoxFont {
    protected String fontName;
    protected final Map<String, Object> topDict = new LinkedHashMap<String, Object>();
    protected CFFCharset charset;
    protected final List<byte[]> charStrings = new ArrayList<byte[]>();
    protected IndexData globalSubrIndex;
    private byte[] data;

    @Override
    public String getName() {
        return this.fontName;
    }

    void setName(String name) {
        this.fontName = name;
    }

    public void addValueToTopDict(String name, Object value) {
        if (value != null) {
            this.topDict.put(name, value);
        }
    }

    public Map<String, Object> getTopDict() {
        return this.topDict;
    }

    @Override
    public abstract List<Number> getFontMatrix();

    @Override
    public BoundingBox getFontBBox() {
        List numbers = (List)this.topDict.get("FontBBox");
        return new BoundingBox(numbers);
    }

    public CFFCharset getCharset() {
        return this.charset;
    }

    void setCharset(CFFCharset charset) {
        this.charset = charset;
    }

    List<byte[]> getCharStringBytes() {
        return this.charStrings;
    }

    void setData(byte[] data) {
        this.data = data;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getNumCharStrings() {
        return this.charStrings.size();
    }

    void setGlobalSubrIndex(IndexData globalSubrIndexValue) {
        this.globalSubrIndex = globalSubrIndexValue;
    }

    public IndexData getGlobalSubrIndex() {
        return this.globalSubrIndex;
    }

    public abstract Type2CharString getType2CharString(int var1) throws IOException;

    public String toString() {
        return this.getClass().getSimpleName() + "[name=" + this.fontName + ", topDict=" + this.topDict + ", charset=" + this.charset + ", charStrings=" + this.charStrings + "]";
    }
}

