/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.fontbox.cff;

import com.tom_roush.fontbox.cff.CharStringCommand;
import java.io.ByteArrayOutputStream;
import java.util.List;

public class Type1CharStringFormatter {
    private ByteArrayOutputStream output = null;

    public byte[] format(List<Object> sequence) {
        this.output = new ByteArrayOutputStream();
        for (Object object : sequence) {
            if (object instanceof CharStringCommand) {
                this.writeCommand((CharStringCommand)object);
                continue;
            }
            if (object instanceof Integer) {
                this.writeNumber((Integer)object);
                continue;
            }
            throw new IllegalArgumentException();
        }
        return this.output.toByteArray();
    }

    private void writeCommand(CharStringCommand command) {
        int[] value = command.getKey().getValue();
        for (int i = 0; i < value.length; ++i) {
            this.output.write(value[i]);
        }
    }

    private void writeNumber(Integer number) {
        int value = number;
        if (value >= -107 && value <= 107) {
            this.output.write(value + 139);
        } else if (value >= 108 && value <= 1131) {
            int b1 = (value - 108) % 256;
            int b0 = (value - 108 - b1) / 256 + 247;
            this.output.write(b0);
            this.output.write(b1);
        } else if (value >= -1131 && value <= -108) {
            int b1 = -((value + 108) % 256);
            int b0 = -((value + 108 + b1) / 256 - 251);
            this.output.write(b0);
            this.output.write(b1);
        } else {
            int b1 = value >>> 24 & 0xFF;
            int b2 = value >>> 16 & 0xFF;
            int b3 = value >>> 8 & 0xFF;
            int b4 = value >>> 0 & 0xFF;
            this.output.write(255);
            this.output.write(b1);
            this.output.write(b2);
            this.output.write(b3);
            this.output.write(b4);
        }
    }
}

