/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.filter;

import android.util.Log;
import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.filter.DecodeResult;
import com.tom_roush.pdfbox.filter.Filter;
import com.tom_roush.pdfbox.filter.Predictor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DataFormatException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;

final class FlateFilter
extends Filter {
    private static final int BUFFER_SIZE = 16348;

    FlateFilter() {
    }

    @Override
    public DecodeResult decode(InputStream encoded, OutputStream decoded, COSDictionary parameters, int index) throws IOException {
        int predictor = -1;
        COSDictionary decodeParams = FlateFilter.getDecodeParams(parameters, index);
        if (decodeParams != null) {
            predictor = decodeParams.getInt(COSName.PREDICTOR);
        }
        try {
            if (predictor > 1) {
                int colors = Math.min(decodeParams.getInt(COSName.COLORS, 1), 32);
                int bitsPerPixel = decodeParams.getInt(COSName.BITS_PER_COMPONENT, 8);
                int columns = decodeParams.getInt(COSName.COLUMNS, 1);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                FlateFilter.decompress(encoded, baos);
                ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                Predictor.decodePredictor(predictor, colors, bitsPerPixel, columns, bais, decoded);
                decoded.flush();
                baos.reset();
                bais.reset();
            } else {
                FlateFilter.decompress(encoded, decoded);
            }
        }
        catch (DataFormatException e) {
            Log.e((String)"PdfBox-Android", (String)"FlateFilter: stop reading corrupt stream due to a DataFormatException");
            throw new IOException(e);
        }
        return new DecodeResult(parameters);
    }

    private static void decompress(InputStream in, OutputStream out) throws IOException, DataFormatException {
        byte[] buf = new byte[2048];
        int read = in.read(buf);
        if (read > 0) {
            Inflater inflater = new Inflater();
            inflater.setInput(buf, 0, read);
            byte[] res = new byte[2048];
            while (true) {
                int resRead;
                if ((resRead = inflater.inflate(res)) != 0) {
                    out.write(res, 0, resRead);
                    continue;
                }
                if (inflater.finished() || inflater.needsDictionary() || in.available() == 0) break;
                read = in.read(buf);
                inflater.setInput(buf, 0, read);
            }
        }
        out.flush();
    }

    @Override
    protected void encode(InputStream input, OutputStream encoded, COSDictionary parameters) throws IOException {
        DeflaterOutputStream out = new DeflaterOutputStream(encoded);
        int mayRead = input.available();
        if (mayRead > 0) {
            int amountRead;
            byte[] buffer = new byte[Math.min(mayRead, 16348)];
            while ((amountRead = input.read(buffer, 0, Math.min(mayRead, 16348))) != -1) {
                out.write(buffer, 0, amountRead);
            }
        }
        out.close();
        encoded.flush();
    }
}

