/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.fdf;

import android.util.Log;
import com.tom_roush.harmony.awt.AWTColor;
import com.tom_roush.pdfbox.cos.COSArray;
import com.tom_roush.pdfbox.cos.COSBase;
import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.pdmodel.fdf.FDFAnnotation;
import java.io.IOException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Element;

public class FDFAnnotationPolygon
extends FDFAnnotation {
    public static final String SUBTYPE = "Polygon";

    public FDFAnnotationPolygon() {
        this.annot.setName(COSName.SUBTYPE, SUBTYPE);
    }

    public FDFAnnotationPolygon(COSDictionary a) {
        super(a);
    }

    public FDFAnnotationPolygon(Element element) throws IOException {
        super(element);
        this.annot.setName(COSName.SUBTYPE, SUBTYPE);
        this.initVertices(element);
        String color = element.getAttribute("interior-color");
        if (color != null && color.length() == 7 && color.charAt(0) == '#') {
            int colorValue = Integer.parseInt(color.substring(1, 7), 16);
            this.setInteriorColor(new AWTColor(colorValue));
        }
    }

    private void initVertices(Element element) throws IOException, NumberFormatException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            String vertices = xpath.evaluate("vertices", element);
            if (vertices == null || vertices.isEmpty()) {
                throw new IOException("Error: missing element 'vertices'");
            }
            String[] verticesValues = vertices.split(",");
            float[] values = new float[verticesValues.length];
            for (int i = 0; i < verticesValues.length; ++i) {
                values[i] = Float.parseFloat(verticesValues[i]);
            }
            this.setVertices(values);
        }
        catch (XPathExpressionException e) {
            Log.d((String)"PdfBox-Android", (String)"Error while evaluating XPath expression for polygon vertices");
        }
    }

    public void setVertices(float[] vertices) {
        COSArray newVertices = new COSArray();
        newVertices.setFloatArray(vertices);
        this.annot.setItem(COSName.VERTICES, (COSBase)newVertices);
    }

    public float[] getVertices() {
        COSArray array = (COSArray)this.annot.getDictionaryObject(COSName.VERTICES);
        if (array != null) {
            return array.toFloatArray();
        }
        return null;
    }

    public void setInteriorColor(AWTColor color) {
        COSArray array = null;
        if (color != null) {
            float[] colors = color.getRGBColorComponents(null);
            array = new COSArray();
            array.setFloatArray(colors);
        }
        this.annot.setItem(COSName.IC, array);
    }

    public AWTColor getInteriorColor() {
        float[] rgb;
        AWTColor retval = null;
        COSArray array = (COSArray)this.annot.getDictionaryObject(COSName.IC);
        if (array != null && (rgb = array.toFloatArray()).length >= 3) {
            retval = new AWTColor(rgb[0], rgb[1], rgb[2]);
        }
        return retval;
    }
}

