/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.font;

import android.graphics.Path;
import android.graphics.PointF;
import android.util.Log;
import com.tom_roush.fontbox.EncodedFont;
import com.tom_roush.fontbox.FontBoxFont;
import com.tom_roush.fontbox.cff.CFFParser;
import com.tom_roush.fontbox.cff.CFFType1Font;
import com.tom_roush.fontbox.util.BoundingBox;
import com.tom_roush.harmony.awt.geom.AffineTransform;
import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.io.IOUtils;
import com.tom_roush.pdfbox.pdmodel.common.PDStream;
import com.tom_roush.pdfbox.pdmodel.font.FontMapper;
import com.tom_roush.pdfbox.pdmodel.font.FontMapping;
import com.tom_roush.pdfbox.pdmodel.font.PDFontDescriptor;
import com.tom_roush.pdfbox.pdmodel.font.PDSimpleFont;
import com.tom_roush.pdfbox.pdmodel.font.encoding.Encoding;
import com.tom_roush.pdfbox.pdmodel.font.encoding.StandardEncoding;
import com.tom_roush.pdfbox.pdmodel.font.encoding.Type1Encoding;
import com.tom_roush.pdfbox.util.Matrix;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PDType1CFont
extends PDSimpleFont {
    private final Map<String, Float> glyphHeights = new HashMap<String, Float>();
    private Float avgWidth = null;
    private Matrix fontMatrix;
    private final AffineTransform fontMatrixTransform;
    private final CFFType1Font cffFont;
    private final FontBoxFont genericFont;
    private final boolean isEmbedded;
    private final boolean isDamaged;

    public PDType1CFont(COSDictionary fontDictionary) throws IOException {
        super(fontDictionary);
        PDStream ff3Stream;
        PDFontDescriptor fd = this.getFontDescriptor();
        byte[] bytes = null;
        if (fd != null && (ff3Stream = fd.getFontFile3()) != null && (bytes = IOUtils.toByteArray(ff3Stream.createInputStream())).length == 0) {
            Log.e((String)"PdfBox-Android", (String)("Invalid data for embedded Type1C font " + this.getName()));
            bytes = null;
        }
        boolean fontIsDamaged = false;
        CFFType1Font cffEmbedded = null;
        try {
            if (bytes != null) {
                CFFParser cffParser = new CFFParser();
                cffEmbedded = (CFFType1Font)cffParser.parse(bytes).get(0);
            }
        }
        catch (IOException e) {
            Log.e((String)"PdfBox-Android", (String)("Can't read the embedded Type1C font " + this.getName()), (Throwable)e);
            fontIsDamaged = true;
        }
        this.isDamaged = fontIsDamaged;
        this.cffFont = cffEmbedded;
        if (this.cffFont != null) {
            this.genericFont = this.cffFont;
            this.isEmbedded = true;
        } else {
            FontMapping<FontBoxFont> mapping = FontMapper.getFontBoxFont(this.getBaseFont(), fd);
            this.genericFont = mapping.getFont();
            if (mapping.isFallback()) {
                Log.w((String)"PdfBox-Android", (String)("Using fallback font " + this.genericFont.getName() + " for " + this.getBaseFont()));
            }
            this.isEmbedded = false;
        }
        this.readEncoding();
        this.fontMatrixTransform = this.getFontMatrix().createAffineTransform();
        this.fontMatrixTransform.scale(1000.0, 1000.0);
    }

    @Override
    public FontBoxFont getFontBoxFont() {
        return this.genericFont;
    }

    public final String getBaseFont() {
        return this.dict.getNameAsString(COSName.BASE_FONT);
    }

    @Override
    public Path getPath(String name) throws IOException {
        if (this.isEmbedded() && name.equals(".notdef") && !this.isEmbedded() && !this.isStandard14()) {
            return new Path();
        }
        return this.genericFont.getPath(name);
    }

    @Override
    public boolean hasGlyph(String name) throws IOException {
        return this.genericFont.hasGlyph(name);
    }

    @Override
    public final String getName() {
        return this.getBaseFont();
    }

    @Override
    public BoundingBox getBoundingBox() throws IOException {
        return this.genericFont.getFontBBox();
    }

    public String codeToName(int code) {
        return this.getEncoding().getName(code);
    }

    @Override
    protected Encoding readEncodingFromFont() throws IOException {
        if (this.getStandard14AFM() != null) {
            return new Type1Encoding(this.getStandard14AFM());
        }
        if (this.genericFont instanceof EncodedFont) {
            return Type1Encoding.fromFontBox(((EncodedFont)((Object)this.genericFont)).getEncoding());
        }
        return StandardEncoding.INSTANCE;
    }

    @Override
    public int readCode(InputStream in) throws IOException {
        return in.read();
    }

    @Override
    public final Matrix getFontMatrix() {
        if (this.fontMatrix == null) {
            List<Number> numbers = null;
            try {
                numbers = this.genericFont.getFontMatrix();
            }
            catch (IOException e) {
                this.fontMatrix = DEFAULT_FONT_MATRIX;
            }
            if (numbers != null && numbers.size() == 6) {
                this.fontMatrix = new Matrix(numbers.get(0).floatValue(), numbers.get(1).floatValue(), numbers.get(2).floatValue(), numbers.get(3).floatValue(), numbers.get(4).floatValue(), numbers.get(5).floatValue());
            } else {
                return super.getFontMatrix();
            }
        }
        return this.fontMatrix;
    }

    @Override
    public boolean isDamaged() {
        return this.isDamaged;
    }

    @Override
    public float getWidthFromFont(int code) throws IOException {
        String name = this.codeToName(code);
        float width = this.genericFont.getWidth(name);
        PointF p = new PointF(width, 0.0f);
        this.fontMatrixTransform.transform(p, p);
        return p.x;
    }

    @Override
    public boolean isEmbedded() {
        return this.isEmbedded;
    }

    @Override
    public float getHeight(int code) throws IOException {
        String name = this.codeToName(code);
        float height = 0.0f;
        if (!this.glyphHeights.containsKey(name)) {
            height = this.cffFont.getType1CharString(name).getBounds().height();
            this.glyphHeights.put(name, Float.valueOf(height));
        }
        return height;
    }

    @Override
    protected byte[] encode(int unicode) throws IOException {
        throw new UnsupportedOperationException("Not implemented: Type1C");
    }

    @Override
    public float getStringWidth(String string) throws IOException {
        float width = 0.0f;
        for (int i = 0; i < string.length(); ++i) {
            int codePoint = string.codePointAt(i);
            String name = this.getGlyphList().codePointToName(codePoint);
            width += (float)this.cffFont.getType1CharString(name).getWidth();
        }
        return width;
    }

    @Override
    public float getAverageFontWidth() {
        if (this.avgWidth == null) {
            this.avgWidth = Float.valueOf(this.getAverageCharacterWidth());
        }
        return this.avgWidth.floatValue();
    }

    public CFFType1Font getCFFType1Font() {
        return this.cffFont;
    }

    private float getAverageCharacterWidth() {
        return 500.0f;
    }
}

