/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.graphics.form;

import com.tom_roush.harmony.awt.geom.AffineTransform;
import com.tom_roush.pdfbox.contentstream.PDContentStream;
import com.tom_roush.pdfbox.cos.COSArray;
import com.tom_roush.pdfbox.cos.COSBase;
import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.cos.COSFloat;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.cos.COSStream;
import com.tom_roush.pdfbox.pdmodel.PDDocument;
import com.tom_roush.pdfbox.pdmodel.PDResources;
import com.tom_roush.pdfbox.pdmodel.ResourceCache;
import com.tom_roush.pdfbox.pdmodel.common.COSObjectable;
import com.tom_roush.pdfbox.pdmodel.common.PDRectangle;
import com.tom_roush.pdfbox.pdmodel.common.PDStream;
import com.tom_roush.pdfbox.pdmodel.graphics.PDXObject;
import com.tom_roush.pdfbox.pdmodel.graphics.form.PDGroup;
import com.tom_roush.pdfbox.util.Matrix;
import java.io.IOException;
import java.io.InputStream;

public class PDFormXObject
extends PDXObject
implements PDContentStream {
    private PDGroup group;
    private final ResourceCache cache;

    public PDFormXObject(PDStream stream) {
        super(stream, COSName.FORM);
        this.cache = null;
    }

    public PDFormXObject(COSStream stream) {
        super(stream, COSName.FORM);
        this.cache = null;
    }

    public PDFormXObject(COSStream stream, ResourceCache cache) {
        super(stream, COSName.FORM);
        this.cache = cache;
    }

    public PDFormXObject(PDDocument document) {
        super(document, COSName.FORM);
        this.cache = null;
    }

    public int getFormType() {
        return this.getCOSStream().getInt(COSName.FORMTYPE, 1);
    }

    public void setFormType(int formType) {
        this.getCOSStream().setInt(COSName.FORMTYPE, formType);
    }

    public PDGroup getGroup() {
        COSDictionary dic;
        if (this.group == null && (dic = (COSDictionary)this.getCOSStream().getDictionaryObject(COSName.GROUP)) != null) {
            this.group = new PDGroup(dic);
        }
        return this.group;
    }

    public PDStream getContentStream() {
        return new PDStream(this.getCOSStream());
    }

    @Override
    public InputStream getContents() throws IOException {
        return this.getCOSStream().createInputStream();
    }

    @Override
    public PDResources getResources() {
        COSDictionary resources = (COSDictionary)this.getCOSStream().getDictionaryObject(COSName.RESOURCES);
        if (resources != null) {
            return new PDResources(resources, this.cache);
        }
        return null;
    }

    public void setResources(PDResources resources) {
        this.getCOSStream().setItem(COSName.RESOURCES, (COSObjectable)resources);
    }

    @Override
    public PDRectangle getBBox() {
        PDRectangle retval = null;
        COSArray array = (COSArray)this.getCOSStream().getDictionaryObject(COSName.BBOX);
        if (array != null) {
            retval = new PDRectangle(array);
        }
        return retval;
    }

    public void setBBox(PDRectangle bbox) {
        if (bbox == null) {
            this.getCOSStream().removeItem(COSName.BBOX);
        } else {
            this.getCOSStream().setItem(COSName.BBOX, (COSBase)bbox.getCOSArray());
        }
    }

    @Override
    public Matrix getMatrix() {
        COSArray array = (COSArray)this.getCOSStream().getDictionaryObject(COSName.MATRIX);
        if (array != null) {
            return new Matrix(array);
        }
        return new Matrix();
    }

    public void setMatrix(AffineTransform transform) {
        COSArray matrix = new COSArray();
        double[] values = new double[6];
        transform.getMatrix(values);
        for (double v : values) {
            matrix.add(new COSFloat((float)v));
        }
        this.getCOSStream().setItem(COSName.MATRIX, (COSBase)matrix);
    }

    public int getStructParents() {
        return this.getCOSStream().getInt(COSName.STRUCT_PARENTS, 0);
    }

    public void setStructParents(int structParent) {
        this.getCOSStream().setInt(COSName.STRUCT_PARENTS, structParent);
    }
}

