/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.graphics.image;

import android.graphics.Bitmap;
import android.graphics.Color;
import com.tom_roush.harmony.javax.imageio.stream.MemoryCacheImageOutputStream;
import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.filter.Filter;
import com.tom_roush.pdfbox.filter.FilterFactory;
import com.tom_roush.pdfbox.pdmodel.PDDocument;
import com.tom_roush.pdfbox.pdmodel.common.COSObjectable;
import com.tom_roush.pdfbox.pdmodel.graphics.color.PDColorSpace;
import com.tom_roush.pdfbox.pdmodel.graphics.color.PDDeviceColorSpace;
import com.tom_roush.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import com.tom_roush.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import com.tom_roush.pdfbox.pdmodel.graphics.image.PDImageXObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public final class LosslessFactory {
    private LosslessFactory() {
    }

    public static PDImageXObject createFromImage(PDDocument document, Bitmap image) throws IOException {
        byte[] imageData;
        PDDeviceColorSpace deviceColorSpace;
        int bpc;
        int height = image.getHeight();
        int width = image.getWidth();
        if (image.getConfig() == Bitmap.Config.ALPHA_8) {
            bpc = 8;
            deviceColorSpace = PDDeviceGray.INSTANCE;
            ByteArrayOutputStream bos = new ByteArrayOutputStream(width * bpc / 8 + (width * bpc % 8 != 0 ? 1 : 0) * height);
            MemoryCacheImageOutputStream mcios = new MemoryCacheImageOutputStream(bos);
            int[] imagePixels = new int[width * height];
            image.getPixels(imagePixels, 0, width, 0, 0, width, height);
            for (int y = 0; y < height; ++y) {
                for (int pixelIdx = width * y; pixelIdx < (y + 1) * width; ++pixelIdx) {
                    mcios.writeBits(imagePixels[pixelIdx] & 0xFF, bpc);
                }
                int bitOffset = mcios.getBitOffset();
                if (bitOffset == 0) continue;
                mcios.writeBits(0L, 8 - bitOffset);
            }
            mcios.flush();
            mcios.close();
            imageData = bos.toByteArray();
        } else {
            bpc = 8;
            deviceColorSpace = PDDeviceRGB.INSTANCE;
            imageData = new byte[width * height * 3];
            int byteIdx = 0;
            int[] imagePixels = new int[width * height];
            image.getPixels(imagePixels, 0, width, 0, 0, width, height);
            for (int pixel : imagePixels) {
                imageData[byteIdx++] = (byte)(pixel >> 16 & 0xFF);
                imageData[byteIdx++] = (byte)(pixel >> 8 & 0xFF);
                imageData[byteIdx++] = (byte)(pixel & 0xFF);
            }
        }
        PDImageXObject pdImage = LosslessFactory.prepareImageXObject(document, imageData, image.getWidth(), image.getHeight(), bpc, deviceColorSpace);
        PDImageXObject xAlpha = LosslessFactory.createAlphaFromARGBImage(document, image);
        if (xAlpha != null) {
            pdImage.getCOSStream().setItem(COSName.SMASK, (COSObjectable)xAlpha);
        }
        return pdImage;
    }

    private static PDImageXObject createAlphaFromARGBImage(PDDocument document, Bitmap image) throws IOException {
        if (!image.hasAlpha()) {
            return null;
        }
        int[] pixels = new int[image.getHeight() * image.getWidth()];
        image.getPixels(pixels, 0, image.getWidth(), 0, 0, image.getWidth(), image.getHeight());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int bpc = 8;
        for (int pixel : pixels) {
            bos.write(Color.alpha((int)pixel));
        }
        PDImageXObject pdImage = LosslessFactory.prepareImageXObject(document, bos.toByteArray(), image.getWidth(), image.getHeight(), bpc, PDDeviceGray.INSTANCE);
        return pdImage;
    }

    private static PDImageXObject prepareImageXObject(PDDocument document, byte[] byteArray, int width, int height, int bitsPerComponent, PDColorSpace initColorSpace) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(byteArray.length / 2);
        Filter filter = FilterFactory.INSTANCE.getFilter(COSName.FLATE_DECODE);
        filter.encode(new ByteArrayInputStream(byteArray), baos, new COSDictionary(), 0);
        ByteArrayInputStream encodedByteStream = new ByteArrayInputStream(baos.toByteArray());
        return new PDImageXObject(document, encodedByteStream, COSName.FLATE_DECODE, width, height, bitsPerComponent, initColorSpace);
    }
}

