/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.graphics.image;

import android.graphics.Bitmap;
import android.graphics.Paint;
import com.tom_roush.pdfbox.cos.COSArray;
import com.tom_roush.pdfbox.cos.COSBase;
import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.filter.DecodeResult;
import com.tom_roush.pdfbox.filter.Filter;
import com.tom_roush.pdfbox.filter.FilterFactory;
import com.tom_roush.pdfbox.pdmodel.PDResources;
import com.tom_roush.pdfbox.pdmodel.common.COSArrayList;
import com.tom_roush.pdfbox.pdmodel.common.PDStream;
import com.tom_roush.pdfbox.pdmodel.graphics.color.PDColorSpace;
import com.tom_roush.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import com.tom_roush.pdfbox.pdmodel.graphics.image.PDImage;
import com.tom_roush.pdfbox.pdmodel.graphics.image.SampledImageReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public final class PDInlineImage
implements PDImage {
    private final COSDictionary parameters;
    private final PDResources resources;
    private final byte[] rawData;
    private final byte[] decodedData;

    public PDInlineImage(COSDictionary parameters, byte[] data, PDResources resources) throws IOException {
        this.parameters = parameters;
        this.resources = resources;
        this.rawData = data;
        DecodeResult decodeResult = null;
        List<String> filters = this.getFilters();
        if (filters == null || filters.isEmpty()) {
            this.decodedData = data;
        } else {
            ByteArrayInputStream in = new ByteArrayInputStream(data);
            ByteArrayOutputStream out = new ByteArrayOutputStream(data.length);
            for (int i = 0; i < filters.size(); ++i) {
                out.reset();
                Filter filter = FilterFactory.INSTANCE.getFilter(filters.get(i));
                decodeResult = filter.decode(in, out, parameters, i);
                in = new ByteArrayInputStream(out.toByteArray());
            }
            this.decodedData = out.toByteArray();
        }
        if (decodeResult != null) {
            parameters.addAll(decodeResult.getParameters());
        }
    }

    @Override
    public COSBase getCOSObject() {
        return this.parameters;
    }

    @Override
    public int getBitsPerComponent() {
        if (this.isStencil()) {
            return 1;
        }
        return this.parameters.getInt(COSName.BPC, COSName.BITS_PER_COMPONENT, -1);
    }

    @Override
    public void setBitsPerComponent(int bitsPerComponent) {
        this.parameters.setInt(COSName.BPC, bitsPerComponent);
    }

    @Override
    public PDColorSpace getColorSpace() throws IOException {
        COSBase cs = this.parameters.getDictionaryObject(COSName.CS);
        if (cs == null) {
            cs = this.parameters.getDictionaryObject(COSName.COLORSPACE);
        }
        if (cs != null) {
            return PDColorSpace.create(cs, this.resources);
        }
        if (this.isStencil()) {
            return PDDeviceGray.INSTANCE;
        }
        throw new IOException("could not determine color space");
    }

    @Override
    public void setColorSpace(PDColorSpace colorSpace) {
        COSBase base = null;
        if (colorSpace != null) {
            base = colorSpace.getCOSObject();
        }
        this.parameters.setItem(COSName.CS, base);
    }

    @Override
    public int getHeight() {
        return this.parameters.getInt(COSName.H, COSName.HEIGHT, -1);
    }

    @Override
    public void setHeight(int height) {
        this.parameters.setInt(COSName.H, height);
    }

    @Override
    public int getWidth() {
        return this.parameters.getInt(COSName.W, COSName.WIDTH, -1);
    }

    @Override
    public void setWidth(int width) {
        this.parameters.setInt(COSName.W, width);
    }

    @Override
    public boolean getInterpolate() {
        return this.parameters.getBoolean(COSName.I, COSName.INTERPOLATE, false);
    }

    @Override
    public void setInterpolate(boolean value) {
        this.parameters.setBoolean(COSName.I, value);
    }

    public List<String> getFilters() {
        List<String> names = null;
        COSBase filters = this.parameters.getDictionaryObject(COSName.F, COSName.FILTER);
        if (filters instanceof COSName) {
            COSName name = (COSName)filters;
            names = new COSArrayList<String>(name.getName(), name, this.parameters, COSName.FILTER);
        } else if (filters instanceof COSArray) {
            names = COSArrayList.convertCOSNameCOSArrayToList((COSArray)filters);
        }
        return names;
    }

    public void setFilters(List<String> filters) {
        COSArray obj = COSArrayList.convertStringListToCOSNameCOSArray(filters);
        this.parameters.setItem(COSName.F, (COSBase)obj);
    }

    @Override
    public void setDecode(COSArray decode) {
        this.parameters.setItem(COSName.D, (COSBase)decode);
    }

    @Override
    public COSArray getDecode() {
        return (COSArray)this.parameters.getDictionaryObject(COSName.D, COSName.DECODE);
    }

    @Override
    public boolean isStencil() {
        return this.parameters.getBoolean(COSName.IM, COSName.IMAGE_MASK, false);
    }

    @Override
    public void setStencil(boolean isStencil) {
        this.parameters.setBoolean(COSName.IM, isStencil);
    }

    @Override
    public PDStream getStream() throws IOException {
        return null;
    }

    @Override
    public InputStream createInputStream() throws IOException {
        return new ByteArrayInputStream(this.decodedData);
    }

    @Override
    public InputStream createInputStream(List<String> stopFilters) throws IOException {
        List<String> filters = this.getFilters();
        ByteArrayInputStream in = new ByteArrayInputStream(this.rawData);
        ByteArrayOutputStream out = new ByteArrayOutputStream(this.rawData.length);
        for (int i = 0; i < filters.size(); ++i) {
            out.reset();
            if (stopFilters.contains(filters.get(i))) break;
            Filter filter = FilterFactory.INSTANCE.getFilter(filters.get(i));
            filter.decode(in, out, this.parameters, i);
            in = new ByteArrayInputStream(out.toByteArray());
        }
        return new ByteArrayInputStream(out.toByteArray());
    }

    @Override
    public boolean isEmpty() {
        return this.decodedData.length == 0;
    }

    public byte[] getData() {
        return this.decodedData;
    }

    @Override
    public Bitmap getImage() throws IOException {
        return SampledImageReader.getRGBImage(this, this.getColorKeyMask());
    }

    @Override
    public Bitmap getStencilImage(Paint paint) throws IOException {
        if (!this.isStencil()) {
            throw new IllegalStateException("Image is not a stencil");
        }
        return SampledImageReader.getStencilImage(this, paint);
    }

    public COSArray getColorKeyMask() {
        COSBase mask = this.parameters.getDictionaryObject(COSName.IM, COSName.MASK);
        if (mask instanceof COSArray) {
            return (COSArray)mask;
        }
        return null;
    }

    @Override
    public String getSuffix() {
        return null;
    }
}

