/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.graphics.image;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.util.Log;
import com.tom_roush.pdfbox.cos.COSArray;
import com.tom_roush.pdfbox.cos.COSNumber;
import com.tom_roush.pdfbox.io.IOUtils;
import com.tom_roush.pdfbox.pdmodel.graphics.color.PDColorSpace;
import com.tom_roush.pdfbox.pdmodel.graphics.image.PDImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Arrays;

final class SampledImageReader {
    private SampledImageReader() {
    }

    public static Bitmap getStencilImage(PDImage pdImage, Paint paint) throws IOException {
        Bitmap mask = SampledImageReader.getRGBImage(pdImage, null);
        Bitmap masked = Bitmap.createBitmap((int)mask.getWidth(), (int)mask.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas g = new Canvas(masked);
        g.drawRect(0.0f, 0.0f, (float)mask.getWidth(), (float)mask.getHeight(), paint);
        int width = masked.getWidth();
        int height = masked.getHeight();
        int[] raster = new int[width * height];
        masked.getPixels(raster, 0, width, 0, 0, width, height);
        int[] alpha = new int[width * height];
        mask.getPixels(alpha, 0, width, 0, 0, width, height);
        for (int pixelIdx = 0; pixelIdx < width * height; ++pixelIdx) {
            if (Color.red((int)alpha[pixelIdx]) != 255) continue;
            raster[pixelIdx] = 0;
        }
        masked.setPixels(raster, 0, width, 0, 0, width, height);
        return masked;
    }

    public static Bitmap getRGBImage(PDImage pdImage, COSArray colorKey) throws IOException {
        if (pdImage.isEmpty()) {
            throw new IOException("Image stream is empty");
        }
        PDColorSpace colorSpace = pdImage.getColorSpace();
        int numComponents = colorSpace.getNumberOfComponents();
        int width = pdImage.getWidth();
        int height = pdImage.getHeight();
        int bitsPerComponent = pdImage.getBitsPerComponent();
        float[] decode = SampledImageReader.getDecodeArray(pdImage);
        float[] defaultDecode = pdImage.getColorSpace().getDefaultDecode(8);
        if (pdImage.getSuffix() != null && pdImage.getSuffix().equals("jpg")) {
            return BitmapFactory.decodeStream((InputStream)pdImage.getStream().createInputStream());
        }
        if (bitsPerComponent == 8 && Arrays.equals(decode, defaultDecode) && colorKey == null) {
            return SampledImageReader.from8bit(pdImage);
        }
        if (bitsPerComponent == 1 && colorKey == null) {
            return SampledImageReader.from1Bit(pdImage);
        }
        Log.e((String)"PdfBox-Android", (String)"Trying to create other-bit image not supported");
        return SampledImageReader.from8bit(pdImage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Bitmap from1Bit(PDImage pdImage) throws IOException {
        PDColorSpace colorSpace = pdImage.getColorSpace();
        int width = pdImage.getWidth();
        int height = pdImage.getHeight();
        Bitmap raster = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ALPHA_8);
        float[] decode = SampledImageReader.getDecodeArray(pdImage);
        ByteBuffer buffer = ByteBuffer.allocate(raster.getRowBytes() * height);
        raster.copyPixelsToBuffer((Buffer)buffer);
        byte[] output = buffer.array();
        try (InputStream iis = null;){
            int value1;
            int value0;
            iis = pdImage.createInputStream();
            boolean isIndexed = false;
            int rowLen = width / 8;
            if (width % 8 > 0) {
                ++rowLen;
            }
            if (decode[0] < decode[1]) {
                value0 = 0;
                value1 = -1;
            } else {
                value0 = -1;
                value1 = 0;
            }
            byte[] buff = new byte[rowLen];
            int idx = 0;
            for (int y = 0; y < height; ++y) {
                int x = 0;
                int readLen = iis.read(buff);
                block4: for (int r = 0; r < rowLen && r < readLen; ++r) {
                    byte value = buff[r];
                    int mask = 128;
                    for (int i = 0; i < 8; ++i) {
                        int bit = value & mask;
                        mask >>= 1;
                        int n = output[idx++] = bit == 0 ? value0 : value1;
                        if (++x == width) continue block4;
                    }
                }
                if (readLen == rowLen) continue;
                Log.w((String)"PdfBox-Android", (String)"premature EOF, image will be incomplete");
                break;
            }
            buffer.rewind();
            raster.copyPixelsFromBuffer((Buffer)buffer);
            Bitmap bitmap = colorSpace.toRGBImage(raster);
            return bitmap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Bitmap from8bit(PDImage pdImage) throws IOException {
        InputStream input = pdImage.createInputStream();
        try {
            int width = pdImage.getWidth();
            int height = pdImage.getHeight();
            int numComponents = pdImage.getColorSpace().getNumberOfComponents();
            Bitmap raster = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            int[] rasterPixels = new int[width * height];
            raster.getPixels(rasterPixels, 0, width, 0, 0, width, height);
            for (int pixelIdx = 0; pixelIdx < width * height; ++pixelIdx) {
                if (numComponents == 1) {
                    int in = input.read();
                    rasterPixels[pixelIdx] = Color.argb((int)255, (int)in, (int)in, (int)in);
                    continue;
                }
                rasterPixels[pixelIdx] = Color.argb((int)255, (int)input.read(), (int)input.read(), (int)input.read());
            }
            raster.setPixels(rasterPixels, 0, width, 0, 0, width, height);
            Bitmap bitmap = raster;
            return bitmap;
        }
        finally {
            IOUtils.closeQuietly(input);
        }
    }

    private static float[] getDecodeArray(PDImage pdImage) throws IOException {
        COSArray cosDecode = pdImage.getDecode();
        float[] decode = null;
        if (cosDecode != null) {
            int numberOfComponents = pdImage.getColorSpace().getNumberOfComponents();
            if (cosDecode.size() != numberOfComponents * 2) {
                if (pdImage.isStencil() && cosDecode.size() >= 2 && cosDecode.get(0) instanceof COSNumber && cosDecode.get(1) instanceof COSNumber) {
                    float decode0 = ((COSNumber)cosDecode.get(0)).floatValue();
                    float decode1 = ((COSNumber)cosDecode.get(1)).floatValue();
                    if (decode0 >= 0.0f && decode0 <= 1.0f && decode1 >= 0.0f && decode1 <= 1.0f) {
                        Log.w((String)"PdfBox-Android", (String)("decode array " + cosDecode + " not compatible with color space, using the first two entries"));
                        return new float[]{decode0, decode1};
                    }
                }
                Log.e((String)"PdfBox-Android", (String)("decode array " + cosDecode + " not compatible with color space, using default"));
            } else {
                decode = cosDecode.toFloatArray();
            }
        }
        if (decode == null) {
            return pdImage.getColorSpace().getDefaultDecode(pdImage.getBitsPerComponent());
        }
        return decode;
    }
}

