/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.graphics.predictor;

import com.tom_roush.pdfbox.pdmodel.graphics.predictor.Average;
import com.tom_roush.pdfbox.pdmodel.graphics.predictor.None;
import com.tom_roush.pdfbox.pdmodel.graphics.predictor.Paeth;
import com.tom_roush.pdfbox.pdmodel.graphics.predictor.PredictorAlgorithm;
import com.tom_roush.pdfbox.pdmodel.graphics.predictor.Sub;
import com.tom_roush.pdfbox.pdmodel.graphics.predictor.Up;

public class Optimum
extends PredictorAlgorithm {
    PredictorAlgorithm[] filter = new PredictorAlgorithm[]{new None(), new Sub(), new Up(), new Average(), new Paeth()};

    @Override
    public void checkBufsiz(byte[] filtered, byte[] raw) {
        if (filtered.length != (this.getWidth() * this.getBpp() + 1) * this.getHeight()) {
            throw new IllegalArgumentException("filtered.length != (width*bpp + 1) * height, " + filtered.length + " " + (this.getWidth() * this.getBpp() + 1) * this.getHeight() + "w,h,bpp=" + this.getWidth() + "," + this.getHeight() + "," + this.getBpp());
        }
        if (raw.length != this.getWidth() * this.getHeight() * this.getBpp()) {
            throw new IllegalArgumentException("raw.length != width * height * bpp, raw.length=" + raw.length + " w,h,bpp=" + this.getWidth() + "," + this.getHeight() + "," + this.getBpp());
        }
    }

    @Override
    public void encodeLine(byte[] src, byte[] dest, int srcDy, int srcOffset, int destDy, int destOffset) {
        throw new UnsupportedOperationException("encodeLine");
    }

    @Override
    public void decodeLine(byte[] src, byte[] dest, int srcDy, int srcOffset, int destDy, int destOffset) {
        throw new UnsupportedOperationException("decodeLine");
    }

    @Override
    public void encode(byte[] src, byte[] dest) {
        this.checkBufsiz(dest, src);
        throw new UnsupportedOperationException("encode");
    }

    @Override
    public void setBpp(int bpp) {
        super.setBpp(bpp);
        for (int i = 0; i < this.filter.length; ++i) {
            this.filter[i].setBpp(bpp);
        }
    }

    @Override
    public void setHeight(int height) {
        super.setHeight(height);
        for (int i = 0; i < this.filter.length; ++i) {
            this.filter[i].setHeight(height);
        }
    }

    @Override
    public void setWidth(int width) {
        super.setWidth(width);
        for (int i = 0; i < this.filter.length; ++i) {
            this.filter[i].setWidth(width);
        }
    }

    @Override
    public void decode(byte[] src, byte[] dest) {
        this.checkBufsiz(src, dest);
        int bpl = this.getWidth() * this.getBpp();
        int srcDy = bpl + 1;
        for (int y = 0; y < this.getHeight(); ++y) {
            PredictorAlgorithm f = this.filter[src[y * srcDy]];
            int srcOffset = y * srcDy + 1;
            f.decodeLine(src, dest, srcDy, srcOffset, bpl, y * bpl);
        }
    }
}

