/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.interactive.annotation;

import com.tom_roush.pdfbox.cos.COSArray;
import com.tom_roush.pdfbox.cos.COSBase;
import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.pdmodel.common.COSObjectable;
import com.tom_roush.pdfbox.pdmodel.interactive.action.PDAction;
import com.tom_roush.pdfbox.pdmodel.interactive.action.PDActionFactory;
import com.tom_roush.pdfbox.pdmodel.interactive.action.PDActionURI;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.PDBorderStyleDictionary;
import com.tom_roush.pdfbox.pdmodel.interactive.documentnavigation.destination.PDDestination;
import java.io.IOException;

public class PDAnnotationLink
extends PDAnnotation {
    public static final String HIGHLIGHT_MODE_NONE = "N";
    public static final String HIGHLIGHT_MODE_INVERT = "I";
    public static final String HIGHLIGHT_MODE_OUTLINE = "O";
    public static final String HIGHLIGHT_MODE_PUSH = "P";
    public static final String SUB_TYPE = "Link";

    public PDAnnotationLink() {
        this.getCOSObject().setItem(COSName.SUBTYPE, (COSBase)COSName.getPDFName(SUB_TYPE));
    }

    public PDAnnotationLink(COSDictionary field) {
        super(field);
    }

    public PDAction getAction() {
        COSDictionary action = (COSDictionary)this.getCOSObject().getDictionaryObject(COSName.A);
        return PDActionFactory.createAction(action);
    }

    public void setAction(PDAction action) {
        this.getCOSObject().setItem(COSName.A, (COSObjectable)action);
    }

    public void setBorderStyle(PDBorderStyleDictionary bs) {
        this.getCOSObject().setItem(COSName.BS, (COSObjectable)bs);
    }

    public PDBorderStyleDictionary getBorderStyle() {
        COSBase bs = this.getCOSObject().getDictionaryObject(COSName.BS);
        if (bs instanceof COSDictionary) {
            return new PDBorderStyleDictionary((COSDictionary)bs);
        }
        return null;
    }

    public PDDestination getDestination() throws IOException {
        COSBase base = this.getCOSObject().getDictionaryObject(COSName.DEST);
        PDDestination retval = PDDestination.create(base);
        return retval;
    }

    public void setDestination(PDDestination dest) {
        this.getCOSObject().setItem(COSName.DEST, (COSObjectable)dest);
    }

    public String getHighlightMode() {
        return this.getCOSObject().getNameAsString(COSName.H, HIGHLIGHT_MODE_INVERT);
    }

    public void setHighlightMode(String mode) {
        this.getCOSObject().setName(COSName.H, mode);
    }

    public void setPreviousURI(PDActionURI pa) {
        this.getCOSObject().setItem("PA", (COSObjectable)pa);
    }

    public PDActionURI getPreviousURI() {
        COSDictionary pa = (COSDictionary)this.getCOSObject().getDictionaryObject("PA");
        if (pa != null) {
            return new PDActionURI(pa);
        }
        return null;
    }

    public void setQuadPoints(float[] quadPoints) {
        COSArray newQuadPoints = new COSArray();
        newQuadPoints.setFloatArray(quadPoints);
        this.getCOSObject().setItem("QuadPoints", (COSBase)newQuadPoints);
    }

    public float[] getQuadPoints() {
        COSArray quadPoints = (COSArray)this.getCOSObject().getDictionaryObject("QuadPoints");
        if (quadPoints != null) {
            return quadPoints.toFloatArray();
        }
        return null;
    }
}

