/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.interactive.digitalsignature;

import com.tom_roush.pdfbox.cos.COSDocument;
import com.tom_roush.pdfbox.io.RandomAccessBufferedFileInputStream;
import com.tom_roush.pdfbox.pdfparser.PDFParser;
import com.tom_roush.pdfbox.pdmodel.interactive.digitalsignature.visible.PDVisibleSigProperties;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class SignatureOptions
implements Closeable {
    private COSDocument visualSignature;
    private int preferedSignatureSize;
    private int pageNo = 0;

    public void setPage(int pageNo) {
        this.pageNo = pageNo;
    }

    public int getPage() {
        return this.pageNo;
    }

    public void setVisualSignature(File file) throws IOException {
        PDFParser parser = new PDFParser(new RandomAccessBufferedFileInputStream(file));
        parser.parse();
        this.visualSignature = parser.getDocument();
    }

    public void setVisualSignature(InputStream is) throws IOException {
        PDFParser parser = new PDFParser(new RandomAccessBufferedFileInputStream(is));
        parser.parse();
        this.visualSignature = parser.getDocument();
    }

    public void setVisualSignature(PDVisibleSigProperties visSignatureProperties) throws IOException {
        this.setVisualSignature(visSignatureProperties.getVisibleSignature());
    }

    public COSDocument getVisualSignature() {
        return this.visualSignature;
    }

    public int getPreferedSignatureSize() {
        return this.preferedSignatureSize;
    }

    public void setPreferedSignatureSize(int size) {
        if (size > 0) {
            this.preferedSignatureSize = size;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.visualSignature != null) {
            this.visualSignature.close();
        }
    }
}

