/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.interactive.form;

import com.tom_roush.pdfbox.cos.COSBase;
import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.PDAppearanceEntry;
import com.tom_roush.pdfbox.pdmodel.interactive.form.PDAcroForm;
import com.tom_roush.pdfbox.pdmodel.interactive.form.PDButton;
import com.tom_roush.pdfbox.pdmodel.interactive.form.PDNonTerminalField;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class PDCheckbox
extends PDButton {
    public PDCheckbox(PDAcroForm acroForm) {
        super(acroForm);
    }

    public PDCheckbox(PDAcroForm acroForm, COSDictionary field, PDNonTerminalField parent) {
        super(acroForm, field, parent);
    }

    public boolean isChecked() {
        return this.getValue().compareTo(this.getOnValue()) == 0;
    }

    public void check() throws IOException {
        this.setValue(this.getOnValue());
    }

    public void unCheck() throws IOException {
        this.setValue(COSName.Off.getName());
    }

    public String getValue() {
        COSBase value = this.getInheritableAttribute(COSName.V);
        if (value instanceof COSName) {
            return ((COSName)value).getName();
        }
        return "";
    }

    public String getDefaultValue() {
        COSBase value = this.getInheritableAttribute(COSName.DV);
        if (value instanceof COSName) {
            return ((COSName)value).getName();
        }
        return "";
    }

    @Override
    public String getValueAsString() {
        return this.getValue();
    }

    public void setValue(String value) throws IOException {
        if (value.compareTo(this.getOnValue()) != 0 && value.compareTo(COSName.Off.getName()) != 0) {
            throw new IllegalArgumentException(value + " is not a valid option for the checkbox " + this.getFullyQualifiedName());
        }
        COSName name = COSName.getPDFName(value);
        this.dictionary.setItem(COSName.V, (COSBase)name);
        this.dictionary.setItem(COSName.AS, (COSBase)name);
        this.applyChange();
    }

    public void setDefaultValue(String value) {
        if (value.compareTo(this.getOnValue()) != 0 && value.compareTo(COSName.Off.getName()) != 0) {
            throw new IllegalArgumentException(value + " is not a valid option for the checkbox " + this.getFullyQualifiedName());
        }
        this.dictionary.setName(COSName.DV, value);
    }

    public String getOnValue() {
        PDAppearanceEntry normalAppearance;
        PDAnnotationWidget widget = this.getWidgets().get(0);
        PDAppearanceDictionary apDictionary = widget.getAppearance();
        String onValue = "";
        if (apDictionary != null && (normalAppearance = apDictionary.getNormalAppearance()) != null) {
            Set<COSName> entries = normalAppearance.getSubDictionary().keySet();
            for (COSName entry : entries) {
                if (COSName.Off.compareTo(entry) == 0) continue;
                onValue = entry.getName();
            }
        }
        return onValue;
    }

    public Set<String> getOnValues() {
        String onValue = this.getOnValue();
        if (onValue.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> onValues = new HashSet<String>();
        onValues.add(onValue);
        return onValues;
    }
}

