/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.interactive.form;

import com.tom_roush.pdfbox.cos.COSBase;
import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.cos.COSNumber;
import com.tom_roush.pdfbox.cos.COSStream;
import com.tom_roush.pdfbox.cos.COSString;
import com.tom_roush.pdfbox.pdmodel.PDResources;
import com.tom_roush.pdfbox.pdmodel.interactive.form.PDAcroForm;
import com.tom_roush.pdfbox.pdmodel.interactive.form.PDDefaultAppearanceString;
import com.tom_roush.pdfbox.pdmodel.interactive.form.PDNonTerminalField;
import com.tom_roush.pdfbox.pdmodel.interactive.form.PDTerminalField;
import java.io.IOException;

public abstract class PDVariableText
extends PDTerminalField {
    static final int QUADDING_LEFT = 0;
    static final int QUADDING_CENTERED = 1;
    static final int QUADDING_RIGHT = 2;

    PDVariableText(PDAcroForm acroForm) {
        super(acroForm);
    }

    PDVariableText(PDAcroForm acroForm, COSDictionary field, PDNonTerminalField parent) {
        super(acroForm, field, parent);
    }

    public String getDefaultAppearance() {
        COSString defaultAppearance = (COSString)this.getInheritableAttribute(COSName.DA);
        return defaultAppearance.getString();
    }

    PDDefaultAppearanceString getDefaultAppearanceString() throws IOException {
        COSString da = (COSString)this.getInheritableAttribute(COSName.DA);
        PDResources dr = this.getAcroForm().getDefaultResources();
        return new PDDefaultAppearanceString(da, dr);
    }

    public void setDefaultAppearance(String daValue) {
        this.dictionary.setString(COSName.DA, daValue);
    }

    public String getDefaultStyleString() {
        COSString defaultStyleString = (COSString)this.dictionary.getDictionaryObject(COSName.DS);
        return defaultStyleString.getString();
    }

    public void setDefaultStyleString(String defaultStyleString) {
        if (defaultStyleString != null) {
            this.dictionary.setItem(COSName.DS, (COSBase)new COSString(defaultStyleString));
        } else {
            this.dictionary.removeItem(COSName.DS);
        }
    }

    public int getQ() {
        int retval = 0;
        COSNumber number = (COSNumber)this.getInheritableAttribute(COSName.Q);
        if (number != null) {
            retval = number.intValue();
        }
        return retval;
    }

    public void setQ(int q) {
        this.dictionary.setInt(COSName.Q, q);
    }

    public String getRichTextValue() throws IOException {
        return this.getStringOrStream(this.getInheritableAttribute(COSName.RV));
    }

    public void setRichTextValue(String richTextValue) {
        if (richTextValue != null) {
            this.dictionary.setItem(COSName.RV, (COSBase)new COSString(richTextValue));
        } else {
            this.dictionary.removeItem(COSName.RV);
        }
    }

    protected String getStringOrStream(COSBase base) {
        if (base == null) {
            return "";
        }
        if (base instanceof COSString) {
            return ((COSString)base).getString();
        }
        if (base instanceof COSStream) {
            return ((COSStream)base).toTextString();
        }
        return "";
    }
}

