/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.util;

import android.content.Context;
import android.content.res.AssetManager;
import android.util.Log;
import java.io.IOException;
import java.io.InputStream;

public class PDFBoxResourceLoader {
    private static Context CONTEXT = null;
    public static FontLoadLevel LOAD_FONTS = FontLoadLevel.MINIMUM;
    private static AssetManager ASSET_MANAGER = null;
    private static boolean hasWarned = false;

    public static void init(Context context) {
        if (CONTEXT == null) {
            CONTEXT = context.getApplicationContext();
            ASSET_MANAGER = CONTEXT.getAssets();
        }
    }

    public static boolean isReady() {
        if (ASSET_MANAGER == null && !hasWarned) {
            Log.w((String)"PdfBox-Android", (String)"Call PDFBoxResourceLoader.init() first to decrease resource load time");
            hasWarned = true;
        }
        return ASSET_MANAGER != null;
    }

    public static InputStream getStream(String path) throws IOException {
        return ASSET_MANAGER.open(path);
    }

    public static enum FontLoadLevel {
        FULL,
        MINIMUM,
        NONE;

    }
}

