/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.fontbox.cff;

import android.graphics.Path;
import android.graphics.PathMeasure;
import android.graphics.PointF;
import android.graphics.RectF;
import android.util.Log;
import com.tom_roush.fontbox.cff.CharStringCommand;
import com.tom_roush.fontbox.cff.CharStringHandler;
import com.tom_roush.fontbox.encoding.StandardEncoding;
import com.tom_roush.fontbox.type1.Type1CharStringReader;
import com.tom_roush.harmony.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Type1CharString {
    private Type1CharStringReader font;
    private String fontName;
    private String glyphName;
    private Path path = null;
    private int width = 0;
    private PointF leftSideBearing = null;
    private PointF current = null;
    private boolean isFlex = false;
    private List<PointF> flexPoints = new ArrayList<PointF>();
    protected List<Object> type1Sequence;
    protected int commandCount;

    public Type1CharString(Type1CharStringReader font, String fontName, String glyphName, List<Object> sequence) {
        this(font, fontName, glyphName);
        this.type1Sequence = sequence;
    }

    protected Type1CharString(Type1CharStringReader font, String fontName, String glyphName) {
        this.font = font;
        this.fontName = fontName;
        this.glyphName = glyphName;
        this.current = new PointF(0.0f, 0.0f);
    }

    public String getName() {
        return this.glyphName;
    }

    public RectF getBounds() {
        if (this.path == null) {
            this.render();
        }
        RectF retval = null;
        this.path.computeBounds(retval, true);
        return retval;
    }

    public int getWidth() {
        if (this.path == null) {
            this.render();
        }
        return this.width;
    }

    public Path getPath() {
        if (this.path == null) {
            this.render();
        }
        return this.path;
    }

    public List<Object> getType1Sequence() {
        return this.type1Sequence;
    }

    private void render() {
        this.path = new Path();
        this.leftSideBearing = new PointF(0.0f, 0.0f);
        this.width = 0;
        CharStringHandler handler = new CharStringHandler(){

            @Override
            public List<Integer> handleCommand(List<Integer> numbers, CharStringCommand command) {
                return Type1CharString.this.handleCommand(numbers, command);
            }
        };
        handler.handleSequence(this.type1Sequence);
    }

    private List<Integer> handleCommand(List<Integer> numbers, CharStringCommand command) {
        ++this.commandCount;
        String name = CharStringCommand.TYPE1_VOCABULARY.get(command.getKey());
        if ("rmoveto".equals(name)) {
            if (numbers.size() >= 2) {
                if (this.isFlex) {
                    this.flexPoints.add(new PointF((float)numbers.get(0).intValue(), (float)numbers.get(1).intValue()));
                } else {
                    this.rmoveTo(numbers.get(0), numbers.get(1));
                }
            }
        } else if ("vmoveto".equals(name)) {
            if (numbers.size() >= 1) {
                if (this.isFlex) {
                    this.flexPoints.add(new PointF(0.0f, (float)numbers.get(0).intValue()));
                } else {
                    this.rmoveTo(0, numbers.get(0));
                }
            }
        } else if ("hmoveto".equals(name)) {
            if (numbers.size() >= 1) {
                if (this.isFlex) {
                    this.flexPoints.add(new PointF((float)numbers.get(0).intValue(), 0.0f));
                } else {
                    this.rmoveTo(numbers.get(0), 0);
                }
            }
        } else if ("rlineto".equals(name)) {
            if (numbers.size() >= 2) {
                this.rlineTo(numbers.get(0), numbers.get(1));
            }
        } else if ("hlineto".equals(name)) {
            if (numbers.size() >= 1) {
                this.rlineTo(numbers.get(0), 0);
            }
        } else if ("vlineto".equals(name)) {
            if (numbers.size() >= 1) {
                this.rlineTo(0, numbers.get(0));
            }
        } else if ("rrcurveto".equals(name)) {
            if (numbers.size() >= 6) {
                this.rrcurveTo(numbers.get(0), numbers.get(1), numbers.get(2), numbers.get(3), numbers.get(4), numbers.get(5));
            }
        } else if ("closepath".equals(name)) {
            this.closepath();
        } else if ("sbw".equals(name)) {
            if (numbers.size() >= 3) {
                this.leftSideBearing = new PointF((float)numbers.get(0).intValue(), (float)numbers.get(1).intValue());
                this.width = numbers.get(2);
                this.current.set(this.leftSideBearing);
            }
        } else if ("hsbw".equals(name)) {
            if (numbers.size() >= 2) {
                this.leftSideBearing = new PointF((float)numbers.get(0).intValue(), 0.0f);
                this.width = numbers.get(1);
                this.current.set(this.leftSideBearing);
            }
        } else if ("vhcurveto".equals(name)) {
            if (numbers.size() >= 4) {
                this.rrcurveTo(0, numbers.get(0), numbers.get(1), numbers.get(2), numbers.get(3), 0);
            }
        } else if ("hvcurveto".equals(name)) {
            if (numbers.size() >= 4) {
                this.rrcurveTo(numbers.get(0), 0, numbers.get(1), numbers.get(2), 0, numbers.get(3));
            }
        } else if ("seac".equals(name)) {
            if (numbers.size() >= 5) {
                this.seac(numbers.get(0), numbers.get(1), numbers.get(2), numbers.get(3), numbers.get(4));
            }
        } else if ("setcurrentpoint".equals(name)) {
            if (numbers.size() >= 2) {
                this.setcurrentpoint(numbers.get(0), numbers.get(1));
            }
        } else if ("callothersubr".equals(name)) {
            if (numbers.size() >= 1) {
                this.callothersubr(numbers.get(0));
            }
        } else {
            if ("div".equals(name)) {
                int b = numbers.get(numbers.size() - 1);
                int a = numbers.get(numbers.size() - 2);
                int result = a / b;
                ArrayList<Integer> list = new ArrayList<Integer>(numbers);
                list.remove(list.size() - 1);
                list.remove(list.size() - 1);
                list.add(result);
                return list;
            }
            if (!("hstem".equals(name) || "vstem".equals(name) || "hstem3".equals(name) || "vstem3".equals(name) || "dotsection".equals(name) || "endchar".equals(name))) {
                if ("return".equals(name)) {
                    Log.w((String)"PdfBox-Android", (String)("Unexpected charstring command: " + command.getKey() + " in glyph " + this.glyphName + " of font " + this.fontName));
                } else {
                    if (name != null) {
                        throw new IllegalArgumentException("Unhandled command: " + name);
                    }
                    Log.w((String)"PdfBox-Android", (String)("Unknown charstring command: " + command.getKey() + " in glyph " + this.glyphName + " of font " + this.fontName));
                }
            }
        }
        return null;
    }

    private void setcurrentpoint(int x, int y) {
        this.current.set((float)x, (float)y);
    }

    private void callothersubr(int num) {
        if (num == 0) {
            this.isFlex = false;
            if (this.flexPoints.size() < 7) {
                Log.w((String)"PdfBox-Android", (String)("flex without moveTo in font " + this.fontName + ", glyph " + this.glyphName + ", command " + this.commandCount));
                return;
            }
            PointF reference = this.flexPoints.get(0);
            reference.set(this.current.x + reference.x, this.current.y + reference.y);
            PointF first = this.flexPoints.get(1);
            first.set(reference.x + first.x, reference.y + first.y);
            first.set(first.x - this.current.x, first.y - this.current.y);
            this.rrcurveTo(Float.valueOf(this.flexPoints.get((int)1).x), Float.valueOf(this.flexPoints.get((int)1).y), Float.valueOf(this.flexPoints.get((int)2).x), Float.valueOf(this.flexPoints.get((int)2).y), Float.valueOf(this.flexPoints.get((int)3).x), Float.valueOf(this.flexPoints.get((int)3).y));
            this.rrcurveTo(Float.valueOf(this.flexPoints.get((int)4).x), Float.valueOf(this.flexPoints.get((int)4).y), Float.valueOf(this.flexPoints.get((int)5).x), Float.valueOf(this.flexPoints.get((int)5).y), Float.valueOf(this.flexPoints.get((int)6).x), Float.valueOf(this.flexPoints.get((int)6).y));
            this.flexPoints.clear();
        } else if (num == 1) {
            this.isFlex = true;
        } else {
            throw new IllegalArgumentException("Unexpected other subroutine: " + num);
        }
    }

    private void rmoveTo(Number dx, Number dy) {
        float x = this.current.x + dx.floatValue();
        float y = this.current.y + dy.floatValue();
        this.path.moveTo(x, y);
        this.current.set(x, y);
    }

    private void rlineTo(Number dx, Number dy) {
        float x = this.current.x + dx.floatValue();
        float y = this.current.y + dy.floatValue();
        if (this.path.isEmpty()) {
            Log.w((String)"PdfBox-Android", (String)("rlineTo without initial moveTo in font " + this.fontName + ", glyph " + this.glyphName));
            this.path.moveTo(x, y);
        } else {
            this.path.lineTo(x, y);
        }
        this.current.set(x, y);
    }

    private void rrcurveTo(Number dx1, Number dy1, Number dx2, Number dy2, Number dx3, Number dy3) {
        float x1 = this.current.x + dx1.floatValue();
        float y1 = this.current.y + dy1.floatValue();
        float x2 = x1 + dx2.floatValue();
        float y2 = y1 + dy2.floatValue();
        float x3 = x2 + dx3.floatValue();
        float y3 = y2 + dy3.floatValue();
        if (this.path.isEmpty()) {
            Log.w((String)"PdfBox-Android", (String)("rrcurveTo without initial moveTo in font " + this.fontName + ", glyph " + this.glyphName));
            this.path.moveTo(x3, y3);
        } else {
            this.path.cubicTo(x1, y1, x2, y2, x3, y3);
        }
        this.current.set(x3, y3);
    }

    private void closepath() {
        if (this.path.isEmpty()) {
            Log.w((String)"PdfBox-Android", (String)("closepath without initial moveTo in font " + this.fontName + ", glyph " + this.glyphName));
        } else {
            this.path.close();
        }
        this.path.moveTo(this.current.x, this.current.y);
    }

    private void seac(Number asb, Number adx, Number ady, Number bchar, Number achar) {
        String accentName;
        String baseName = StandardEncoding.INSTANCE.getName(bchar.intValue());
        if (baseName != null) {
            try {
                Type1CharString base = this.font.getType1CharString(baseName);
                this.path.op(base.getPath(), Path.Op.UNION);
                PathMeasure pm = new PathMeasure(this.path, false);
                float[] aCoordinates = new float[]{0.0f, 0.0f};
                int i = 0;
                while ((float)i < pm.getLength()) {
                    pm.getPosTan(pm.getLength() * 0.5f, aCoordinates, null);
                    ++i;
                }
            }
            catch (IOException e) {
                Log.w((String)"PdfBox-Android", (String)("invalid seac character in glyph " + this.glyphName + " of font " + this.fontName));
            }
        }
        if ((accentName = StandardEncoding.INSTANCE.getName(achar.intValue())) != null) {
            try {
                Type1CharString accent = this.font.getType1CharString(accentName);
                AffineTransform at = AffineTransform.getTranslateInstance(this.leftSideBearing.x + adx.floatValue(), this.leftSideBearing.y + ady.floatValue());
                this.path.op(accent.getPath(), Path.Op.UNION);
            }
            catch (IOException e) {
                Log.w((String)"PdfBox-Android", (String)("invalid seac character in glyph " + this.glyphName + " of font " + this.fontName));
            }
        }
    }

    public String toString() {
        return this.type1Sequence.toString().replace("|", "\n").replace(",", " ");
    }
}

