/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.filter;

import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.filter.ASCII85InputStream;
import com.tom_roush.pdfbox.filter.ASCII85OutputStream;
import com.tom_roush.pdfbox.filter.DecodeResult;
import com.tom_roush.pdfbox.filter.Filter;
import com.tom_roush.pdfbox.io.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

final class ASCII85Filter
extends Filter {
    ASCII85Filter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DecodeResult decode(InputStream encoded, OutputStream decoded, COSDictionary parameters, int index) throws IOException {
        ASCII85InputStream is = null;
        try {
            int amountRead;
            is = new ASCII85InputStream(encoded);
            byte[] buffer = new byte[1024];
            while ((amountRead = is.read(buffer, 0, 1024)) != -1) {
                decoded.write(buffer, 0, amountRead);
            }
            decoded.flush();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        IOUtils.closeQuietly(is);
        return new DecodeResult(parameters);
    }

    @Override
    protected void encode(InputStream input, OutputStream encoded, COSDictionary parameters) throws IOException {
        int amountRead;
        ASCII85OutputStream os = new ASCII85OutputStream(encoded);
        byte[] buffer = new byte[1024];
        while ((amountRead = input.read(buffer, 0, 1024)) != -1) {
            os.write(buffer, 0, amountRead);
        }
        os.close();
        encoded.flush();
    }
}

