/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel;

import android.util.Log;
import com.tom_roush.pdfbox.cos.COSArray;
import com.tom_roush.pdfbox.cos.COSBase;
import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.cos.COSDocument;
import com.tom_roush.pdfbox.cos.COSInteger;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.cos.COSObject;
import com.tom_roush.pdfbox.io.IOUtils;
import com.tom_roush.pdfbox.io.MemoryUsageSetting;
import com.tom_roush.pdfbox.io.RandomAccess;
import com.tom_roush.pdfbox.io.RandomAccessBuffer;
import com.tom_roush.pdfbox.io.RandomAccessBufferedFileInputStream;
import com.tom_roush.pdfbox.io.RandomAccessRead;
import com.tom_roush.pdfbox.io.ScratchFile;
import com.tom_roush.pdfbox.pdfparser.PDFParser;
import com.tom_roush.pdfbox.pdfwriter.COSWriter;
import com.tom_roush.pdfbox.pdmodel.DefaultResourceCache;
import com.tom_roush.pdfbox.pdmodel.PDDocumentCatalog;
import com.tom_roush.pdfbox.pdmodel.PDDocumentInformation;
import com.tom_roush.pdfbox.pdmodel.PDPage;
import com.tom_roush.pdfbox.pdmodel.PDPageTree;
import com.tom_roush.pdfbox.pdmodel.ResourceCache;
import com.tom_roush.pdfbox.pdmodel.common.COSArrayList;
import com.tom_roush.pdfbox.pdmodel.common.PDRectangle;
import com.tom_roush.pdfbox.pdmodel.common.PDStream;
import com.tom_roush.pdfbox.pdmodel.encryption.AccessPermission;
import com.tom_roush.pdfbox.pdmodel.encryption.PDEncryption;
import com.tom_roush.pdfbox.pdmodel.encryption.ProtectionPolicy;
import com.tom_roush.pdfbox.pdmodel.encryption.SecurityHandler;
import com.tom_roush.pdfbox.pdmodel.encryption.SecurityHandlerFactory;
import com.tom_roush.pdfbox.pdmodel.font.PDFont;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import com.tom_roush.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import com.tom_roush.pdfbox.pdmodel.interactive.digitalsignature.SignatureInterface;
import com.tom_roush.pdfbox.pdmodel.interactive.digitalsignature.SignatureOptions;
import com.tom_roush.pdfbox.pdmodel.interactive.form.PDAcroForm;
import com.tom_roush.pdfbox.pdmodel.interactive.form.PDField;
import com.tom_roush.pdfbox.pdmodel.interactive.form.PDSignatureField;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PDDocument
implements Closeable {
    private final COSDocument document;
    private PDDocumentInformation documentInformation;
    private PDDocumentCatalog documentCatalog;
    private PDEncryption encryption;
    private boolean allSecurityToBeRemoved;
    private Long documentId;
    private final RandomAccessRead pdfSource;
    private AccessPermission accessPermission;
    private final Set<PDFont> fontsToSubset = new HashSet<PDFont>();
    private SignatureInterface signInterface;
    private ResourceCache resourceCache = new DefaultResourceCache();

    public PDDocument() {
        this(MemoryUsageSetting.setupMainMemoryOnly());
    }

    public PDDocument(MemoryUsageSetting memUsageSetting) {
        ScratchFile scratchFile = null;
        try {
            scratchFile = new ScratchFile(memUsageSetting);
        }
        catch (IOException ioe) {
            Log.w((String)"PdfBox-Android", (String)("Error initializing scratch file: " + ioe.getMessage() + ". Fall back to main memory usage only."));
            try {
                scratchFile = new ScratchFile(MemoryUsageSetting.setupMainMemoryOnly());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.document = new COSDocument(scratchFile);
        this.pdfSource = null;
        COSDictionary trailer = new COSDictionary();
        this.document.setTrailer(trailer);
        COSDictionary rootDictionary = new COSDictionary();
        trailer.setItem(COSName.ROOT, (COSBase)rootDictionary);
        rootDictionary.setItem(COSName.TYPE, (COSBase)COSName.CATALOG);
        rootDictionary.setItem(COSName.VERSION, (COSBase)COSName.getPDFName("1.4"));
        COSDictionary pages = new COSDictionary();
        rootDictionary.setItem(COSName.PAGES, (COSBase)pages);
        pages.setItem(COSName.TYPE, (COSBase)COSName.PAGES);
        COSArray kidsArray = new COSArray();
        pages.setItem(COSName.KIDS, (COSBase)kidsArray);
        pages.setItem(COSName.COUNT, (COSBase)COSInteger.ZERO);
    }

    public void addPage(PDPage page) {
        this.getPages().add(page);
    }

    public void addSignature(PDSignature sigObject, SignatureInterface signatureInterface) throws IOException {
        this.addSignature(sigObject, signatureInterface, new SignatureOptions());
    }

    public void addSignature(PDSignature sigObject, SignatureInterface signatureInterface, SignatureOptions options) throws IOException {
        PDSignatureField signatureField;
        int preferredSignatureSize = options.getPreferredSignatureSize();
        if (preferredSignatureSize > 0) {
            sigObject.setContents(new byte[preferredSignatureSize]);
        } else {
            sigObject.setContents(new byte[9472]);
        }
        sigObject.setByteRange(new int[]{0, 1000000000, 1000000000, 1000000000});
        this.signInterface = signatureInterface;
        PDDocumentCatalog catalog = this.getDocumentCatalog();
        int pageCount = catalog.getPages().getCount();
        if (pageCount == 0) {
            throw new IllegalStateException("Cannot sign an empty document");
        }
        int startIndex = Math.min(Math.max(options.getPage(), 0), pageCount - 1);
        PDPage page = catalog.getPages().get(startIndex);
        PDAcroForm acroForm = catalog.getAcroForm();
        catalog.getCOSObject().setNeedToBeUpdated(true);
        if (acroForm == null) {
            acroForm = new PDAcroForm(this);
            catalog.setAcroForm(acroForm);
        } else {
            acroForm.getCOSObject().setNeedToBeUpdated(true);
        }
        List<PDField> fields = acroForm.getFields();
        if (fields == null) {
            fields = new ArrayList<PDField>();
            acroForm.setFields(fields);
        }
        if ((signatureField = this.findSignatureField(fields, sigObject)) == null) {
            signatureField = new PDSignatureField(acroForm);
            signatureField.setValue(sigObject);
            signatureField.getWidgets().get(0).setPage(page);
        }
        signatureField.getWidgets().get(0).setPrinted(true);
        List<PDField> acroFormFields = acroForm.getFields();
        acroForm.getCOSObject().setDirect(true);
        acroForm.setSignaturesExist(true);
        acroForm.setAppendOnly(true);
        boolean checkFields = this.checkSignatureField(acroFormFields, signatureField);
        COSDocument visualSignature = options.getVisualSignature();
        if (visualSignature == null) {
            this.prepareNonVisibleSignature(signatureField);
            return;
        }
        this.prepareVisibleSignature(signatureField, acroForm, visualSignature);
        List<PDAnnotation> annotations = page.getAnnotations();
        page.setAnnotations(annotations);
        if (!(annotations instanceof COSArrayList && acroFormFields instanceof COSArrayList && ((COSArrayList)annotations).toList().equals(((COSArrayList)acroFormFields).toList()) && checkFields)) {
            annotations.add(signatureField.getWidgets().get(0));
        }
        page.getCOSObject().setNeedToBeUpdated(true);
    }

    private PDSignatureField findSignatureField(List<PDField> fields, PDSignature sigObject) {
        PDSignatureField signatureField = null;
        for (PDField pdField : fields) {
            PDSignature signature;
            if (!(pdField instanceof PDSignatureField) || (signature = ((PDSignatureField)pdField).getSignature()) == null || !signature.getCOSObject().equals(sigObject.getCOSObject())) continue;
            signatureField = (PDSignatureField)pdField;
        }
        return signatureField;
    }

    private boolean checkSignatureField(List<PDField> acroFormFields, PDSignatureField signatureField) {
        boolean checkFields = false;
        for (PDField field : acroFormFields) {
            if (!(field instanceof PDSignatureField) || !field.getCOSObject().equals(signatureField.getCOSObject())) continue;
            checkFields = true;
            signatureField.getCOSObject().setNeedToBeUpdated(true);
            break;
        }
        if (!checkFields) {
            acroFormFields.add(signatureField);
        }
        return checkFields;
    }

    private void prepareVisibleSignature(PDSignatureField signatureField, PDAcroForm acroForm, COSDocument visualSignature) {
        boolean annotNotFound = true;
        boolean sigFieldNotFound = true;
        for (COSObject cosObject : visualSignature.getObjects()) {
            if (!annotNotFound && !sigFieldNotFound) break;
            COSBase base = cosObject.getObject();
            if (!(base instanceof COSDictionary)) continue;
            COSDictionary cosBaseDict = (COSDictionary)base;
            COSBase type = cosBaseDict.getDictionaryObject(COSName.TYPE);
            if (annotNotFound && COSName.ANNOT.equals(type)) {
                this.assignSignatureRectangle(signatureField, cosBaseDict);
                annotNotFound = false;
            }
            COSBase fieldType = cosBaseDict.getDictionaryObject(COSName.FT);
            COSBase apDict = cosBaseDict.getDictionaryObject(COSName.AP);
            if (!sigFieldNotFound || !COSName.SIG.equals(fieldType) || !(apDict instanceof COSDictionary)) continue;
            this.assignAppearanceDictionary(signatureField, (COSDictionary)apDict);
            this.assignAcroFormDefaultResource(acroForm, cosBaseDict);
            sigFieldNotFound = false;
        }
        if (annotNotFound || sigFieldNotFound) {
            throw new IllegalArgumentException("Template is missing required objects");
        }
    }

    private void assignSignatureRectangle(PDSignatureField signatureField, COSDictionary annotDict) {
        COSArray rectArray = (COSArray)annotDict.getDictionaryObject(COSName.RECT);
        PDRectangle rect = new PDRectangle(rectArray);
        signatureField.getWidgets().get(0).setRectangle(rect);
    }

    private void assignAppearanceDictionary(PDSignatureField signatureField, COSDictionary apDict) {
        PDAppearanceDictionary ap = new PDAppearanceDictionary(apDict);
        apDict.setDirect(true);
        signatureField.getWidgets().get(0).setAppearance(ap);
    }

    private void assignAcroFormDefaultResource(PDAcroForm acroForm, COSDictionary dict) {
        COSBase base = dict.getDictionaryObject(COSName.DR);
        if (base instanceof COSDictionary) {
            COSDictionary dr = (COSDictionary)base;
            dr.setDirect(true);
            dr.setNeedToBeUpdated(true);
            acroForm.getCOSObject().setItem(COSName.DR, (COSBase)dr);
        }
    }

    private void prepareNonVisibleSignature(PDSignatureField signatureField) throws IOException {
        signatureField.getWidgets().get(0).setRectangle(new PDRectangle());
    }

    public void addSignatureField(List<PDSignatureField> sigFields, SignatureInterface signatureInterface, SignatureOptions options) throws IOException {
        PDDocumentCatalog catalog = this.getDocumentCatalog();
        catalog.getCOSObject().setNeedToBeUpdated(true);
        PDAcroForm acroForm = catalog.getAcroForm();
        if (acroForm == null) {
            acroForm = new PDAcroForm(this);
            catalog.setAcroForm(acroForm);
        }
        COSDictionary acroFormDict = acroForm.getCOSObject();
        acroFormDict.setDirect(true);
        acroFormDict.setNeedToBeUpdated(true);
        if (!acroForm.isSignaturesExist()) {
            acroForm.setSignaturesExist(true);
        }
        List<PDField> acroFormFields = acroForm.getFields();
        for (PDSignatureField sigField : sigFields) {
            sigField.getCOSObject().setNeedToBeUpdated(true);
            this.checkSignatureField(acroFormFields, sigField);
            if (sigField.getSignature() == null) continue;
            sigField.getCOSObject().setNeedToBeUpdated(true);
            if (options == null) {
                // empty if block
            }
            this.addSignature(sigField.getSignature(), signatureInterface, options);
        }
    }

    public void removePage(PDPage page) {
        this.getPages().remove(page);
    }

    public void removePage(int pageNumber) {
        this.getPages().remove(pageNumber);
    }

    public PDPage importPage(PDPage page) throws IOException {
        PDPage importedPage = new PDPage(new COSDictionary(page.getCOSObject()), this.resourceCache);
        InputStream in = null;
        try {
            in = page.getContents();
            if (in != null) {
                PDStream dest = new PDStream(this, page.getContents(), COSName.FLATE_DECODE);
                importedPage.setContents(dest);
            }
            this.addPage(importedPage);
        }
        catch (IOException e) {
            IOUtils.closeQuietly(in);
        }
        return importedPage;
    }

    public PDDocument(COSDocument doc) {
        this(doc, null);
    }

    public PDDocument(COSDocument doc, RandomAccessRead source) {
        this(doc, source, null);
    }

    public PDDocument(COSDocument doc, RandomAccessRead source, AccessPermission permission) {
        this.document = doc;
        this.pdfSource = source;
        this.accessPermission = permission;
    }

    public COSDocument getDocument() {
        return this.document;
    }

    public PDDocumentInformation getDocumentInformation() {
        if (this.documentInformation == null) {
            COSDictionary trailer = this.document.getTrailer();
            COSDictionary infoDic = (COSDictionary)trailer.getDictionaryObject(COSName.INFO);
            if (infoDic == null) {
                infoDic = new COSDictionary();
                trailer.setItem(COSName.INFO, (COSBase)infoDic);
            }
            this.documentInformation = new PDDocumentInformation(infoDic);
        }
        return this.documentInformation;
    }

    public void setDocumentInformation(PDDocumentInformation info) {
        this.documentInformation = info;
        this.document.getTrailer().setItem(COSName.INFO, (COSBase)info.getCOSObject());
    }

    public PDDocumentCatalog getDocumentCatalog() {
        if (this.documentCatalog == null) {
            COSDictionary trailer = this.document.getTrailer();
            COSBase dictionary = trailer.getDictionaryObject(COSName.ROOT);
            this.documentCatalog = dictionary instanceof COSDictionary ? new PDDocumentCatalog(this, (COSDictionary)dictionary) : new PDDocumentCatalog(this);
        }
        return this.documentCatalog;
    }

    public boolean isEncrypted() {
        return this.document.isEncrypted();
    }

    public PDEncryption getEncryption() {
        if (this.encryption == null && this.isEncrypted()) {
            this.encryption = new PDEncryption(this.document.getEncryptionDictionary());
        }
        return this.encryption;
    }

    public void setEncryptionDictionary(PDEncryption encryption) throws IOException {
        this.encryption = encryption;
    }

    public PDSignature getLastSignatureDictionary() throws IOException {
        List<PDSignature> signatureDictionaries = this.getSignatureDictionaries();
        int size = signatureDictionaries.size();
        if (size > 0) {
            return signatureDictionaries.get(size - 1);
        }
        return null;
    }

    public List<PDSignatureField> getSignatureFields() throws IOException {
        ArrayList<PDSignatureField> fields = new ArrayList<PDSignatureField>();
        PDAcroForm acroForm = this.getDocumentCatalog().getAcroForm();
        if (acroForm != null) {
            for (PDField field : acroForm.getFields()) {
                if (!(field instanceof PDSignatureField)) continue;
                fields.add((PDSignatureField)field);
            }
        }
        return fields;
    }

    public List<PDSignature> getSignatureDictionaries() throws IOException {
        ArrayList<PDSignature> signatures = new ArrayList<PDSignature>();
        for (PDSignatureField field : this.getSignatureFields()) {
            COSBase value = field.getCOSObject().getDictionaryObject(COSName.V);
            if (value == null) continue;
            signatures.add(new PDSignature((COSDictionary)value));
        }
        return signatures;
    }

    Set<PDFont> getFontsToSubset() {
        return this.fontsToSubset;
    }

    public static PDDocument load(File file) throws IOException {
        return PDDocument.load(file, "", MemoryUsageSetting.setupMainMemoryOnly());
    }

    public static PDDocument load(File file, MemoryUsageSetting memUsageSetting) throws IOException {
        return PDDocument.load(file, "", null, null, memUsageSetting);
    }

    public static PDDocument load(File file, String password) throws IOException {
        return PDDocument.load(file, password, null, null, MemoryUsageSetting.setupMainMemoryOnly());
    }

    public static PDDocument load(File file, String password, MemoryUsageSetting memUsageSetting) throws IOException {
        return PDDocument.load(file, password, null, null, memUsageSetting);
    }

    public static PDDocument load(File file, String password, InputStream keyStore, String alias) throws IOException {
        return PDDocument.load(file, password, keyStore, alias, MemoryUsageSetting.setupMainMemoryOnly());
    }

    public static PDDocument load(File file, String password, InputStream keyStore, String alias, MemoryUsageSetting memUsageSetting) throws IOException {
        RandomAccessBufferedFileInputStream raFile = new RandomAccessBufferedFileInputStream(file);
        try {
            ScratchFile scratchFile = new ScratchFile(memUsageSetting);
            try {
                PDFParser parser = new PDFParser(raFile, password, keyStore, alias, scratchFile);
                parser.parse();
                return parser.getPDDocument();
            }
            catch (IOException ioe) {
                IOUtils.closeQuietly(scratchFile);
                throw ioe;
            }
        }
        catch (IOException ioe) {
            IOUtils.closeQuietly(raFile);
            throw ioe;
        }
    }

    public static PDDocument load(InputStream input) throws IOException {
        return PDDocument.load(input, "", null, null, MemoryUsageSetting.setupMainMemoryOnly());
    }

    public static PDDocument load(InputStream input, MemoryUsageSetting memUsageSetting) throws IOException {
        return PDDocument.load(input, "", null, null, memUsageSetting);
    }

    public static PDDocument load(InputStream input, String password) throws IOException {
        return PDDocument.load(input, password, null, null, MemoryUsageSetting.setupMainMemoryOnly());
    }

    public static PDDocument load(InputStream input, String password, InputStream keyStore, String alias) throws IOException {
        return PDDocument.load(input, password, keyStore, alias, MemoryUsageSetting.setupMainMemoryOnly());
    }

    public static PDDocument load(InputStream input, String password, MemoryUsageSetting memUsageSetting) throws IOException {
        return PDDocument.load(input, password, null, null, memUsageSetting);
    }

    public static PDDocument load(InputStream input, String password, InputStream keyStore, String alias, MemoryUsageSetting memUsageSetting) throws IOException {
        ScratchFile scratchFile = new ScratchFile(memUsageSetting);
        try {
            RandomAccess source = scratchFile.createBuffer(input);
            PDFParser parser = new PDFParser(source, password, keyStore, alias, scratchFile);
            parser.parse();
            return parser.getPDDocument();
        }
        catch (IOException ioe) {
            IOUtils.closeQuietly(scratchFile);
            throw ioe;
        }
    }

    public static PDDocument load(byte[] input) throws IOException {
        return PDDocument.load(input, "");
    }

    public static PDDocument load(byte[] input, String password) throws IOException {
        return PDDocument.load(input, password, null, null);
    }

    public static PDDocument load(byte[] input, String password, InputStream keyStore, String alias) throws IOException {
        return PDDocument.load(input, password, keyStore, alias, MemoryUsageSetting.setupMainMemoryOnly());
    }

    public static PDDocument load(byte[] input, String password, InputStream keyStore, String alias, MemoryUsageSetting memUsageSetting) throws IOException {
        ScratchFile scratchFile = new ScratchFile(memUsageSetting);
        RandomAccessBuffer source = new RandomAccessBuffer(input);
        PDFParser parser = new PDFParser(source, password, keyStore, alias, scratchFile);
        parser.parse();
        return parser.getPDDocument();
    }

    public void save(String fileName) throws IOException {
        this.save(new File(fileName));
    }

    public void save(File file) throws IOException {
        this.save(new BufferedOutputStream(new FileOutputStream(file)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(OutputStream output) throws IOException {
        if (this.document.isClosed()) {
            throw new IOException("Cannot save a document which has been closed");
        }
        for (PDFont font : this.fontsToSubset) {
            font.subset();
        }
        this.fontsToSubset.clear();
        try (COSWriter writer = new COSWriter(output);){
            writer.write(this);
        }
    }

    public void saveIncremental(OutputStream output) throws IOException {
        try (COSWriter writer = null;){
            writer = new COSWriter(output, this.pdfSource);
            writer.write(this, this.signInterface);
            writer.close();
        }
    }

    public PDPage getPage(int pageIndex) {
        return this.getDocumentCatalog().getPages().get(pageIndex);
    }

    public PDPageTree getPages() {
        return this.getDocumentCatalog().getPages();
    }

    public int getNumberOfPages() {
        return this.getDocumentCatalog().getPages().getCount();
    }

    @Override
    public void close() throws IOException {
        if (!this.document.isClosed()) {
            this.document.close();
            if (this.pdfSource != null) {
                this.pdfSource.close();
            }
        }
    }

    public void protect(ProtectionPolicy policy) throws IOException {
        SecurityHandler securityHandler;
        if (this.isAllSecurityToBeRemoved()) {
            Log.w((String)"PdfBox-Android", (String)"do not call setAllSecurityToBeRemoved(true) before callingprotect() as protect() implies setAllSecurityToBeRemoved(false)");
            this.setAllSecurityToBeRemoved(false);
        }
        if (!this.isEncrypted()) {
            this.encryption = new PDEncryption();
        }
        if ((securityHandler = SecurityHandlerFactory.INSTANCE.newSecurityHandlerForPolicy(policy)) == null) {
            throw new IOException("No security handler for policy " + policy);
        }
        this.getEncryption().setSecurityHandler(securityHandler);
    }

    public AccessPermission getCurrentAccessPermission() {
        if (this.accessPermission == null) {
            this.accessPermission = AccessPermission.getOwnerAccessPermission();
        }
        return this.accessPermission;
    }

    public boolean isAllSecurityToBeRemoved() {
        return this.allSecurityToBeRemoved;
    }

    public void setAllSecurityToBeRemoved(boolean removeAllSecurity) {
        this.allSecurityToBeRemoved = removeAllSecurity;
    }

    public Long getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(Long docId) {
        this.documentId = docId;
    }

    public float getVersion() {
        float headerVersionFloat = this.getDocument().getVersion();
        if (headerVersionFloat >= 1.4f) {
            String catalogVersion = this.getDocumentCatalog().getVersion();
            float catalogVersionFloat = -1.0f;
            if (catalogVersion != null) {
                try {
                    catalogVersionFloat = Float.parseFloat(catalogVersion);
                }
                catch (NumberFormatException exception) {
                    Log.e((String)"PdfBox-Android", (String)"Can't extract the version number of the document catalog.", (Throwable)exception);
                }
            }
            return Math.max(catalogVersionFloat, headerVersionFloat);
        }
        return headerVersionFloat;
    }

    public void setVersion(float newVersion) {
        float currentVersion = this.getVersion();
        if (newVersion == currentVersion) {
            return;
        }
        if (newVersion < currentVersion) {
            Log.e((String)"PdfBox-Android", (String)"It's not allowed to downgrade the version of a pdf.");
            return;
        }
        if (this.getDocument().getVersion() >= 1.4f) {
            this.getDocumentCatalog().setVersion(Float.toString(newVersion));
        } else {
            this.getDocument().setVersion(newVersion);
        }
    }

    public ResourceCache getResourceCache() {
        return this.resourceCache;
    }

    public void setResourceCache(ResourceCache resourceCache) {
        this.resourceCache = resourceCache;
    }
}

