/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.fontbox.util.autodetect;

import com.tom_roush.fontbox.util.autodetect.FontDirFinder;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class WindowsFontDirFinder
implements FontDirFinder {
    private String getWinDir(String osName) throws IOException {
        Runtime runtime = Runtime.getRuntime();
        Process process = osName.startsWith("Windows 9") ? runtime.exec("command.com /c echo %windir%") : runtime.exec("cmd.exe /c echo %windir%");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        String winDir = bufferedReader.readLine();
        bufferedReader.close();
        return winDir;
    }

    @Override
    public List<File> find() {
        ArrayList<File> fontDirList;
        block10: {
            char driveLetter;
            String osName;
            block9: {
                File psFontsDir;
                File osFontsDir;
                fontDirList = new ArrayList<File>();
                String windir = null;
                try {
                    windir = System.getProperty("env.windir");
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                osName = System.getProperty("os.name");
                if (windir == null) {
                    try {
                        windir = this.getWinDir(osName);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (windir == null) break block9;
                if (windir.endsWith("/")) {
                    windir = windir.substring(0, windir.length() - 1);
                }
                if ((osFontsDir = new File(windir + File.separator + "FONTS")).exists() && osFontsDir.canRead()) {
                    fontDirList.add(osFontsDir);
                }
                if (!(psFontsDir = new File(windir.substring(0, 2) + File.separator + "PSFONTS")).exists() || !psFontsDir.canRead()) break block10;
                fontDirList.add(psFontsDir);
                break block10;
            }
            String windowsDirName = osName.endsWith("NT") ? "WINNT" : "WINDOWS";
            for (driveLetter = 'C'; driveLetter <= 'E'; driveLetter = (char)(driveLetter + '\u0001')) {
                File osFontsDir = new File(driveLetter + ":" + File.separator + windowsDirName + File.separator + "FONTS");
                if (!osFontsDir.exists() || !osFontsDir.canRead()) continue;
                fontDirList.add(osFontsDir);
                break;
            }
            for (driveLetter = 'C'; driveLetter <= 'E'; driveLetter = (char)(driveLetter + '\u0001')) {
                File psFontsDir = new File(driveLetter + ":" + File.separator + "PSFONTS");
                if (!psFontsDir.exists() || !psFontsDir.canRead()) continue;
                fontDirList.add(psFontsDir);
                break;
            }
        }
        return fontDirList;
    }
}

