/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.harmony.javax.imageio.stream;

import com.tom_roush.harmony.javax.imageio.stream.ImageOutputStreamImpl;
import com.tom_roush.harmony.javax.imageio.stream.RandomAccessMemoryCache;
import java.io.IOException;
import java.io.OutputStream;

public class MemoryCacheImageOutputStream
extends ImageOutputStreamImpl {
    OutputStream os;
    RandomAccessMemoryCache ramc = new RandomAccessMemoryCache();

    public MemoryCacheImageOutputStream(OutputStream stream) {
        if (stream == null) {
            throw new IllegalArgumentException("stream == null!");
        }
        this.os = stream;
    }

    @Override
    public void write(int b) throws IOException {
        this.flushBits();
        this.ramc.putData(b, this.streamPos);
        ++this.streamPos;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.flushBits();
        this.ramc.putData(b, off, len, this.streamPos);
        this.streamPos += (long)len;
    }

    @Override
    public int read() throws IOException {
        this.bitOffset = 0;
        int res = this.ramc.getData(this.streamPos);
        if (res >= 0) {
            ++this.streamPos;
        }
        return res;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.bitOffset = 0;
        int res = this.ramc.getData(b, off, len, this.streamPos);
        if (res > 0) {
            this.streamPos += (long)res;
        }
        return res;
    }

    @Override
    public long length() {
        return this.ramc.length();
    }

    @Override
    public boolean isCached() {
        return true;
    }

    @Override
    public boolean isCachedMemory() {
        return true;
    }

    @Override
    public boolean isCachedFile() {
        return false;
    }

    @Override
    public void close() throws IOException {
        long length = this.length();
        this.seek(length);
        this.flushBefore(length);
        super.close();
        this.ramc.close();
    }

    @Override
    public void flushBefore(long pos) throws IOException {
        long flushedPosition = this.getFlushedPosition();
        super.flushBefore(pos);
        long newFlushedPosition = this.getFlushedPosition();
        int nBytes = (int)(newFlushedPosition - flushedPosition);
        this.ramc.getData(this.os, nBytes, flushedPosition);
        this.ramc.freeBefore(newFlushedPosition);
        this.os.flush();
    }
}

