/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.contentstream;

import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.RectF;
import android.util.Log;
import com.tom_roush.pdfbox.contentstream.PDContentStream;
import com.tom_roush.pdfbox.contentstream.operator.MissingOperandException;
import com.tom_roush.pdfbox.contentstream.operator.Operator;
import com.tom_roush.pdfbox.contentstream.operator.OperatorProcessor;
import com.tom_roush.pdfbox.contentstream.operator.state.EmptyGraphicsStackException;
import com.tom_roush.pdfbox.cos.COSArray;
import com.tom_roush.pdfbox.cos.COSBase;
import com.tom_roush.pdfbox.cos.COSNumber;
import com.tom_roush.pdfbox.cos.COSObject;
import com.tom_roush.pdfbox.cos.COSString;
import com.tom_roush.pdfbox.filter.MissingImageReaderException;
import com.tom_roush.pdfbox.pdfparser.PDFStreamParser;
import com.tom_roush.pdfbox.pdmodel.MissingResourceException;
import com.tom_roush.pdfbox.pdmodel.PDPage;
import com.tom_roush.pdfbox.pdmodel.PDResources;
import com.tom_roush.pdfbox.pdmodel.common.PDRectangle;
import com.tom_roush.pdfbox.pdmodel.font.PDFont;
import com.tom_roush.pdfbox.pdmodel.font.PDFontFactory;
import com.tom_roush.pdfbox.pdmodel.font.PDType3CharProc;
import com.tom_roush.pdfbox.pdmodel.font.PDType3Font;
import com.tom_roush.pdfbox.pdmodel.graphics.PDLineDashPattern;
import com.tom_roush.pdfbox.pdmodel.graphics.color.PDColor;
import com.tom_roush.pdfbox.pdmodel.graphics.color.PDColorSpace;
import com.tom_roush.pdfbox.pdmodel.graphics.form.PDFormXObject;
import com.tom_roush.pdfbox.pdmodel.graphics.form.PDTransparencyGroup;
import com.tom_roush.pdfbox.pdmodel.graphics.pattern.PDTilingPattern;
import com.tom_roush.pdfbox.pdmodel.graphics.state.PDGraphicsState;
import com.tom_roush.pdfbox.pdmodel.graphics.state.PDTextState;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import com.tom_roush.pdfbox.util.Matrix;
import com.tom_roush.pdfbox.util.Vector;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public abstract class PDFStreamEngine {
    private final Map<String, OperatorProcessor> operators = new HashMap<String, OperatorProcessor>(80);
    private Matrix textMatrix;
    private Matrix textLineMatrix;
    private Stack<PDGraphicsState> graphicsStack = new Stack();
    private PDResources resources;
    private PDPage currentPage;
    private boolean isProcessingPage;
    private Matrix initialMatrix;

    protected PDFStreamEngine() {
    }

    @Deprecated
    public void registerOperatorProcessor(String operator, OperatorProcessor op) {
        op.setContext(this);
        this.operators.put(operator, op);
    }

    public final void addOperator(OperatorProcessor op) {
        op.setContext(this);
        this.operators.put(op.getName(), op);
    }

    private void initPage(PDPage page) {
        if (page == null) {
            throw new IllegalArgumentException("Page cannot be null");
        }
        this.currentPage = page;
        this.graphicsStack.clear();
        this.graphicsStack.push(new PDGraphicsState(page.getCropBox()));
        this.textMatrix = null;
        this.textLineMatrix = null;
        this.resources = null;
        this.initialMatrix = page.getMatrix();
    }

    public void processPage(PDPage page) throws IOException {
        this.initPage(page);
        if (page.hasContents()) {
            this.isProcessingPage = true;
            this.processStream(page);
            this.isProcessingPage = false;
        }
    }

    public void showTransparencyGroup(PDTransparencyGroup form) throws IOException {
        this.processTransparencyGroup(form);
    }

    public void showForm(PDFormXObject form) throws IOException {
        if (this.currentPage == null) {
            throw new IllegalStateException("No current page, call #processChildStream(PDContentStream, PDPage) instead");
        }
        this.processStream(form);
    }

    protected void processSoftMask(PDTransparencyGroup group) throws IOException {
        this.saveGraphicsState();
        this.getGraphicsState().setSoftMask(null);
        this.processTransparencyGroup(group);
        this.restoreGraphicsState();
    }

    protected void processTransparencyGroup(PDTransparencyGroup group) throws IOException {
        if (this.currentPage == null) {
            throw new IllegalStateException("No current page, call #processChildStream(PDContentStream, PDPage) instead");
        }
        PDResources parent = this.pushResources(group);
        Stack<PDGraphicsState> savedStack = this.saveGraphicsStack();
        this.getGraphicsState().getCurrentTransformationMatrix().concatenate(group.getMatrix());
        this.clipToRect(group.getBBox());
        this.processStreamOperators(group);
        this.restoreGraphicsStack(savedStack);
        this.popResources(parent);
    }

    protected void processType3Stream(PDType3CharProc charProc, Matrix textRenderingMatrix) throws IOException {
        if (this.currentPage == null) {
            throw new IllegalStateException("No current page, call #processChildStream(PDContentStream, PDPage) instead");
        }
        PDResources parent = this.pushResources(charProc);
        Stack<PDGraphicsState> savedStack = this.saveGraphicsStack();
        this.getGraphicsState().setCurrentTransformationMatrix(textRenderingMatrix);
        this.getGraphicsState().getCurrentTransformationMatrix().concatenate(charProc.getMatrix());
        Matrix textMatrixOld = this.textMatrix;
        this.textMatrix = new Matrix();
        Matrix textLineMatrixOld = this.textLineMatrix;
        this.textLineMatrix = new Matrix();
        this.processStreamOperators(charProc);
        this.textMatrix = textMatrixOld;
        this.textLineMatrix = textLineMatrixOld;
        this.restoreGraphicsStack(savedStack);
        this.popResources(parent);
    }

    protected void processAnnotation(PDAnnotation annotation, PDAppearanceStream appearance) throws IOException {
        PDResources parent = this.pushResources(appearance);
        Stack<PDGraphicsState> savedStack = this.saveGraphicsStack();
        PDRectangle bbox = appearance.getBBox();
        PDRectangle rect = annotation.getRectangle();
        Matrix matrix = appearance.getMatrix();
        if (rect != null && rect.getWidth() > 0.0f && rect.getHeight() > 0.0f && bbox != null) {
            RectF transformedBox = new RectF();
            bbox.transform(matrix).computeBounds(transformedBox, true);
            Matrix a = Matrix.getTranslateInstance(rect.getLowerLeftX(), rect.getLowerLeftY());
            a.concatenate(Matrix.getScaleInstance(rect.getWidth() / transformedBox.width(), rect.getHeight() / transformedBox.height()));
            a.concatenate(Matrix.getTranslateInstance(-transformedBox.left, -transformedBox.top));
            Matrix aa = Matrix.concatenate(a, matrix);
            this.getGraphicsState().setCurrentTransformationMatrix(aa);
            this.clipToRect(bbox);
            this.processStreamOperators(appearance);
        }
        this.restoreGraphicsStack(savedStack);
        this.popResources(parent);
    }

    protected final void processTilingPattern(PDTilingPattern tilingPattern, PDColor color, PDColorSpace colorSpace) throws IOException {
        this.processTilingPattern(tilingPattern, color, colorSpace, tilingPattern.getMatrix());
    }

    protected final void processTilingPattern(PDTilingPattern tilingPattern, PDColor color, PDColorSpace colorSpace, Matrix patternMatrix) throws IOException {
        PDResources parent = this.pushResources(tilingPattern);
        Matrix parentMatrix = this.initialMatrix;
        this.initialMatrix = Matrix.concatenate(this.initialMatrix, patternMatrix);
        Stack<PDGraphicsState> savedStack = this.saveGraphicsStack();
        RectF bbox = new RectF();
        tilingPattern.getBBox().transform(patternMatrix).computeBounds(bbox, true);
        PDRectangle rect = new PDRectangle(bbox.left, bbox.top, bbox.width(), bbox.height());
        this.graphicsStack.push(new PDGraphicsState(rect));
        if (colorSpace != null) {
            color = new PDColor(color.getComponents(), colorSpace);
            this.getGraphicsState().setNonStrokingColorSpace(colorSpace);
            this.getGraphicsState().setNonStrokingColor(color);
            this.getGraphicsState().setStrokingColorSpace(colorSpace);
            this.getGraphicsState().setStrokingColor(color);
        }
        this.getGraphicsState().getCurrentTransformationMatrix().concatenate(patternMatrix);
        this.clipToRect(tilingPattern.getBBox());
        this.processStreamOperators(tilingPattern);
        this.initialMatrix = parentMatrix;
        this.restoreGraphicsStack(savedStack);
        this.popResources(parent);
    }

    public void showAnnotation(PDAnnotation annotation) throws IOException {
        PDAppearanceStream appearanceStream = this.getAppearance(annotation);
        if (appearanceStream != null) {
            this.processAnnotation(annotation, appearanceStream);
        }
    }

    public PDAppearanceStream getAppearance(PDAnnotation annotation) {
        return annotation.getNormalAppearanceStream();
    }

    protected void processChildStream(PDContentStream contentStream, PDPage page) throws IOException {
        if (this.isProcessingPage) {
            throw new IllegalStateException("Current page has already been set via  #processPage(PDPage) call #processChildStream(PDContentStream) instead");
        }
        this.initPage(page);
        this.processStream(contentStream);
        this.currentPage = null;
    }

    private void processStream(PDContentStream contentStream) throws IOException {
        PDResources parent = this.pushResources(contentStream);
        Stack<PDGraphicsState> savedStack = this.saveGraphicsStack();
        Matrix parentMatrix = this.initialMatrix;
        this.getGraphicsState().getCurrentTransformationMatrix().concatenate(contentStream.getMatrix());
        this.initialMatrix = this.getGraphicsState().getCurrentTransformationMatrix().clone();
        PDRectangle bbox = contentStream.getBBox();
        this.clipToRect(bbox);
        this.processStreamOperators(contentStream);
        this.initialMatrix = parentMatrix;
        this.restoreGraphicsStack(savedStack);
        this.popResources(parent);
    }

    private void processStreamOperators(PDContentStream contentStream) throws IOException {
        ArrayList<COSBase> arguments = new ArrayList<COSBase>();
        PDFStreamParser parser = new PDFStreamParser(contentStream);
        Object token = parser.parseNextToken();
        while (token != null) {
            if (token instanceof COSObject) {
                arguments.add(((COSObject)token).getObject());
            } else if (token instanceof Operator) {
                this.processOperator((Operator)token, arguments);
                arguments = new ArrayList();
            } else {
                arguments.add((COSBase)token);
            }
            token = parser.parseNextToken();
        }
    }

    private PDResources pushResources(PDContentStream contentStream) {
        PDResources parentResources = this.resources;
        PDResources streamResources = contentStream.getResources();
        if (streamResources != null) {
            this.resources = streamResources;
        } else if (this.resources == null) {
            this.resources = this.currentPage.getResources();
        }
        if (this.resources == null) {
            this.resources = new PDResources();
        }
        return parentResources;
    }

    private void popResources(PDResources parentResources) {
        this.resources = parentResources;
    }

    private void clipToRect(PDRectangle rectangle) {
        if (rectangle != null) {
            Path clip = rectangle.transform(this.getGraphicsState().getCurrentTransformationMatrix());
            this.getGraphicsState().intersectClippingPath(clip);
        }
    }

    public void beginText() throws IOException {
    }

    public void endText() throws IOException {
    }

    public void showTextString(byte[] string) throws IOException {
        this.showText(string);
    }

    public void showTextStrings(COSArray array) throws IOException {
        PDTextState textState = this.getGraphicsState().getTextState();
        float fontSize = textState.getFontSize();
        float horizontalScaling = textState.getHorizontalScaling() / 100.0f;
        PDFont font = textState.getFont();
        boolean isVertical = false;
        if (font != null) {
            isVertical = font.isVertical();
        }
        for (COSBase obj : array) {
            if (obj instanceof COSNumber) {
                float ty;
                float tx;
                float tj = ((COSNumber)obj).floatValue();
                if (isVertical) {
                    tx = 0.0f;
                    ty = -tj / 1000.0f * fontSize;
                } else {
                    tx = -tj / 1000.0f * fontSize * horizontalScaling;
                    ty = 0.0f;
                }
                this.applyTextAdjustment(tx, ty);
                continue;
            }
            if (obj instanceof COSString) {
                byte[] string = ((COSString)obj).getBytes();
                this.showText(string);
                continue;
            }
            throw new IOException("Unknown type in array for TJ operation:" + obj);
        }
    }

    protected void applyTextAdjustment(float tx, float ty) throws IOException {
        this.textMatrix.concatenate(Matrix.getTranslateInstance(tx, ty));
    }

    protected void showText(byte[] string) throws IOException {
        PDGraphicsState state = this.getGraphicsState();
        PDTextState textState = state.getTextState();
        PDFont font = textState.getFont();
        if (font == null) {
            Log.w((String)"PdfBox-Android", (String)"No current font, will use default");
            font = PDFontFactory.createDefaultFont();
        }
        float fontSize = textState.getFontSize();
        float horizontalScaling = textState.getHorizontalScaling() / 100.0f;
        float charSpacing = textState.getCharacterSpacing();
        Matrix parameters = new Matrix(fontSize * horizontalScaling, 0.0f, 0.0f, fontSize, 0.0f, textState.getRise());
        ByteArrayInputStream in = new ByteArrayInputStream(string);
        while (((InputStream)in).available() > 0) {
            float ty;
            float tx;
            int before = ((InputStream)in).available();
            int code = font.readCode(in);
            int codeLength = before - ((InputStream)in).available();
            String unicode = font.toUnicode(code);
            float wordSpacing = 0.0f;
            if (codeLength == 1 && code == 32) {
                wordSpacing += textState.getWordSpacing();
            }
            Matrix ctm = state.getCurrentTransformationMatrix();
            Matrix textRenderingMatrix = parameters.multiply(this.textMatrix).multiply(ctm);
            if (font.isVertical()) {
                Vector v = font.getPositionVector(code);
                textRenderingMatrix.translate(v);
            }
            Vector w = font.getDisplacement(code);
            this.saveGraphicsState();
            Matrix textMatrixOld = this.textMatrix;
            Matrix textLineMatrixOld = this.textLineMatrix;
            this.showGlyph(textRenderingMatrix, font, code, unicode, w);
            this.textMatrix = textMatrixOld;
            this.textLineMatrix = textLineMatrixOld;
            this.restoreGraphicsState();
            if (font.isVertical()) {
                tx = 0.0f;
                ty = w.getY() * fontSize + charSpacing + wordSpacing;
            } else {
                tx = (w.getX() * fontSize + charSpacing + wordSpacing) * horizontalScaling;
                ty = 0.0f;
            }
            this.textMatrix.concatenate(Matrix.getTranslateInstance(tx, ty));
        }
    }

    protected void showGlyph(Matrix textRenderingMatrix, PDFont font, int code, String unicode, Vector displacement) throws IOException {
        if (font instanceof PDType3Font) {
            this.showType3Glyph(textRenderingMatrix, (PDType3Font)font, code, unicode, displacement);
        } else {
            this.showFontGlyph(textRenderingMatrix, font, code, unicode, displacement);
        }
    }

    protected void showFontGlyph(Matrix textRenderingMatrix, PDFont font, int code, String unicode, Vector displacement) throws IOException {
    }

    protected void showType3Glyph(Matrix textRenderingMatrix, PDType3Font font, int code, String unicode, Vector displacement) throws IOException {
        PDType3CharProc charProc = font.getCharProc(code);
        if (charProc != null) {
            this.processType3Stream(charProc, textRenderingMatrix);
        }
    }

    public void processOperator(String operation, List<COSBase> arguments) throws IOException {
        Operator operator = Operator.getOperator(operation);
        this.processOperator(operator, arguments);
    }

    protected void processOperator(Operator operator, List<COSBase> operands) throws IOException {
        String name = operator.getName();
        OperatorProcessor processor = this.operators.get(name);
        if (processor != null) {
            processor.setContext(this);
            try {
                processor.process(operator, operands);
            }
            catch (IOException e) {
                this.operatorException(operator, operands, e);
            }
        } else {
            this.unsupportedOperator(operator, operands);
        }
    }

    protected void unsupportedOperator(Operator operator, List<COSBase> operands) throws IOException {
    }

    protected void operatorException(Operator operator, List<COSBase> operands, IOException e) throws IOException {
        if (e instanceof MissingOperandException || e instanceof MissingResourceException || e instanceof MissingImageReaderException) {
            Log.e((String)"PdfBox-Android", (String)e.getMessage());
        } else if (e instanceof EmptyGraphicsStackException) {
            Log.w((String)"PdfBox-Android", (String)e.getMessage());
        } else if (operator.getName().equals("Do")) {
            Log.w((String)"PdfBox-Android", (String)e.getMessage());
        } else {
            throw e;
        }
    }

    public void saveGraphicsState() {
        this.graphicsStack.push(this.graphicsStack.peek().clone());
    }

    public void restoreGraphicsState() {
        this.graphicsStack.pop();
    }

    protected final Stack<PDGraphicsState> saveGraphicsStack() {
        Stack<PDGraphicsState> savedStack = this.graphicsStack;
        this.graphicsStack = new Stack();
        this.graphicsStack.add(savedStack.peek().clone());
        return savedStack;
    }

    protected final void restoreGraphicsStack(Stack<PDGraphicsState> snapshot) {
        this.graphicsStack = snapshot;
    }

    public int getGraphicsStackSize() {
        return this.graphicsStack.size();
    }

    public PDGraphicsState getGraphicsState() {
        return this.graphicsStack.peek();
    }

    public Matrix getTextLineMatrix() {
        return this.textLineMatrix;
    }

    public void setTextLineMatrix(Matrix value) {
        this.textLineMatrix = value;
    }

    public Matrix getTextMatrix() {
        return this.textMatrix;
    }

    public void setTextMatrix(Matrix value) {
        this.textMatrix = value;
    }

    public void setLineDashPattern(COSArray array, int phase) {
        if (phase < 0) {
            Log.w((String)"PdfBox-Android", (String)("Dash phase has negative value " + phase + ", set to 0"));
            phase = 0;
        }
        PDLineDashPattern lineDash = new PDLineDashPattern(array, phase);
        this.getGraphicsState().setLineDashPattern(lineDash);
    }

    public PDResources getResources() {
        return this.resources;
    }

    public PDPage getCurrentPage() {
        return this.currentPage;
    }

    public Matrix getInitialMatrix() {
        return this.initialMatrix;
    }

    public PointF transformedPoint(float x, float y) {
        float[] position = new float[]{x, y};
        this.getGraphicsState().getCurrentTransformationMatrix().createAffineTransform().transform(position, 0, position, 0, 1);
        return new PointF(position[0], position[1]);
    }

    protected float transformWidth(float width) {
        Matrix ctm = this.getGraphicsState().getCurrentTransformationMatrix();
        float x = ctm.getScaleX() + ctm.getShearX();
        float y = ctm.getScaleY() + ctm.getShearY();
        return width * (float)Math.sqrt((double)(x * x + y * y) * 0.5);
    }
}

