/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.text;

import android.util.Log;
import com.tom_roush.fontbox.ttf.TrueTypeFont;
import com.tom_roush.fontbox.util.BoundingBox;
import com.tom_roush.pdfbox.contentstream.PDFStreamEngine;
import com.tom_roush.pdfbox.contentstream.operator.DrawObject;
import com.tom_roush.pdfbox.contentstream.operator.state.Concatenate;
import com.tom_roush.pdfbox.contentstream.operator.state.Restore;
import com.tom_roush.pdfbox.contentstream.operator.state.Save;
import com.tom_roush.pdfbox.contentstream.operator.state.SetGraphicsStateParameters;
import com.tom_roush.pdfbox.contentstream.operator.state.SetMatrix;
import com.tom_roush.pdfbox.contentstream.operator.text.BeginText;
import com.tom_roush.pdfbox.contentstream.operator.text.EndText;
import com.tom_roush.pdfbox.contentstream.operator.text.MoveText;
import com.tom_roush.pdfbox.contentstream.operator.text.MoveTextSetLeading;
import com.tom_roush.pdfbox.contentstream.operator.text.NextLine;
import com.tom_roush.pdfbox.contentstream.operator.text.SetCharSpacing;
import com.tom_roush.pdfbox.contentstream.operator.text.SetFontAndSize;
import com.tom_roush.pdfbox.contentstream.operator.text.SetTextHorizontalScaling;
import com.tom_roush.pdfbox.contentstream.operator.text.SetTextLeading;
import com.tom_roush.pdfbox.contentstream.operator.text.SetTextRenderingMode;
import com.tom_roush.pdfbox.contentstream.operator.text.SetTextRise;
import com.tom_roush.pdfbox.contentstream.operator.text.SetWordSpacing;
import com.tom_roush.pdfbox.contentstream.operator.text.ShowText;
import com.tom_roush.pdfbox.contentstream.operator.text.ShowTextAdjusted;
import com.tom_roush.pdfbox.contentstream.operator.text.ShowTextLine;
import com.tom_roush.pdfbox.contentstream.operator.text.ShowTextLineAndSpace;
import com.tom_roush.pdfbox.pdmodel.PDPage;
import com.tom_roush.pdfbox.pdmodel.common.PDRectangle;
import com.tom_roush.pdfbox.pdmodel.font.PDCIDFont;
import com.tom_roush.pdfbox.pdmodel.font.PDCIDFontType2;
import com.tom_roush.pdfbox.pdmodel.font.PDFont;
import com.tom_roush.pdfbox.pdmodel.font.PDFontDescriptor;
import com.tom_roush.pdfbox.pdmodel.font.PDSimpleFont;
import com.tom_roush.pdfbox.pdmodel.font.PDTrueTypeFont;
import com.tom_roush.pdfbox.pdmodel.font.PDType0Font;
import com.tom_roush.pdfbox.pdmodel.font.PDType3Font;
import com.tom_roush.pdfbox.pdmodel.font.encoding.GlyphList;
import com.tom_roush.pdfbox.pdmodel.graphics.state.PDGraphicsState;
import com.tom_roush.pdfbox.text.TextPosition;
import com.tom_roush.pdfbox.util.Matrix;
import com.tom_roush.pdfbox.util.PDFBoxResourceLoader;
import com.tom_roush.pdfbox.util.Vector;
import java.io.IOException;
import java.io.InputStream;

class PDFTextStreamEngine
extends PDFStreamEngine {
    private int pageRotation;
    private PDRectangle pageSize;
    private Matrix translateMatrix;
    private final GlyphList glyphList;

    PDFTextStreamEngine() throws IOException {
        this.addOperator(new BeginText());
        this.addOperator(new Concatenate());
        this.addOperator(new DrawObject());
        this.addOperator(new EndText());
        this.addOperator(new SetGraphicsStateParameters());
        this.addOperator(new Save());
        this.addOperator(new Restore());
        this.addOperator(new NextLine());
        this.addOperator(new SetCharSpacing());
        this.addOperator(new MoveText());
        this.addOperator(new MoveTextSetLeading());
        this.addOperator(new SetFontAndSize());
        this.addOperator(new ShowText());
        this.addOperator(new ShowTextAdjusted());
        this.addOperator(new SetTextLeading());
        this.addOperator(new SetMatrix());
        this.addOperator(new SetTextRenderingMode());
        this.addOperator(new SetTextRise());
        this.addOperator(new SetWordSpacing());
        this.addOperator(new SetTextHorizontalScaling());
        this.addOperator(new ShowTextLine());
        this.addOperator(new ShowTextLineAndSpace());
        String path = "com/tom_roush/pdfbox/resources/glyphlist/additional.txt";
        InputStream input = PDFBoxResourceLoader.isReady() ? PDFBoxResourceLoader.getStream(path) : GlyphList.class.getClassLoader().getResourceAsStream(path);
        this.glyphList = new GlyphList(GlyphList.getAdobeGlyphList(), input);
    }

    @Override
    public void processPage(PDPage page) throws IOException {
        this.pageRotation = page.getRotation();
        this.pageSize = page.getCropBox();
        this.translateMatrix = this.pageSize.getLowerLeftX() == 0.0f && this.pageSize.getLowerLeftY() == 0.0f ? null : Matrix.getTranslateInstance(-this.pageSize.getLowerLeftX(), -this.pageSize.getLowerLeftY());
        super.processPage(page);
    }

    @Override
    protected void showGlyph(Matrix textRenderingMatrix, PDFont font, int code, String unicode, Vector displacement) throws IOException {
        Matrix translatedTextRenderingMatrix;
        float capHeight;
        PDGraphicsState state = this.getGraphicsState();
        Matrix ctm = state.getCurrentTransformationMatrix();
        float fontSize = state.getTextState().getFontSize();
        float horizontalScaling = state.getTextState().getHorizontalScaling() / 100.0f;
        Matrix textMatrix = this.getTextMatrix();
        BoundingBox bbox = font.getBoundingBox();
        if (bbox.getLowerLeftY() < -32768.0f) {
            bbox.setLowerLeftY(-(bbox.getLowerLeftY() + 65536.0f));
        }
        float glyphHeight = bbox.getHeight() / 2.0f;
        PDFontDescriptor fontDescriptor = font.getFontDescriptor();
        if (fontDescriptor != null && (capHeight = fontDescriptor.getCapHeight()) != 0.0f && capHeight < glyphHeight) {
            glyphHeight = capHeight;
        }
        float height = font instanceof PDType3Font ? font.getFontMatrix().transformPoint((double)0.0, (double)((double)glyphHeight)).y : glyphHeight / 1000.0f;
        float displacementX = displacement.getX();
        if (font.isVertical()) {
            PDCIDFont cidFont;
            displacementX = font.getWidth(code) / 1000.0f;
            TrueTypeFont ttf = null;
            if (font instanceof PDTrueTypeFont) {
                ttf = ((PDTrueTypeFont)font).getTrueTypeFont();
            } else if (font instanceof PDType0Font && (cidFont = ((PDType0Font)font).getDescendantFont()) instanceof PDCIDFontType2) {
                ttf = ((PDCIDFontType2)cidFont).getTrueTypeFont();
            }
            if (ttf != null && ttf.getUnitsPerEm() != 1000) {
                displacementX *= 1000.0f / (float)ttf.getUnitsPerEm();
            }
        }
        float tx = displacementX * fontSize * horizontalScaling;
        float ty = displacement.getY() * fontSize;
        Matrix td = Matrix.getTranslateInstance(tx, ty);
        Matrix nextTextRenderingMatrix = td.multiply(textMatrix).multiply(ctm);
        float nextX = nextTextRenderingMatrix.getTranslateX();
        float nextY = nextTextRenderingMatrix.getTranslateY();
        float dxDisplay = nextX - textRenderingMatrix.getTranslateX();
        float dyDisplay = height * textRenderingMatrix.getScalingFactorY();
        float glyphSpaceToTextSpaceFactor = 0.001f;
        if (font instanceof PDType3Font) {
            glyphSpaceToTextSpaceFactor = font.getFontMatrix().getScaleX();
        }
        float spaceWidthText = 0.0f;
        try {
            spaceWidthText = font.getSpaceWidth() * glyphSpaceToTextSpaceFactor;
        }
        catch (Throwable exception) {
            Log.w((String)"PdfBox-Android", (String)exception.getMessage(), (Throwable)exception);
        }
        if (spaceWidthText == 0.0f) {
            spaceWidthText = font.getAverageFontWidth() * glyphSpaceToTextSpaceFactor;
            spaceWidthText *= 0.8f;
        }
        if (spaceWidthText == 0.0f) {
            spaceWidthText = 1.0f;
        }
        float spaceWidthDisplay = spaceWidthText * textRenderingMatrix.getScalingFactorX();
        unicode = font.toUnicode(code, this.glyphList);
        if (unicode == null) {
            if (font instanceof PDSimpleFont) {
                char c = (char)code;
                unicode = new String(new char[]{c});
            } else {
                return;
            }
        }
        if (this.translateMatrix == null) {
            translatedTextRenderingMatrix = textRenderingMatrix;
        } else {
            translatedTextRenderingMatrix = Matrix.concatenate(this.translateMatrix, textRenderingMatrix);
            nextX -= this.pageSize.getLowerLeftX();
            nextY -= this.pageSize.getLowerLeftY();
        }
        this.processTextPosition(new TextPosition(this.pageRotation, this.pageSize.getWidth(), this.pageSize.getHeight(), translatedTextRenderingMatrix, nextX, nextY, dyDisplay, dxDisplay, spaceWidthDisplay, unicode, new int[]{code}, font, fontSize, (int)(fontSize * textMatrix.getScalingFactorX())));
    }

    protected void processTextPosition(TextPosition text) {
    }
}

