/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.documentinterchange.logicalstructure;

import com.tom_roush.pdfbox.cos.COSBase;
import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.cos.COSStream;
import com.tom_roush.pdfbox.pdmodel.common.COSObjectable;
import com.tom_roush.pdfbox.pdmodel.graphics.PDXObject;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.PDAnnotationUnknown;
import java.io.IOException;

public class PDObjectReference
implements COSObjectable {
    public static final String TYPE = "OBJR";
    private final COSDictionary dictionary;

    @Override
    public COSDictionary getCOSObject() {
        return this.dictionary;
    }

    public PDObjectReference() {
        this.dictionary = new COSDictionary();
        this.dictionary.setName(COSName.TYPE, TYPE);
    }

    public PDObjectReference(COSDictionary theDictionary) {
        this.dictionary = theDictionary;
    }

    public COSObjectable getReferencedObject() {
        COSBase obj = this.getCOSObject().getDictionaryObject(COSName.OBJ);
        if (!(obj instanceof COSDictionary)) {
            return null;
        }
        try {
            PDXObject xobject;
            if (obj instanceof COSStream && (xobject = PDXObject.createXObject(obj, null)) != null) {
                return xobject;
            }
            COSDictionary objDictionary = (COSDictionary)obj;
            PDAnnotation annotation = PDAnnotation.createAnnotation(obj);
            if (!(annotation instanceof PDAnnotationUnknown) || COSName.ANNOT.equals(objDictionary.getDictionaryObject(COSName.TYPE))) {
                return annotation;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public void setReferencedObject(PDAnnotation annotation) {
        this.getCOSObject().setItem(COSName.OBJ, (COSObjectable)annotation);
    }

    public void setReferencedObject(PDXObject xobject) {
        this.getCOSObject().setItem(COSName.OBJ, (COSObjectable)xobject);
    }
}

