/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.fdf;

import com.tom_roush.pdfbox.cos.COSArray;
import com.tom_roush.pdfbox.cos.COSBase;
import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.pdmodel.common.COSArrayList;
import com.tom_roush.pdfbox.pdmodel.common.COSObjectable;
import com.tom_roush.pdfbox.pdmodel.fdf.FDFPageInfo;
import com.tom_roush.pdfbox.pdmodel.fdf.FDFTemplate;
import java.util.ArrayList;
import java.util.List;

public class FDFPage
implements COSObjectable {
    private final COSDictionary page;

    public FDFPage() {
        this.page = new COSDictionary();
    }

    public FDFPage(COSDictionary p) {
        this.page = p;
    }

    @Override
    public COSDictionary getCOSObject() {
        return this.page;
    }

    public List<FDFTemplate> getTemplates() {
        COSArrayList retval = null;
        COSArray array = (COSArray)this.page.getDictionaryObject(COSName.TEMPLATES);
        if (array != null) {
            ArrayList<FDFTemplate> objects = new ArrayList<FDFTemplate>();
            for (int i = 0; i < array.size(); ++i) {
                objects.add(new FDFTemplate((COSDictionary)array.getObject(i)));
            }
            retval = new COSArrayList(objects, array);
        }
        return retval;
    }

    public void setTemplates(List<FDFTemplate> templates) {
        this.page.setItem(COSName.TEMPLATES, (COSBase)COSArrayList.converterToCOSArray(templates));
    }

    public FDFPageInfo getPageInfo() {
        FDFPageInfo retval = null;
        COSDictionary dict = (COSDictionary)this.page.getDictionaryObject(COSName.INFO);
        if (dict != null) {
            retval = new FDFPageInfo(dict);
        }
        return retval;
    }

    public void setPageInfo(FDFPageInfo info) {
        this.page.setItem(COSName.INFO, (COSObjectable)info);
    }
}

