/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.graphics.image;

import android.graphics.Bitmap;
import com.tom_roush.harmony.javax.imageio.stream.MemoryCacheImageOutputStream;
import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.filter.Filter;
import com.tom_roush.pdfbox.filter.FilterFactory;
import com.tom_roush.pdfbox.pdmodel.PDDocument;
import com.tom_roush.pdfbox.pdmodel.common.COSObjectable;
import com.tom_roush.pdfbox.pdmodel.graphics.color.PDColorSpace;
import com.tom_roush.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import com.tom_roush.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import com.tom_roush.pdfbox.pdmodel.graphics.image.PDImageXObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public final class LosslessFactory {
    private LosslessFactory() {
    }

    public static PDImageXObject createFromImage(PDDocument document, Bitmap image) throws IOException {
        if (image.getConfig() == Bitmap.Config.ALPHA_8) {
            return LosslessFactory.createFromGrayImage(image, document);
        }
        return LosslessFactory.createFromRGBImage(image, document);
    }

    private static PDImageXObject createFromGrayImage(Bitmap image, PDDocument document) throws IOException {
        int height = image.getHeight();
        int width = image.getWidth();
        int[] rgbLineBuffer = new int[width];
        int bpc = 8;
        ByteArrayOutputStream baos = new ByteArrayOutputStream((width * bpc / 8 + (width * bpc % 8 != 0 ? 1 : 0)) * height);
        MemoryCacheImageOutputStream mcios = new MemoryCacheImageOutputStream(baos);
        for (int y = 0; y < height; ++y) {
            image.getPixels(rgbLineBuffer, 0, width, 0, y, width, 1);
            for (int pixel : rgbLineBuffer) {
                mcios.writeBits(pixel & 0xFF, bpc);
            }
            int bitOffset = mcios.getBitOffset();
            if (bitOffset == 0) continue;
            mcios.writeBits(0L, 8 - bitOffset);
        }
        mcios.flush();
        mcios.close();
        return LosslessFactory.prepareImageXObject(document, baos.toByteArray(), image.getWidth(), image.getHeight(), bpc, PDDeviceGray.INSTANCE);
    }

    private static PDImageXObject createFromRGBImage(Bitmap image, PDDocument document) throws IOException {
        int height = image.getHeight();
        int width = image.getWidth();
        int[] rgbLineBuffer = new int[width];
        int bpc = 8;
        PDDeviceRGB deviceColorSpace = PDDeviceRGB.INSTANCE;
        byte[] imageData = new byte[width * height * 3];
        int byteIdx = 0;
        int alphaByteIdx = 0;
        int alphaBitPos = 7;
        int apbc = 8;
        byte[] alphaImageData = image.hasAlpha() ? new byte[(width * apbc / 8 + (width * apbc % 8 != 0 ? 1 : 0)) * height] : new byte[]{};
        for (int y = 0; y < height; ++y) {
            image.getPixels(rgbLineBuffer, 0, width, 0, y, width, 1);
            for (int pixel : rgbLineBuffer) {
                imageData[byteIdx++] = (byte)(pixel >> 16 & 0xFF);
                imageData[byteIdx++] = (byte)(pixel >> 8 & 0xFF);
                imageData[byteIdx++] = (byte)(pixel & 0xFF);
                if (!image.hasAlpha()) continue;
                alphaImageData[alphaByteIdx++] = (byte)(pixel >> 24 & 0xFF);
            }
        }
        PDImageXObject pdImage = LosslessFactory.prepareImageXObject(document, imageData, image.getWidth(), image.getHeight(), bpc, deviceColorSpace);
        if (image.hasAlpha()) {
            PDImageXObject pdMask = LosslessFactory.prepareImageXObject(document, alphaImageData, image.getWidth(), image.getHeight(), apbc, PDDeviceGray.INSTANCE);
            pdImage.getCOSObject().setItem(COSName.SMASK, (COSObjectable)pdMask);
        }
        return pdImage;
    }

    private static PDImageXObject prepareImageXObject(PDDocument document, byte[] byteArray, int width, int height, int bitsPerComponent, PDColorSpace initColorSpace) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(byteArray.length / 2);
        Filter filter = FilterFactory.INSTANCE.getFilter(COSName.FLATE_DECODE);
        filter.encode(new ByteArrayInputStream(byteArray), baos, new COSDictionary(), 0);
        ByteArrayInputStream encodedByteStream = new ByteArrayInputStream(baos.toByteArray());
        return new PDImageXObject(document, encodedByteStream, COSName.FLATE_DECODE, width, height, bitsPerComponent, initColorSpace);
    }
}

