/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.fontbox.cmap;

import com.tom_roush.fontbox.cmap.CMap;

public class CodespaceRange {
    private byte[] start;
    private byte[] end;
    private int startInt;
    private int endInt;
    private int codeLength = 0;

    public int getCodeLength() {
        return this.codeLength;
    }

    public byte[] getEnd() {
        return this.end;
    }

    void setEnd(byte[] endBytes) {
        this.end = endBytes;
        this.endInt = CMap.toInt(endBytes, endBytes.length);
    }

    public byte[] getStart() {
        return this.start;
    }

    void setStart(byte[] startBytes) {
        this.start = startBytes;
        this.codeLength = this.start.length;
        this.startInt = CMap.toInt(startBytes, startBytes.length);
    }

    public boolean matches(byte[] code) {
        return this.isFullMatch(code, code.length);
    }

    public boolean isFullMatch(byte[] code, int codeLen) {
        int value;
        return codeLen == this.codeLength && (value = CMap.toInt(code, codeLen)) >= this.startInt && value <= this.endInt;
    }
}

