/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.filter;

import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.filter.DecodeResult;
import com.tom_roush.pdfbox.filter.Filter;
import com.tom_roush.pdfbox.filter.IdentityFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

final class CryptFilter
extends Filter {
    CryptFilter() {
    }

    @Override
    public DecodeResult decode(InputStream encoded, OutputStream decoded, COSDictionary parameters, int index) throws IOException {
        COSName encryptionName = (COSName)parameters.getDictionaryObject(COSName.NAME);
        if (encryptionName == null || encryptionName.equals(COSName.IDENTITY)) {
            IdentityFilter identityFilter = new IdentityFilter();
            ((Filter)identityFilter).decode(encoded, decoded, parameters, index);
            return new DecodeResult(parameters);
        }
        throw new IOException("Unsupported crypt filter " + encryptionName.getName());
    }

    @Override
    protected void encode(InputStream input, OutputStream encoded, COSDictionary parameters) throws IOException {
        COSName encryptionName = (COSName)parameters.getDictionaryObject(COSName.NAME);
        if (encryptionName != null && !encryptionName.equals(COSName.IDENTITY)) {
            throw new IOException("Unsupported crypt filter " + encryptionName.getName());
        }
        IdentityFilter identityFilter = new IdentityFilter();
        ((Filter)identityFilter).encode(input, encoded, parameters);
    }
}

