/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdfwriter;

import com.tom_roush.pdfbox.contentstream.operator.Operator;
import com.tom_roush.pdfbox.cos.COSArray;
import com.tom_roush.pdfbox.cos.COSBase;
import com.tom_roush.pdfbox.cos.COSBoolean;
import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.cos.COSFloat;
import com.tom_roush.pdfbox.cos.COSInteger;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.cos.COSString;
import com.tom_roush.pdfbox.pdfwriter.COSWriter;
import com.tom_roush.pdfbox.util.Charsets;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;

public class ContentStreamWriter {
    private final OutputStream output;
    public static final byte[] SPACE = new byte[]{32};
    public static final byte[] EOL = new byte[]{10};

    public ContentStreamWriter(OutputStream out) {
        this.output = out;
    }

    public void writeToken(COSBase base) throws IOException {
        this.writeObject(base);
    }

    public void writeToken(Operator op) throws IOException {
        this.writeObject(op);
    }

    public void writeTokens(Object ... tokens) throws IOException {
        for (Object token : tokens) {
            this.writeObject(token);
        }
        this.output.write("\n".getBytes(Charsets.US_ASCII));
    }

    public void writeTokens(List<?> tokens) throws IOException {
        for (Object token : tokens) {
            this.writeObject(token);
        }
    }

    private void writeObject(Object o) throws IOException {
        if (o instanceof COSString) {
            COSWriter.writeString((COSString)o, this.output);
            this.output.write(SPACE);
        } else if (o instanceof COSFloat) {
            ((COSFloat)o).writePDF(this.output);
            this.output.write(SPACE);
        } else if (o instanceof COSInteger) {
            ((COSInteger)o).writePDF(this.output);
            this.output.write(SPACE);
        } else if (o instanceof COSBoolean) {
            ((COSBoolean)o).writePDF(this.output);
            this.output.write(SPACE);
        } else if (o instanceof COSName) {
            ((COSName)o).writePDF(this.output);
            this.output.write(SPACE);
        } else if (o instanceof COSArray) {
            COSArray array = (COSArray)o;
            this.output.write(COSWriter.ARRAY_OPEN);
            for (int i = 0; i < array.size(); ++i) {
                this.writeObject(array.get(i));
                this.output.write(SPACE);
            }
            this.output.write(COSWriter.ARRAY_CLOSE);
        } else if (o instanceof COSDictionary) {
            COSDictionary obj = (COSDictionary)o;
            this.output.write(COSWriter.DICT_OPEN);
            for (Map.Entry<COSName, COSBase> entry : obj.entrySet()) {
                if (entry.getValue() == null) continue;
                this.writeObject(entry.getKey());
                this.output.write(SPACE);
                this.writeObject(entry.getValue());
                this.output.write(SPACE);
            }
            this.output.write(COSWriter.DICT_CLOSE);
            this.output.write(SPACE);
        } else if (o instanceof Operator) {
            Operator op = (Operator)o;
            if (op.getName().equals("BI")) {
                this.output.write("BI".getBytes(Charsets.ISO_8859_1));
                COSDictionary dic = op.getImageParameters();
                for (COSName key : dic.keySet()) {
                    COSBase value = dic.getDictionaryObject(key);
                    key.writePDF(this.output);
                    this.output.write(SPACE);
                    this.writeObject(value);
                    this.output.write(EOL);
                }
                this.output.write("ID".getBytes(Charsets.ISO_8859_1));
                this.output.write(EOL);
                this.output.write(op.getImageData());
                this.output.write(EOL);
                this.output.write("EI".getBytes(Charsets.ISO_8859_1));
                this.output.write(EOL);
            } else {
                this.output.write(op.getName().getBytes(Charsets.ISO_8859_1));
                this.output.write(EOL);
            }
        } else {
            throw new IOException("Error:Unknown type in content stream:" + o);
        }
    }
}

