/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.fontbox.ttf;

import com.tom_roush.fontbox.ttf.CFFTable;
import com.tom_roush.fontbox.ttf.OTLTable;
import com.tom_roush.fontbox.ttf.OpenTypeFont;
import com.tom_roush.fontbox.ttf.TTFDataStream;
import com.tom_roush.fontbox.ttf.TTFParser;
import com.tom_roush.fontbox.ttf.TTFTable;
import com.tom_roush.fontbox.ttf.TrueTypeFont;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public final class OTFParser
extends TTFParser {
    public OTFParser() {
    }

    public OTFParser(boolean isEmbedded) {
        this(isEmbedded, false);
    }

    public OTFParser(boolean isEmbedded, boolean parseOnDemand) {
        super(isEmbedded, parseOnDemand);
    }

    @Override
    public OpenTypeFont parse(String file) throws IOException {
        return (OpenTypeFont)super.parse(file);
    }

    @Override
    public OpenTypeFont parse(File file) throws IOException {
        return (OpenTypeFont)super.parse(file);
    }

    @Override
    public OpenTypeFont parse(InputStream data) throws IOException {
        return (OpenTypeFont)super.parse(data);
    }

    @Override
    OpenTypeFont parse(TTFDataStream raf) throws IOException {
        return (OpenTypeFont)super.parse(raf);
    }

    @Override
    OpenTypeFont newFont(TTFDataStream raf) {
        return new OpenTypeFont(raf);
    }

    @Override
    protected TTFTable readTable(TrueTypeFont font, String tag) {
        if (tag.equals("BASE") || tag.equals("GDEF") || tag.equals("GPOS") || tag.equals("GSUB") || tag.equals("JSTF")) {
            return new OTLTable(font);
        }
        if (tag.equals("CFF ")) {
            return new CFFTable(font);
        }
        return super.readTable(font, tag);
    }

    @Override
    protected boolean allowCFF() {
        return true;
    }
}

