/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.encryption;

import android.util.Log;
import com.tom_roush.pdfbox.cos.COSArray;
import com.tom_roush.pdfbox.cos.COSBase;
import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.cos.COSStream;
import com.tom_roush.pdfbox.cos.COSString;
import com.tom_roush.pdfbox.io.IOUtils;
import com.tom_roush.pdfbox.pdmodel.PDDocument;
import com.tom_roush.pdfbox.pdmodel.encryption.AccessPermission;
import com.tom_roush.pdfbox.pdmodel.encryption.DecryptionMaterial;
import com.tom_roush.pdfbox.pdmodel.encryption.InvalidPasswordException;
import com.tom_roush.pdfbox.pdmodel.encryption.MessageDigests;
import com.tom_roush.pdfbox.pdmodel.encryption.PDEncryption;
import com.tom_roush.pdfbox.pdmodel.encryption.RC4Cipher;
import com.tom_roush.pdfbox.util.Charsets;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public abstract class SecurityHandler {
    private static final int DEFAULT_KEY_LENGTH = 40;
    private static final byte[] AES_SALT = new byte[]{115, 65, 108, 84};
    protected int keyLength = 40;
    protected byte[] encryptionKey;
    private final RC4Cipher rc4 = new RC4Cipher();
    private boolean decryptMetadata;
    private final Map<COSBase, List<COSBase>> objects = new HashMap<COSBase, List<COSBase>>();
    private boolean useAES;
    private AccessPermission currentAccessPermission = null;

    protected void setDecryptMetadata(boolean decryptMetadata) {
        this.decryptMetadata = decryptMetadata;
    }

    public abstract void prepareDocumentForEncryption(PDDocument var1) throws IOException;

    public abstract void prepareForDecryption(PDEncryption var1, COSArray var2, DecryptionMaterial var3) throws InvalidPasswordException, IOException;

    private void encryptData(long objectNumber, long genNumber, InputStream data, OutputStream output, boolean decrypt) throws IOException {
        if (this.useAES && this.encryptionKey.length == 32) {
            this.encryptDataAES256(data, output, decrypt);
        } else {
            byte[] finalKey = this.calcFinalKey(objectNumber, genNumber);
            if (this.useAES) {
                this.encryptDataAESother(finalKey, data, output, decrypt);
            } else {
                this.encryptDataRC4(finalKey, data, output);
            }
        }
        output.flush();
    }

    private byte[] calcFinalKey(long objectNumber, long genNumber) {
        byte[] newKey = new byte[this.encryptionKey.length + 5];
        System.arraycopy(this.encryptionKey, 0, newKey, 0, this.encryptionKey.length);
        newKey[newKey.length - 5] = (byte)(objectNumber & 0xFFL);
        newKey[newKey.length - 4] = (byte)(objectNumber >> 8 & 0xFFL);
        newKey[newKey.length - 3] = (byte)(objectNumber >> 16 & 0xFFL);
        newKey[newKey.length - 2] = (byte)(genNumber & 0xFFL);
        newKey[newKey.length - 1] = (byte)(genNumber >> 8 & 0xFFL);
        MessageDigest md = MessageDigests.getMD5();
        md.update(newKey);
        if (this.useAES) {
            md.update(AES_SALT);
        }
        byte[] digestedKey = md.digest();
        int length = Math.min(newKey.length, 16);
        byte[] finalKey = new byte[length];
        System.arraycopy(digestedKey, 0, finalKey, 0, length);
        return finalKey;
    }

    protected void encryptDataRC4(byte[] finalKey, InputStream input, OutputStream output) throws IOException {
        this.rc4.setKey(finalKey);
        this.rc4.write(input, output);
    }

    protected void encryptDataRC4(byte[] finalKey, byte[] input, OutputStream output) throws IOException {
        this.rc4.setKey(finalKey);
        this.rc4.write(input, output);
    }

    private void encryptDataAESother(byte[] finalKey, InputStream data, OutputStream output, boolean decrypt) throws IOException {
        byte[] iv = new byte[16];
        if (!this.prepareAESInitializationVector(decrypt, iv, data, output)) {
            return;
        }
        try {
            int n;
            Cipher decryptCipher;
            try {
                decryptCipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            SecretKeySpec aesKey = new SecretKeySpec(finalKey, "AES");
            IvParameterSpec ips = new IvParameterSpec(iv);
            decryptCipher.init(decrypt ? 2 : 1, (Key)aesKey, ips);
            byte[] buffer = new byte[256];
            while ((n = data.read(buffer)) != -1) {
                byte[] dst = decryptCipher.update(buffer, 0, n);
                if (dst == null) continue;
                output.write(dst);
            }
            output.write(decryptCipher.doFinal());
        }
        catch (InvalidKeyException e) {
            throw new IOException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new IOException(e);
        }
        catch (NoSuchPaddingException e) {
            throw new IOException(e);
        }
        catch (IllegalBlockSizeException e) {
            throw new IOException(e);
        }
        catch (BadPaddingException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encryptDataAES256(InputStream data, OutputStream output, boolean decrypt) throws IOException {
        Cipher cipher;
        byte[] iv = new byte[16];
        if (!this.prepareAESInitializationVector(decrypt, iv, data, output)) {
            return;
        }
        try {
            cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            SecretKeySpec keySpec = new SecretKeySpec(this.encryptionKey, "AES");
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            cipher.init(decrypt ? 2 : 1, (Key)keySpec, ivSpec);
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
        try (CipherInputStream cis = new CipherInputStream(data, cipher);){
            IOUtils.copy(cis, output);
        }
    }

    private boolean prepareAESInitializationVector(boolean decrypt, byte[] iv, InputStream data, OutputStream output) throws IOException {
        if (decrypt) {
            int ivSize = data.read(iv);
            if (ivSize == -1) {
                return false;
            }
            if (ivSize != iv.length) {
                throw new IOException("AES initialization vector not fully read: only " + ivSize + " bytes read instead of " + iv.length);
            }
        } else {
            SecureRandom rnd = new SecureRandom();
            rnd.nextBytes(iv);
            output.write(iv);
        }
        return true;
    }

    public void decrypt(COSBase obj, long objNum, long genNum) throws IOException {
        List<COSBase> list = this.objects.get(obj);
        if (list == null) {
            list = new ArrayList<COSBase>();
            this.objects.put(obj, list);
        } else {
            for (COSBase base : list) {
                if (base != obj) continue;
                return;
            }
        }
        list.add(obj);
        if (obj instanceof COSString) {
            this.decryptString((COSString)obj, objNum, genNum);
        } else if (obj instanceof COSStream) {
            this.decryptStream((COSStream)obj, objNum, genNum);
        } else if (obj instanceof COSDictionary) {
            this.decryptDictionary((COSDictionary)obj, objNum, genNum);
        } else if (obj instanceof COSArray) {
            this.decryptArray((COSArray)obj, objNum, genNum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decryptStream(COSStream stream, long objNum, long genNum) throws IOException {
        COSName type = stream.getCOSName(COSName.TYPE);
        if (!this.decryptMetadata && COSName.METADATA.equals(type)) {
            return;
        }
        if (COSName.XREF.equals(type)) {
            return;
        }
        if (COSName.METADATA.equals(type)) {
            InputStream is = stream.createRawInputStream();
            byte[] buf = new byte[10];
            is.read(buf);
            is.close();
            if (Arrays.equals(buf, "<?xpacket ".getBytes(Charsets.ISO_8859_1))) {
                Log.w((String)"PdfBox-Android", (String)"Metadata is not encrypted, but was expected to be");
                Log.w((String)"PdfBox-Android", (String)"Read PDF specification about EncryptMetadata (default value: true)");
                return;
            }
        }
        this.decryptDictionary(stream, objNum, genNum);
        byte[] encrypted = IOUtils.toByteArray(stream.createRawInputStream());
        ByteArrayInputStream encryptedStream = new ByteArrayInputStream(encrypted);
        try (OutputStream output = stream.createRawOutputStream();){
            this.encryptData(objNum, genNum, encryptedStream, output, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encryptStream(COSStream stream, long objNum, int genNum) throws IOException {
        byte[] rawData = IOUtils.toByteArray(stream.createRawInputStream());
        ByteArrayInputStream encryptedStream = new ByteArrayInputStream(rawData);
        try (OutputStream output = stream.createRawOutputStream();){
            this.encryptData(objNum, genNum, encryptedStream, output, false);
        }
    }

    private void decryptDictionary(COSDictionary dictionary, long objNum, long genNum) throws IOException {
        if (dictionary.getItem(COSName.CF) != null) {
            return;
        }
        COSBase type = dictionary.getDictionaryObject(COSName.TYPE);
        boolean isSignature = COSName.SIG.equals(type) || COSName.DOC_TIME_STAMP.equals(type) || dictionary.getDictionaryObject(COSName.CONTENTS) instanceof COSString && dictionary.getDictionaryObject(COSName.BYTERANGE) instanceof COSArray;
        for (Map.Entry<COSName, COSBase> entry : dictionary.entrySet()) {
            COSBase value;
            if (isSignature && COSName.CONTENTS.equals(entry.getKey()) || !((value = entry.getValue()) instanceof COSString) && !(value instanceof COSArray) && !(value instanceof COSDictionary)) continue;
            this.decrypt(value, objNum, genNum);
        }
    }

    private void decryptString(COSString string, long objNum, long genNum) throws IOException {
        ByteArrayInputStream data = new ByteArrayInputStream(string.getBytes());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            this.encryptData(objNum, genNum, data, outputStream, true);
            string.setValue(outputStream.toByteArray());
        }
        catch (IOException ex) {
            Log.e((String)"PdfBox-Android", (String)("Failed to decrypt COSString of length " + string.getBytes().length + " in object " + objNum + ": " + ex.getMessage()));
        }
    }

    public void encryptString(COSString string, long objNum, int genNum) throws IOException {
        ByteArrayInputStream data = new ByteArrayInputStream(string.getBytes());
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        this.encryptData(objNum, genNum, data, buffer, false);
        string.setValue(buffer.toByteArray());
    }

    private void decryptArray(COSArray array, long objNum, long genNum) throws IOException {
        for (int i = 0; i < array.size(); ++i) {
            this.decrypt(array.get(i), objNum, genNum);
        }
    }

    public int getKeyLength() {
        return this.keyLength;
    }

    public void setKeyLength(int keyLen) {
        this.keyLength = keyLen;
    }

    public void setCurrentAccessPermission(AccessPermission currentAccessPermission) {
        this.currentAccessPermission = currentAccessPermission;
    }

    public AccessPermission getCurrentAccessPermission() {
        return this.currentAccessPermission;
    }

    public boolean isAES() {
        return this.useAES;
    }

    public void setAES(boolean aesValue) {
        this.useAES = aesValue;
    }

    public abstract boolean hasProtectionPolicy();
}

