/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.fdf;

import android.util.Log;
import com.tom_roush.pdfbox.cos.COSArray;
import com.tom_roush.pdfbox.cos.COSBase;
import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.cos.COSFloat;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.cos.COSStream;
import com.tom_roush.pdfbox.pdmodel.fdf.FDFAnnotation;
import com.tom_roush.pdfbox.util.Hex;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FDFAnnotationStamp
extends FDFAnnotation {
    public static final String SUBTYPE = "Stamp";

    public FDFAnnotationStamp() {
        this.annot.setName(COSName.SUBTYPE, SUBTYPE);
    }

    public FDFAnnotationStamp(COSDictionary a) {
        super(a);
    }

    public FDFAnnotationStamp(Element element) throws IOException {
        super(element);
        byte[] decodedAppearanceXML;
        String base64EncodedAppearance;
        this.annot.setName(COSName.SUBTYPE, SUBTYPE);
        XPath xpath = XPathFactory.newInstance().newXPath();
        Log.d((String)"PdfBox-Android", (String)"Get the DOM Document for the stamp appearance");
        try {
            base64EncodedAppearance = xpath.evaluate("appearance", element);
        }
        catch (XPathExpressionException e) {
            Log.e((String)"PdfBox-Android", (String)("Error while evaluating XPath expression for appearance: " + e));
            return;
        }
        try {
            decodedAppearanceXML = Hex.decodeBase64(base64EncodedAppearance);
        }
        catch (IllegalArgumentException ex) {
            Log.e((String)"PdfBox-Android", (String)"Bad base64 encoded appearance ignored", (Throwable)ex);
            return;
        }
        if (base64EncodedAppearance != null && !base64EncodedAppearance.isEmpty()) {
            Document stampAppearance = this.getStampAppearanceDocument(decodedAppearanceXML);
            Element appearanceEl = stampAppearance.getDocumentElement();
            if (!"dict".equalsIgnoreCase(appearanceEl.getNodeName())) {
                throw new IOException("Error while reading stamp document, root should be 'dict' and not '" + appearanceEl.getNodeName() + "'");
            }
            Log.d((String)"PdfBox-Android", (String)"Generate and set the appearance dictionary to the stamp annotation");
            this.annot.setItem(COSName.AP, (COSBase)this.parseStampAnnotationAppearanceXML(appearanceEl));
        }
    }

    private Document getStampAppearanceDocument(byte[] xml) throws IOException {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            return builder.parse(new ByteArrayInputStream(xml));
        }
        catch (ParserConfigurationException ex) {
            Log.e((String)"PdfBox-Android", (String)("Error while converting appearance xml to document: " + ex));
            throw new IOException(ex);
        }
        catch (SAXException ex) {
            Log.e((String)"PdfBox-Android", (String)("Error while converting appearance xml to document: " + ex));
            throw new IOException(ex);
        }
    }

    private COSDictionary parseStampAnnotationAppearanceXML(Element appearanceXML) throws IOException {
        COSDictionary dictionary = new COSDictionary();
        dictionary.setItem(COSName.N, (COSBase)new COSStream());
        Log.d((String)"PdfBox-Android", (String)"Build dictionary for Appearance based on the appearanceXML");
        NodeList nodeList = appearanceXML.getChildNodes();
        String parentAttrKey = appearanceXML.getAttribute("KEY");
        Log.d((String)"PdfBox-Android", (String)("Appearance Root - tag: " + appearanceXML.getTagName() + ", name: " + appearanceXML.getNodeName() + ", key: " + parentAttrKey + ", children: " + nodeList.getLength()));
        if (!"AP".equals(appearanceXML.getAttribute("KEY"))) {
            Log.w((String)"PdfBox-Android", (String)(parentAttrKey + " => Not handling element: " + appearanceXML.getTagName() + " with key: " + appearanceXML.getAttribute("KEY")));
            return dictionary;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            if ("STREAM".equalsIgnoreCase(child.getTagName())) {
                Log.d((String)"PdfBox-Android", (String)(parentAttrKey + " => Process " + child.getAttribute("KEY") + " item in the dictionary after processing the " + child.getTagName()));
                dictionary.setItem(child.getAttribute("KEY"), (COSBase)this.parseStreamElement(child));
                Log.d((String)"PdfBox-Android", (String)(parentAttrKey + " => Set " + child.getAttribute("KEY")));
                continue;
            }
            Log.w((String)"PdfBox-Android", (String)(parentAttrKey + " => Not handling element: " + child.getTagName()));
        }
        return dictionary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private COSStream parseStreamElement(Element streamEl) throws IOException {
        COSStream stream = new COSStream();
        NodeList nodeList = streamEl.getChildNodes();
        String parentAttrKey = streamEl.getAttribute("KEY");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            String childAttrKey = child.getAttribute("KEY");
            String childAttrVal = child.getAttribute("VAL");
            Log.d((String)"PdfBox-Android", (String)(parentAttrKey + " => reading child: " + child.getTagName() + " with key: " + childAttrKey));
            if ("INT".equalsIgnoreCase(child.getTagName())) {
                if ("Length".equals(childAttrKey)) continue;
                stream.setInt(COSName.getPDFName(childAttrKey), Integer.parseInt(childAttrVal));
                Log.d((String)"PdfBox-Android", (String)(parentAttrKey + " => Set " + childAttrKey + ": " + childAttrVal));
                continue;
            }
            if ("NAME".equalsIgnoreCase(child.getTagName())) {
                stream.setName(COSName.getPDFName(childAttrKey), childAttrVal);
                Log.d((String)"PdfBox-Android", (String)(parentAttrKey + " => Set " + childAttrKey + ": " + childAttrVal));
                continue;
            }
            if ("BOOL".equalsIgnoreCase(child.getTagName())) {
                stream.setBoolean(COSName.getPDFName(childAttrKey), Boolean.parseBoolean(childAttrVal));
                Log.d((String)"PdfBox-Android", (String)(parentAttrKey + " => Set Interpolate: " + childAttrVal));
                continue;
            }
            if ("ARRAY".equalsIgnoreCase(child.getTagName())) {
                stream.setItem(COSName.getPDFName(childAttrKey), (COSBase)this.parseArrayElement(child));
                Log.d((String)"PdfBox-Android", (String)(parentAttrKey + " => Set " + childAttrKey));
                continue;
            }
            if ("DICT".equalsIgnoreCase(child.getTagName())) {
                stream.setItem(COSName.getPDFName(childAttrKey), (COSBase)this.parseDictElement(child));
                Log.d((String)"PdfBox-Android", (String)(parentAttrKey + " => Set " + childAttrKey));
                continue;
            }
            if ("STREAM".equalsIgnoreCase(child.getTagName())) {
                stream.setItem(COSName.getPDFName(childAttrKey), (COSBase)this.parseStreamElement(child));
                Log.d((String)"PdfBox-Android", (String)(parentAttrKey + " => Set " + childAttrKey));
                continue;
            }
            if ("DATA".equalsIgnoreCase(child.getTagName())) {
                Log.d((String)"PdfBox-Android", (String)(parentAttrKey + " => Handling DATA with encoding: " + child.getAttribute("ENCODING")));
                if ("HEX".equals(child.getAttribute("ENCODING"))) {
                    try (OutputStream os = null;){
                        os = stream.createRawOutputStream();
                        os.write(Hex.decodeHex(child.getTextContent()));
                        Log.d((String)"PdfBox-Android", (String)(parentAttrKey + " => Data was streamed"));
                        continue;
                    }
                }
                Log.w((String)"PdfBox-Android", (String)(parentAttrKey + " => Not handling element DATA encoding: " + child.getAttribute("ENCODING")));
                continue;
            }
            Log.w((String)"PdfBox-Android", (String)(parentAttrKey + " => Not handling child element: " + child.getTagName()));
        }
        return stream;
    }

    private COSArray parseArrayElement(Element arrayEl) throws IOException {
        Log.d((String)"PdfBox-Android", (String)("Parse " + arrayEl.getAttribute("KEY") + " Array"));
        COSArray array = new COSArray();
        NodeList nodeList = arrayEl.getElementsByTagName("FIXED");
        String elAttrKey = arrayEl.getAttribute("KEY");
        if ("BBox".equals(elAttrKey)) {
            if (nodeList.getLength() < 4) {
                throw new IOException("BBox does not have enough coordinates, only has: " + nodeList.getLength());
            }
        } else if ("Matrix".equals(elAttrKey) && nodeList.getLength() < 6) {
            throw new IOException("Matrix does not have enough coordinates, only has: " + nodeList.getLength());
        }
        Log.d((String)"PdfBox-Android", (String)("There are " + nodeList.getLength() + " FIXED elements"));
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element el = (Element)node;
            Log.d((String)"PdfBox-Android", (String)(elAttrKey + " value(" + i + "): " + el.getAttribute("VAL")));
            array.add(new COSFloat(el.getAttribute("VAL")));
        }
        return array;
    }

    private COSDictionary parseDictElement(Element dictEl) throws IOException {
        Log.d((String)"PdfBox-Android", (String)("Parse " + dictEl.getAttribute("KEY") + " Dictionary"));
        COSDictionary dict = new COSDictionary();
        NodeList nodeList = dictEl.getChildNodes();
        String parentAttrKey = dictEl.getAttribute("KEY");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            String childAttrKey = child.getAttribute("KEY");
            String childAttrVal = child.getAttribute("VAL");
            if ("DICT".equals(child.getTagName())) {
                Log.d((String)"PdfBox-Android", (String)(parentAttrKey + " => Handling DICT element with key: " + childAttrKey));
                dict.setItem(COSName.getPDFName(childAttrKey), (COSBase)this.parseDictElement(child));
                Log.d((String)"PdfBox-Android", (String)(parentAttrKey + " => Set " + childAttrKey));
                continue;
            }
            if ("STREAM".equals(child.getTagName())) {
                Log.d((String)"PdfBox-Android", (String)(parentAttrKey + " => Handling STREAM element with key: " + childAttrKey));
                dict.setItem(COSName.getPDFName(childAttrKey), (COSBase)this.parseStreamElement(child));
                continue;
            }
            if ("NAME".equals(child.getTagName())) {
                Log.d((String)"PdfBox-Android", (String)(parentAttrKey + " => Handling NAME element with key: " + childAttrKey));
                dict.setName(COSName.getPDFName(childAttrKey), childAttrVal);
                Log.d((String)"PdfBox-Android", (String)(parentAttrKey + " => Set " + childAttrKey + ": " + childAttrVal));
                continue;
            }
            Log.w((String)"PdfBox-Android", (String)(parentAttrKey + " => NOT handling child element: " + child.getTagName()));
        }
        return dict;
    }
}

