/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.filter;

import android.util.Log;
import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.filter.DecodeResult;
import com.tom_roush.pdfbox.filter.Filter;
import com.tom_roush.pdfbox.filter.Predictor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;

final class FlateFilter
extends Filter {
    private static final int BUFFER_SIZE = 16384;

    FlateFilter() {
    }

    @Override
    public DecodeResult decode(InputStream encoded, OutputStream decoded, COSDictionary parameters, int index) throws IOException {
        COSDictionary decodeParams = this.getDecodeParams(parameters, index);
        try {
            this.decompress(encoded, Predictor.wrapPredictor(decoded, decodeParams));
        }
        catch (DataFormatException e) {
            Log.e((String)"PdfBox-Android", (String)"FlateFilter: stop reading corrupt stream due to a DataFormatException");
            throw new IOException(e);
        }
        return new DecodeResult(parameters);
    }

    private void decompress(InputStream in, OutputStream out) throws IOException, DataFormatException {
        byte[] buf = new byte[2048];
        in.read(buf, 0, 2);
        int read = in.read(buf);
        if (read > 0) {
            Inflater inflater = new Inflater(true);
            inflater.setInput(buf, 0, read);
            byte[] res = new byte[1024];
            boolean dataWritten = false;
            while (true) {
                int resRead = 0;
                try {
                    resRead = inflater.inflate(res);
                }
                catch (DataFormatException exception) {
                    if (dataWritten) {
                        Log.w((String)"PdfBox-Android", (String)"FlateFilter: premature end of stream due to a DataFormatException");
                        break;
                    }
                    throw exception;
                }
                if (resRead != 0) {
                    out.write(res, 0, resRead);
                    dataWritten = true;
                    continue;
                }
                if (inflater.finished() || inflater.needsDictionary() || in.available() == 0) break;
                read = in.read(buf);
                inflater.setInput(buf, 0, read);
            }
            inflater.end();
        }
        out.flush();
    }

    @Override
    protected void encode(InputStream input, OutputStream encoded, COSDictionary parameters) throws IOException {
        int compressionLevel = FlateFilter.getCompressionLevel();
        Deflater deflater = new Deflater(compressionLevel);
        DeflaterOutputStream out = new DeflaterOutputStream(encoded, deflater);
        int mayRead = input.available();
        if (mayRead > 0) {
            int amountRead;
            byte[] buffer = new byte[Math.min(mayRead, 16384)];
            while ((amountRead = input.read(buffer, 0, Math.min(mayRead, 16384))) != -1) {
                out.write(buffer, 0, amountRead);
            }
        }
        out.close();
        encoded.flush();
        deflater.end();
    }
}

