/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.font;

import com.tom_roush.pdfbox.contentstream.PDContentStream;
import com.tom_roush.pdfbox.contentstream.operator.Operator;
import com.tom_roush.pdfbox.cos.COSBase;
import com.tom_roush.pdfbox.cos.COSNumber;
import com.tom_roush.pdfbox.cos.COSObject;
import com.tom_roush.pdfbox.cos.COSStream;
import com.tom_roush.pdfbox.pdfparser.PDFStreamParser;
import com.tom_roush.pdfbox.pdmodel.PDResources;
import com.tom_roush.pdfbox.pdmodel.common.COSObjectable;
import com.tom_roush.pdfbox.pdmodel.common.PDRectangle;
import com.tom_roush.pdfbox.pdmodel.common.PDStream;
import com.tom_roush.pdfbox.pdmodel.font.PDType3Font;
import com.tom_roush.pdfbox.util.Matrix;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public final class PDType3CharProc
implements COSObjectable,
PDContentStream {
    private final PDType3Font font;
    private final COSStream charStream;

    public PDType3CharProc(PDType3Font font, COSStream charStream) {
        this.font = font;
        this.charStream = charStream;
    }

    @Override
    public COSStream getCOSObject() {
        return this.charStream;
    }

    public PDType3Font getFont() {
        return this.font;
    }

    public PDStream getContentStream() {
        return new PDStream(this.charStream);
    }

    @Override
    public InputStream getContents() throws IOException {
        return this.charStream.createInputStream();
    }

    @Override
    public PDResources getResources() {
        return this.font.getResources();
    }

    @Override
    public PDRectangle getBBox() {
        return this.font.getFontBBox();
    }

    public PDRectangle getGlyphBBox() throws IOException {
        ArrayList<COSBase> arguments = new ArrayList<COSBase>();
        PDFStreamParser parser = new PDFStreamParser(this);
        Object token = parser.parseNextToken();
        while (token != null) {
            if (token instanceof COSObject) {
                arguments.add(((COSObject)token).getObject());
            } else {
                if (token instanceof Operator) {
                    if (((Operator)token).getName().equals("d1") && arguments.size() == 6) {
                        for (int i = 0; i < 6; ++i) {
                            if (arguments.get(i) instanceof COSNumber) continue;
                            return null;
                        }
                        return new PDRectangle(((COSNumber)arguments.get(2)).floatValue(), ((COSNumber)arguments.get(3)).floatValue(), ((COSNumber)arguments.get(4)).floatValue() - ((COSNumber)arguments.get(2)).floatValue(), ((COSNumber)arguments.get(5)).floatValue() - ((COSNumber)arguments.get(3)).floatValue());
                    }
                    return null;
                }
                arguments.add((COSBase)token);
            }
            token = parser.parseNextToken();
        }
        return null;
    }

    @Override
    public Matrix getMatrix() {
        return this.font.getFontMatrix();
    }

    public float getWidth() throws IOException {
        ArrayList<COSBase> arguments = new ArrayList<COSBase>();
        PDFStreamParser parser = new PDFStreamParser(this);
        Object token = parser.parseNextToken();
        while (token != null) {
            if (token instanceof COSObject) {
                arguments.add(((COSObject)token).getObject());
            } else {
                if (token instanceof Operator) {
                    return this.parseWidth((Operator)token, arguments);
                }
                arguments.add((COSBase)token);
            }
            token = parser.parseNextToken();
        }
        throw new IOException("Unexpected end of stream");
    }

    private float parseWidth(Operator operator, List<COSBase> arguments) throws IOException {
        if (operator.getName().equals("d0") || operator.getName().equals("d1")) {
            COSBase obj = arguments.get(0);
            if (obj instanceof COSNumber) {
                return ((COSNumber)obj).floatValue();
            }
            throw new IOException("Unexpected argument type: " + obj.getClass().getName());
        }
        throw new IOException("First operator must be d0 or d1");
    }
}

