/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.fdf;

import android.util.Log;
import com.tom_roush.pdfbox.cos.COSArray;
import com.tom_roush.pdfbox.cos.COSBase;
import com.tom_roush.pdfbox.cos.COSBoolean;
import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.cos.COSFloat;
import com.tom_roush.pdfbox.cos.COSInteger;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.cos.COSStream;
import com.tom_roush.pdfbox.io.IOUtils;
import com.tom_roush.pdfbox.pdmodel.fdf.FDFAnnotation;
import com.tom_roush.pdfbox.util.Hex;
import com.tom_roush.pdfbox.util.XMLUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FDFAnnotationStamp
extends FDFAnnotation {
    public static final String SUBTYPE = "Stamp";

    public FDFAnnotationStamp() {
        this.annot.setName(COSName.SUBTYPE, SUBTYPE);
    }

    public FDFAnnotationStamp(COSDictionary a) {
        super(a);
    }

    public FDFAnnotationStamp(Element element) throws IOException {
        super(element);
        byte[] decodedAppearanceXML;
        String base64EncodedAppearance;
        this.annot.setName(COSName.SUBTYPE, SUBTYPE);
        XPath xpath = XPathFactory.newInstance().newXPath();
        Log.d((String)"PdfBox-Android", (String)"Get the DOM Document for the stamp appearance");
        try {
            base64EncodedAppearance = xpath.evaluate("appearance", element);
        }
        catch (XPathExpressionException e) {
            Log.e((String)"PdfBox-Android", (String)("Error while evaluating XPath expression for appearance: " + e));
            return;
        }
        try {
            decodedAppearanceXML = Hex.decodeBase64(base64EncodedAppearance);
        }
        catch (IllegalArgumentException ex) {
            Log.e((String)"PdfBox-Android", (String)"Bad base64 encoded appearance ignored", (Throwable)ex);
            return;
        }
        if (base64EncodedAppearance != null && !base64EncodedAppearance.isEmpty()) {
            Log.d((String)"PdfBox-Android", (String)("Decoded XML: " + new String(decodedAppearanceXML)));
            Document stampAppearance = XMLUtil.parse(new ByteArrayInputStream(decodedAppearanceXML));
            Element appearanceEl = stampAppearance.getDocumentElement();
            if (!"dict".equalsIgnoreCase(appearanceEl.getNodeName())) {
                throw new IOException("Error while reading stamp document, root should be 'dict' and not '" + appearanceEl.getNodeName() + "'");
            }
            Log.d((String)"PdfBox-Android", (String)"Generate and set the appearance dictionary to the stamp annotation");
            this.annot.setItem(COSName.AP, (COSBase)this.parseStampAnnotationAppearanceXML(appearanceEl));
        }
    }

    private COSDictionary parseStampAnnotationAppearanceXML(Element appearanceXML) throws IOException {
        COSDictionary dictionary = new COSDictionary();
        dictionary.setItem(COSName.N, (COSBase)new COSStream());
        Log.d((String)"PdfBox-Android", (String)"Build dictionary for Appearance based on the appearanceXML");
        NodeList nodeList = appearanceXML.getChildNodes();
        String parentAttrKey = appearanceXML.getAttribute("KEY");
        Log.d((String)"PdfBox-Android", (String)("Appearance Root - tag: " + appearanceXML.getTagName() + ", name: " + appearanceXML.getNodeName() + ", key: " + parentAttrKey + ", children: " + nodeList.getLength()));
        if (!"AP".equals(appearanceXML.getAttribute("KEY"))) {
            Log.w((String)"PdfBox-Android", (String)(parentAttrKey + " => Not handling element: " + appearanceXML.getTagName() + " with key: " + appearanceXML.getAttribute("KEY")));
            return dictionary;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            if ("STREAM".equalsIgnoreCase(child.getTagName())) {
                Log.d((String)"PdfBox-Android", (String)(parentAttrKey + " => Process " + child.getAttribute("KEY") + " item in the dictionary after processing the " + child.getTagName()));
                dictionary.setItem(child.getAttribute("KEY"), (COSBase)this.parseStreamElement(child));
                Log.d((String)"PdfBox-Android", (String)(parentAttrKey + " => Set " + child.getAttribute("KEY")));
                continue;
            }
            Log.w((String)"PdfBox-Android", (String)(parentAttrKey + " => Not handling element: " + child.getTagName()));
        }
        return dictionary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private COSStream parseStreamElement(Element streamEl) throws IOException {
        Log.d((String)"PdfBox-Android", (String)("Parse " + streamEl.getAttribute("KEY") + " Stream"));
        COSStream stream = new COSStream();
        NodeList nodeList = streamEl.getChildNodes();
        String parentAttrKey = streamEl.getAttribute("KEY");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            String childAttrKey = child.getAttribute("KEY");
            String childAttrVal = child.getAttribute("VAL");
            Log.d((String)"PdfBox-Android", (String)(parentAttrKey + " => reading child: " + child.getTagName() + " with key: " + childAttrKey));
            if ("INT".equalsIgnoreCase(child.getTagName())) {
                if ("Length".equals(childAttrKey)) continue;
                stream.setInt(COSName.getPDFName(childAttrKey), Integer.parseInt(childAttrVal));
                Log.d((String)"PdfBox-Android", (String)(parentAttrKey + " => Set " + childAttrKey + ": " + childAttrVal));
                continue;
            }
            if ("FIXED".equalsIgnoreCase(child.getTagName())) {
                stream.setFloat(COSName.getPDFName(childAttrKey), Float.parseFloat(childAttrVal));
                Log.d((String)"PdfBox-Android", (String)(parentAttrKey + " => Set " + childAttrKey + ": " + childAttrVal));
                continue;
            }
            if ("NAME".equalsIgnoreCase(child.getTagName())) {
                stream.setName(COSName.getPDFName(childAttrKey), childAttrVal);
                Log.d((String)"PdfBox-Android", (String)(parentAttrKey + " => Set " + childAttrKey + ": " + childAttrVal));
                continue;
            }
            if ("BOOL".equalsIgnoreCase(child.getTagName())) {
                stream.setBoolean(COSName.getPDFName(childAttrKey), Boolean.parseBoolean(childAttrVal));
                Log.d((String)"PdfBox-Android", (String)(parentAttrKey + " => Set " + childAttrVal));
                continue;
            }
            if ("ARRAY".equalsIgnoreCase(child.getTagName())) {
                stream.setItem(COSName.getPDFName(childAttrKey), (COSBase)this.parseArrayElement(child));
                Log.d((String)"PdfBox-Android", (String)(parentAttrKey + " => Set " + childAttrKey));
                continue;
            }
            if ("DICT".equalsIgnoreCase(child.getTagName())) {
                stream.setItem(COSName.getPDFName(childAttrKey), (COSBase)this.parseDictElement(child));
                Log.d((String)"PdfBox-Android", (String)(parentAttrKey + " => Set " + childAttrKey));
                continue;
            }
            if ("STREAM".equalsIgnoreCase(child.getTagName())) {
                stream.setItem(COSName.getPDFName(childAttrKey), (COSBase)this.parseStreamElement(child));
                Log.d((String)"PdfBox-Android", (String)(parentAttrKey + " => Set " + childAttrKey));
                continue;
            }
            if ("DATA".equalsIgnoreCase(child.getTagName())) {
                OutputStream os;
                Log.d((String)"PdfBox-Android", (String)(parentAttrKey + " => Handling DATA with encoding: " + child.getAttribute("ENCODING")));
                if ("HEX".equals(child.getAttribute("ENCODING"))) {
                    os = null;
                    try {
                        os = stream.createRawOutputStream();
                        os.write(Hex.decodeHex(child.getTextContent()));
                        Log.d((String)"PdfBox-Android", (String)(parentAttrKey + " => Data was streamed"));
                        continue;
                    }
                    finally {
                        IOUtils.closeQuietly(os);
                    }
                }
                if ("ASCII".equals(child.getAttribute("ENCODING"))) {
                    os = null;
                    try {
                        os = stream.createOutputStream();
                        os.write(child.getTextContent().getBytes());
                        Log.d((String)"PdfBox-Android", (String)(parentAttrKey + " => Data was streamed"));
                        continue;
                    }
                    finally {
                        IOUtils.closeQuietly(os);
                    }
                }
                Log.w((String)"PdfBox-Android", (String)(parentAttrKey + " => Not handling element DATA encoding: " + child.getAttribute("ENCODING")));
                continue;
            }
            Log.w((String)"PdfBox-Android", (String)(parentAttrKey + " => Not handling child element: " + child.getTagName()));
        }
        return stream;
    }

    private COSArray parseArrayElement(Element arrayEl) throws IOException {
        Log.d((String)"PdfBox-Android", (String)("Parse " + arrayEl.getAttribute("KEY") + " Array"));
        COSArray array = new COSArray();
        NodeList nodeList = arrayEl.getChildNodes();
        String parentAttrKey = arrayEl.getAttribute("KEY");
        if ("BBox".equals(parentAttrKey)) {
            if (nodeList.getLength() < 4) {
                throw new IOException("BBox does not have enough coordinates, only has: " + nodeList.getLength());
            }
        } else if ("Matrix".equals(parentAttrKey) && nodeList.getLength() < 6) {
            throw new IOException("Matrix does not have enough coordinates, only has: " + nodeList.getLength());
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            String childAttrKey = child.getAttribute("KEY");
            String childAttrVal = child.getAttribute("VAL");
            Log.d((String)"PdfBox-Android", (String)(parentAttrKey + " => reading child: " + child.getTagName() + " with key: " + childAttrKey));
            if ("INT".equalsIgnoreCase(child.getTagName())) {
                Log.d((String)"PdfBox-Android", (String)(parentAttrKey + " value(" + i + "): " + child.getAttribute("VAL")));
                array.add(COSFloat.get(childAttrVal));
                continue;
            }
            if ("FIXED".equalsIgnoreCase(child.getTagName())) {
                Log.d((String)"PdfBox-Android", (String)(parentAttrKey + " value(" + i + "): " + child.getAttribute("VAL")));
                array.add(COSInteger.get(childAttrVal));
                continue;
            }
            if ("NAME".equalsIgnoreCase(child.getTagName())) {
                Log.d((String)"PdfBox-Android", (String)(parentAttrKey + " value(" + i + "): " + child.getAttribute("VAL")));
                array.add(COSName.getPDFName(childAttrVal));
                continue;
            }
            if ("BOOL".equalsIgnoreCase(child.getTagName())) {
                Log.d((String)"PdfBox-Android", (String)(parentAttrKey + " value(" + i + "): " + child.getAttribute("VAL")));
                array.add(COSBoolean.getBoolean(Boolean.parseBoolean(childAttrVal)));
                continue;
            }
            if ("DICT".equalsIgnoreCase(child.getTagName())) {
                Log.d((String)"PdfBox-Android", (String)(parentAttrKey + " value(" + i + "): " + child.getAttribute("VAL")));
                array.add(this.parseDictElement(child));
                continue;
            }
            if ("STREAM".equalsIgnoreCase(child.getTagName())) {
                Log.d((String)"PdfBox-Android", (String)(parentAttrKey + " value(" + i + "): " + child.getAttribute("VAL")));
                array.add(this.parseStreamElement(child));
                continue;
            }
            if ("ARRAY".equalsIgnoreCase(child.getTagName())) {
                Log.d((String)"PdfBox-Android", (String)(parentAttrKey + " value(" + i + "): " + child.getAttribute("VAL")));
                array.add(this.parseArrayElement(child));
                continue;
            }
            Log.w((String)"PdfBox-Android", (String)(parentAttrKey + " => Not handling child element: " + child.getTagName()));
        }
        return array;
    }

    private COSDictionary parseDictElement(Element dictEl) throws IOException {
        Log.d((String)"PdfBox-Android", (String)("Parse " + dictEl.getAttribute("KEY") + " Dictionary"));
        COSDictionary dict = new COSDictionary();
        NodeList nodeList = dictEl.getChildNodes();
        String parentAttrKey = dictEl.getAttribute("KEY");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            String childAttrKey = child.getAttribute("KEY");
            String childAttrVal = child.getAttribute("VAL");
            if ("DICT".equals(child.getTagName())) {
                Log.d((String)"PdfBox-Android", (String)(parentAttrKey + " => Handling DICT element with key: " + childAttrKey));
                dict.setItem(COSName.getPDFName(childAttrKey), (COSBase)this.parseDictElement(child));
                Log.d((String)"PdfBox-Android", (String)(parentAttrKey + " => Set " + childAttrKey));
                continue;
            }
            if ("STREAM".equals(child.getTagName())) {
                Log.d((String)"PdfBox-Android", (String)(parentAttrKey + " => Handling STREAM element with key: " + childAttrKey));
                dict.setItem(COSName.getPDFName(childAttrKey), (COSBase)this.parseStreamElement(child));
                continue;
            }
            if ("NAME".equals(child.getTagName())) {
                Log.d((String)"PdfBox-Android", (String)(parentAttrKey + " => Handling NAME element with key: " + childAttrKey));
                dict.setName(COSName.getPDFName(childAttrKey), childAttrVal);
                Log.d((String)"PdfBox-Android", (String)(parentAttrKey + " => Set " + childAttrKey + ": " + childAttrVal));
                continue;
            }
            if ("INT".equalsIgnoreCase(child.getTagName())) {
                dict.setInt(COSName.getPDFName(childAttrKey), Integer.parseInt(childAttrVal));
                Log.d((String)"PdfBox-Android", (String)(parentAttrKey + " => Set " + childAttrKey + ": " + childAttrVal));
                continue;
            }
            if ("FIXED".equalsIgnoreCase(child.getTagName())) {
                dict.setFloat(COSName.getPDFName(childAttrKey), Float.parseFloat(childAttrVal));
                Log.d((String)"PdfBox-Android", (String)(parentAttrKey + " => Set " + childAttrKey + ": " + childAttrVal));
                continue;
            }
            if ("BOOL".equalsIgnoreCase(child.getTagName())) {
                dict.setBoolean(COSName.getPDFName(childAttrKey), Boolean.parseBoolean(childAttrVal));
                Log.d((String)"PdfBox-Android", (String)(parentAttrKey + " => Set " + childAttrVal));
                continue;
            }
            if ("ARRAY".equalsIgnoreCase(child.getTagName())) {
                dict.setItem(COSName.getPDFName(childAttrKey), (COSBase)this.parseArrayElement(child));
                Log.d((String)"PdfBox-Android", (String)(parentAttrKey + " => Set " + childAttrKey));
                continue;
            }
            Log.w((String)"PdfBox-Android", (String)(parentAttrKey + " => NOT handling child element: " + child.getTagName()));
        }
        return dict;
    }
}

