/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.interactive.annotation.handlers;

import android.util.Log;
import com.tom_roush.fontbox.util.Charsets;
import com.tom_roush.pdfbox.contentstream.operator.Operator;
import com.tom_roush.pdfbox.cos.COSArray;
import com.tom_roush.pdfbox.cos.COSBase;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.cos.COSNumber;
import com.tom_roush.pdfbox.cos.COSObject;
import com.tom_roush.pdfbox.io.IOUtils;
import com.tom_roush.pdfbox.pdfparser.PDFStreamParser;
import com.tom_roush.pdfbox.pdmodel.PDAppearanceContentStream;
import com.tom_roush.pdfbox.pdmodel.PDDocument;
import com.tom_roush.pdfbox.pdmodel.PDResources;
import com.tom_roush.pdfbox.pdmodel.common.PDRectangle;
import com.tom_roush.pdfbox.pdmodel.font.PDFont;
import com.tom_roush.pdfbox.pdmodel.font.PDType1Font;
import com.tom_roush.pdfbox.pdmodel.graphics.color.PDColor;
import com.tom_roush.pdfbox.pdmodel.graphics.color.PDColorSpace;
import com.tom_roush.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import com.tom_roush.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.PDAnnotationMarkup;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.PDBorderEffectDictionary;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.handlers.AnnotationBorder;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.handlers.CloudyBorder;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.handlers.PDAbstractAppearanceHandler;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.layout.AppearanceStyle;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.layout.PlainText;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.layout.PlainTextFormatter;
import com.tom_roush.pdfbox.util.Matrix;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PDFreeTextAppearanceHandler
extends PDAbstractAppearanceHandler {
    private static final Pattern COLOR_PATTERN = Pattern.compile(".*color\\:\\s*\\#([0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F]).*");
    private float fontSize = 10.0f;
    private COSName fontName = COSName.HELV;

    public PDFreeTextAppearanceHandler(PDAnnotation annotation) {
        super(annotation);
    }

    public PDFreeTextAppearanceHandler(PDAnnotation annotation, PDDocument document) {
        super(annotation, document);
    }

    @Override
    public void generateAppearanceStreams() {
        this.generateNormalAppearance();
        this.generateRolloverAppearance();
        this.generateDownAppearance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateNormalAppearance() {
        PDAnnotationMarkup annotation = (PDAnnotationMarkup)this.getAnnotation();
        float[] pathsArray = new float[]{};
        if ("FreeTextCallout".equals(annotation.getIntent()) && ((pathsArray = annotation.getCallout()) == null || pathsArray.length != 4 && pathsArray.length != 6)) {
            pathsArray = new float[]{};
        }
        AnnotationBorder ab = AnnotationBorder.getAnnotationBorder(annotation, annotation.getBorderStyle());
        PDAppearanceContentStream cs = null;
        try {
            float clipY;
            float yOffset;
            float xOffset;
            PDFont defaultResourcesFont;
            PDResources defaultResources;
            PDRectangle borderBox;
            PDBorderEffectDictionary borderEffect;
            Matcher m;
            cs = this.getNormalAppearanceAsContentStream(true);
            boolean hasBackground = cs.setNonStrokingColorOnDemand(annotation.getColor());
            this.setOpacity(cs, annotation.getConstantOpacity());
            PDColor strokingColor = this.extractNonStrokingColor(annotation);
            boolean hasStroke = cs.setStrokingColorOnDemand(strokingColor);
            PDColor textColor = strokingColor;
            String defaultStyleString = annotation.getDefaultStyleString();
            if (defaultStyleString != null && (m = COLOR_PATTERN.matcher(defaultStyleString)).find()) {
                int color = Integer.parseInt(m.group(1), 16);
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                textColor = new PDColor(new float[]{r, g, b}, (PDColorSpace)PDDeviceRGB.INSTANCE);
            }
            if (ab.dashArray != null) {
                cs.setLineDashPattern(ab.dashArray, 0.0f);
            }
            cs.setLineWidth(ab.width);
            for (int i = 0; i < pathsArray.length / 2; ++i) {
                float x = pathsArray[i * 2];
                float y = pathsArray[i * 2 + 1];
                if (i == 0) {
                    if (SHORT_STYLES.contains(annotation.getLineEndingStyle())) {
                        float x1 = pathsArray[2];
                        float y1 = pathsArray[3];
                        float len = (float)Math.sqrt(Math.pow(x - x1, 2.0) + Math.pow(y - y1, 2.0));
                        if (Float.compare(len, 0.0f) != 0) {
                            x += (x1 - x) / len * ab.width;
                            y += (y1 - y) / len * ab.width;
                        }
                    }
                    cs.moveTo(x, y);
                    continue;
                }
                cs.lineTo(x, y);
            }
            if (pathsArray.length > 0) {
                cs.stroke();
            }
            if ("FreeTextCallout".equals(annotation.getIntent()) && !"None".equals(annotation.getLineEndingStyle()) && pathsArray.length >= 4) {
                float x2 = pathsArray[2];
                float y2 = pathsArray[3];
                float x1 = pathsArray[0];
                float y1 = pathsArray[1];
                cs.saveGraphicsState();
                if (ANGLED_STYLES.contains(annotation.getLineEndingStyle())) {
                    double angle = Math.atan2(y2 - y1, x2 - x1);
                    cs.transform(Matrix.getRotateInstance(angle, x1, y1));
                } else {
                    cs.transform(Matrix.getTranslateInstance(x1, y1));
                }
                this.drawStyle(annotation.getLineEndingStyle(), cs, 0.0f, 0.0f, ab.width, hasStroke, hasBackground, false);
                cs.restoreGraphicsState();
            }
            if ((borderEffect = annotation.getBorderEffect()) != null && borderEffect.getStyle().equals("C")) {
                borderBox = this.applyRectDifferences(this.getRectangle(), annotation.getRectDifferences());
                CloudyBorder cloudyBorder = new CloudyBorder(cs, borderEffect.getIntensity(), ab.width, this.getRectangle());
                cloudyBorder.createCloudyRectangle(annotation.getRectDifference());
                annotation.setRectangle(cloudyBorder.getRectangle());
                annotation.setRectDifference(cloudyBorder.getRectDifference());
                PDAppearanceStream appearanceStream = annotation.getNormalAppearanceStream();
                appearanceStream.setBBox(cloudyBorder.getBBox());
                appearanceStream.setMatrix(cloudyBorder.getMatrix());
            } else {
                borderBox = this.applyRectDifferences(this.getRectangle(), annotation.getRectDifferences());
                annotation.getNormalAppearanceStream().setBBox(borderBox);
                PDRectangle paddedRectangle = this.getPaddedRectangle(borderBox, ab.width / 2.0f);
                cs.addRect(paddedRectangle.getLowerLeftX(), paddedRectangle.getLowerLeftY(), paddedRectangle.getWidth(), paddedRectangle.getHeight());
            }
            cs.drawShape(ab.width, hasStroke, hasBackground);
            int rotation = annotation.getCOSObject().getInt(COSName.ROTATE, 0);
            cs.transform(Matrix.getRotateInstance(Math.toRadians(rotation), 0.0f, 0.0f));
            float width = rotation == 90 || rotation == 270 ? borderBox.getHeight() : borderBox.getWidth();
            PDFont font = PDType1Font.HELVETICA;
            float clipWidth = width - ab.width * 4.0f;
            float clipHeight = rotation == 90 || rotation == 270 ? borderBox.getWidth() - ab.width * 4.0f : borderBox.getHeight() - ab.width * 4.0f;
            this.extractFontDetails(annotation);
            if (this.document != null && this.document.getDocumentCatalog().getAcroForm() != null && (defaultResources = this.document.getDocumentCatalog().getAcroForm().getDefaultResources()) != null && (defaultResourcesFont = defaultResources.getFont(this.fontName)) != null) {
                font = defaultResourcesFont;
            }
            float yDelta = 0.7896f;
            switch (rotation) {
                case 180: {
                    xOffset = -borderBox.getUpperRightX() + ab.width * 2.0f;
                    yOffset = -borderBox.getLowerLeftY() - ab.width * 2.0f - yDelta * this.fontSize;
                    clipY = -borderBox.getUpperRightY() + ab.width * 2.0f;
                    break;
                }
                case 90: {
                    xOffset = borderBox.getLowerLeftY() + ab.width * 2.0f;
                    yOffset = -borderBox.getLowerLeftX() - ab.width * 2.0f - yDelta * this.fontSize;
                    clipY = -borderBox.getUpperRightX() + ab.width * 2.0f;
                    break;
                }
                case 270: {
                    xOffset = -borderBox.getUpperRightY() + ab.width * 2.0f;
                    yOffset = borderBox.getUpperRightX() - ab.width * 2.0f - yDelta * this.fontSize;
                    clipY = borderBox.getLowerLeftX() + ab.width * 2.0f;
                    break;
                }
                default: {
                    xOffset = borderBox.getLowerLeftX() + ab.width * 2.0f;
                    yOffset = borderBox.getUpperRightY() - ab.width * 2.0f - yDelta * this.fontSize;
                    clipY = borderBox.getLowerLeftY() + ab.width * 2.0f;
                }
            }
            cs.addRect(xOffset, clipY, clipWidth, clipHeight);
            cs.clip();
            cs.beginText();
            cs.setFont(font, this.fontSize);
            cs.setNonStrokingColor(textColor.getComponents());
            AppearanceStyle appearanceStyle = new AppearanceStyle();
            appearanceStyle.setFont(font);
            appearanceStyle.setFontSize(this.fontSize);
            PlainTextFormatter formatter = new PlainTextFormatter.Builder(cs).style(appearanceStyle).text(new PlainText(annotation.getContents())).width(width - ab.width * 4.0f).wrapLines(true).initialOffset(xOffset, yOffset).build();
            try {
                formatter.format();
            }
            catch (IllegalArgumentException ex) {
                throw new IOException(ex);
            }
            cs.endText();
            if (pathsArray.length > 0) {
                PDRectangle rect = this.getRectangle();
                float minX = Float.MAX_VALUE;
                float minY = Float.MAX_VALUE;
                float maxX = Float.MIN_VALUE;
                float maxY = Float.MIN_VALUE;
                for (int i = 0; i < pathsArray.length / 2; ++i) {
                    float x = pathsArray[i * 2];
                    float y = pathsArray[i * 2 + 1];
                    minX = Math.min(minX, x);
                    minY = Math.min(minY, y);
                    maxX = Math.max(maxX, x);
                    maxY = Math.max(maxY, y);
                }
                rect.setLowerLeftX(Math.min(minX - ab.width * 10.0f, rect.getLowerLeftX()));
                rect.setLowerLeftY(Math.min(minY - ab.width * 10.0f, rect.getLowerLeftY()));
                rect.setUpperRightX(Math.max(maxX + ab.width * 10.0f, rect.getUpperRightX()));
                rect.setUpperRightY(Math.max(maxY + ab.width * 10.0f, rect.getUpperRightY()));
                annotation.setRectangle(rect);
                annotation.getNormalAppearanceStream().setBBox(this.getRectangle());
            }
        }
        catch (IOException ex) {
            Log.e((String)"PdfBox-Android", (String)ex.getMessage(), (Throwable)ex);
        }
        finally {
            IOUtils.closeQuietly(cs);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private PDColor extractNonStrokingColor(PDAnnotationMarkup annotation) {
        PDColor strokingColor = new PDColor(new float[]{0.0f}, (PDColorSpace)PDDeviceGray.INSTANCE);
        String defaultAppearance = annotation.getDefaultAppearance();
        if (defaultAppearance == null) {
            return strokingColor;
        }
        try {
            PDFStreamParser parser = new PDFStreamParser(defaultAppearance.getBytes(Charsets.US_ASCII));
            COSArray arguments = new COSArray();
            COSArray colors = null;
            Operator graphicOp = null;
            Object token = parser.parseNextToken();
            while (token != null) {
                if (token instanceof COSObject) {
                    arguments.add(((COSObject)token).getObject());
                } else if (token instanceof Operator) {
                    Operator op = (Operator)token;
                    String name = op.getName();
                    if ("g".equals(name) || "rg".equals(name) || "k".equals(name)) {
                        graphicOp = op;
                        colors = arguments;
                    }
                    arguments = new COSArray();
                } else {
                    arguments.add((COSBase)token);
                }
                token = parser.parseNextToken();
            }
            if (graphicOp == null) return strokingColor;
            String graphicOpName = graphicOp.getName();
            if ("g".equals(graphicOpName)) {
                return new PDColor(colors, (PDColorSpace)PDDeviceGray.INSTANCE);
            }
            if ("rg".equals(graphicOpName)) {
                return new PDColor(colors, (PDColorSpace)PDDeviceRGB.INSTANCE);
            }
            if (!"k".equals(graphicOpName)) return strokingColor;
        }
        catch (IOException ex) {
            Log.w((String)"PdfBox-Android", (String)"Problem parsing /DA, will use default black", (Throwable)ex);
        }
        return strokingColor;
    }

    private void extractFontDetails(PDAnnotationMarkup annotation) {
        String defaultAppearance = annotation.getDefaultAppearance();
        if (defaultAppearance == null && this.document != null && this.document.getDocumentCatalog().getAcroForm() != null) {
            defaultAppearance = this.document.getDocumentCatalog().getAcroForm().getDefaultAppearance();
        }
        if (defaultAppearance == null) {
            return;
        }
        try {
            PDFStreamParser parser = new PDFStreamParser(defaultAppearance.getBytes(Charsets.US_ASCII));
            COSArray arguments = new COSArray();
            COSArray fontArguments = new COSArray();
            Object token = parser.parseNextToken();
            while (token != null) {
                if (token instanceof COSObject) {
                    arguments.add(((COSObject)token).getObject());
                } else if (token instanceof Operator) {
                    Operator op = (Operator)token;
                    String name = op.getName();
                    if ("Tf".equals(name)) {
                        fontArguments = arguments;
                    }
                    arguments = new COSArray();
                } else {
                    arguments.add((COSBase)token);
                }
                token = parser.parseNextToken();
            }
            if (fontArguments.size() >= 2) {
                COSBase base = fontArguments.get(0);
                if (base instanceof COSName) {
                    this.fontName = (COSName)base;
                }
                if ((base = fontArguments.get(1)) instanceof COSNumber) {
                    this.fontSize = ((COSNumber)base).floatValue();
                }
            }
        }
        catch (IOException ex) {
            Log.w((String)"PdfBox-Android", (String)"Problem parsing /DA, will use default 'Helv 10'", (Throwable)ex);
        }
    }

    @Override
    public void generateRolloverAppearance() {
    }

    @Override
    public void generateDownAppearance() {
    }
}

