/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.font;

import android.graphics.Path;
import android.util.Log;
import com.tom_roush.fontbox.cff.Type2CharString;
import com.tom_roush.fontbox.cmap.CMap;
import com.tom_roush.fontbox.ttf.CmapLookup;
import com.tom_roush.fontbox.ttf.GlyphData;
import com.tom_roush.fontbox.ttf.OTFParser;
import com.tom_roush.fontbox.ttf.OpenTypeFont;
import com.tom_roush.fontbox.ttf.TrueTypeFont;
import com.tom_roush.fontbox.util.BoundingBox;
import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.pdmodel.common.PDRectangle;
import com.tom_roush.pdfbox.pdmodel.common.PDStream;
import com.tom_roush.pdfbox.pdmodel.font.CIDFontMapping;
import com.tom_roush.pdfbox.pdmodel.font.FontMappers;
import com.tom_roush.pdfbox.pdmodel.font.PDCIDFont;
import com.tom_roush.pdfbox.pdmodel.font.PDFontDescriptor;
import com.tom_roush.pdfbox.pdmodel.font.PDType0Font;
import com.tom_roush.pdfbox.util.Matrix;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class PDCIDFontType2
extends PDCIDFont {
    private final TrueTypeFont ttf;
    private final int[] cid2gid;
    private final boolean isEmbedded;
    private final boolean isDamaged;
    private final CmapLookup cmap;
    private Matrix fontMatrix;
    private BoundingBox fontBBox;
    private final Set<Integer> noMapping = new HashSet<Integer>();

    public PDCIDFontType2(COSDictionary fontDictionary, PDType0Font parent) throws IOException {
        this(fontDictionary, parent, null);
    }

    public PDCIDFontType2(COSDictionary fontDictionary, PDType0Font parent, TrueTypeFont trueTypeFont) throws IOException {
        super(fontDictionary, parent);
        PDFontDescriptor fd = this.getFontDescriptor();
        if (trueTypeFont != null) {
            this.ttf = trueTypeFont;
            this.isEmbedded = true;
            this.isDamaged = false;
        } else {
            boolean fontIsDamaged = false;
            TrueTypeFont ttfFont = null;
            PDStream stream = null;
            if (fd != null) {
                stream = fd.getFontFile2();
                if (stream == null) {
                    stream = fd.getFontFile3();
                }
                if (stream == null) {
                    stream = fd.getFontFile();
                }
            }
            if (stream != null) {
                try {
                    OpenTypeFont otf;
                    OTFParser otfParser = new OTFParser(true);
                    ttfFont = otf = otfParser.parse(stream.createInputStream());
                    if (otf.isPostScript()) {
                        fontIsDamaged = true;
                        Log.w((String)"PdfBox-Android", (String)("Found CFF/OTF but expected embedded TTF font " + fd.getFontName()));
                    }
                }
                catch (NullPointerException e) {
                    fontIsDamaged = true;
                    Log.w((String)"PdfBox-Android", (String)("Could not read embedded OTF for font " + this.getBaseFont()), (Throwable)e);
                }
                catch (IOException e) {
                    fontIsDamaged = true;
                    Log.w((String)"PdfBox-Android", (String)("Could not read embedded OTF for font " + this.getBaseFont()), (Throwable)e);
                }
            }
            this.isEmbedded = ttfFont != null;
            this.isDamaged = fontIsDamaged;
            if (ttfFont == null) {
                ttfFont = this.findFontOrSubstitute();
            }
            this.ttf = ttfFont;
        }
        this.cmap = this.ttf.getUnicodeCmapLookup(false);
        this.cid2gid = this.readCIDToGIDMap();
    }

    private TrueTypeFont findFontOrSubstitute() throws IOException {
        CIDFontMapping mapping = FontMappers.instance().getCIDFont(this.getBaseFont(), this.getFontDescriptor(), this.getCIDSystemInfo());
        TrueTypeFont ttfFont = mapping.isCIDFont() ? (TrueTypeFont)mapping.getFont() : (TrueTypeFont)mapping.getTrueTypeFont();
        if (mapping.isFallback()) {
            Log.w((String)"PdfBox-Android", (String)("Using fallback font " + ttfFont.getName() + " for CID-keyed TrueType font " + this.getBaseFont()));
        }
        return ttfFont;
    }

    @Override
    public Matrix getFontMatrix() {
        if (this.fontMatrix == null) {
            this.fontMatrix = new Matrix(0.001f, 0.0f, 0.0f, 0.001f, 0.0f, 0.0f);
        }
        return this.fontMatrix;
    }

    @Override
    public BoundingBox getBoundingBox() throws IOException {
        if (this.fontBBox == null) {
            this.fontBBox = this.generateBoundingBox();
        }
        return this.fontBBox;
    }

    private BoundingBox generateBoundingBox() throws IOException {
        PDRectangle bbox;
        if (this.getFontDescriptor() != null && (bbox = this.getFontDescriptor().getFontBoundingBox()) != null && (Float.compare(bbox.getLowerLeftX(), 0.0f) != 0 || Float.compare(bbox.getLowerLeftY(), 0.0f) != 0 || Float.compare(bbox.getUpperRightX(), 0.0f) != 0 || Float.compare(bbox.getUpperRightY(), 0.0f) != 0)) {
            return new BoundingBox(bbox.getLowerLeftX(), bbox.getLowerLeftY(), bbox.getUpperRightX(), bbox.getUpperRightY());
        }
        return this.ttf.getFontBBox();
    }

    @Override
    public int codeToCID(int code) {
        CMap cMap = this.parent.getCMap();
        if (!cMap.hasCIDMappings() && cMap.hasUnicodeMappings()) {
            return cMap.toUnicode(code).codePointAt(0);
        }
        return cMap.toCID(code);
    }

    @Override
    public int codeToGID(int code) throws IOException {
        if (!this.isEmbedded) {
            if (this.cid2gid != null && !this.isDamaged) {
                Log.w((String)"PdfBox-Android", (String)("Using non-embedded GIDs in font " + this.getName()));
                int cid = this.codeToCID(code);
                return this.cid2gid[cid];
            }
            String unicode = this.parent.toUnicode(code);
            if (unicode == null) {
                if (!this.noMapping.contains(code)) {
                    this.noMapping.add(code);
                    Log.w((String)"PdfBox-Android", (String)("Failed to find a character mapping for " + code + " in " + this.getName()));
                }
                return this.codeToCID(code);
            }
            if (unicode.length() > 1) {
                Log.w((String)"PdfBox-Android", (String)"Trying to map multi-byte character using 'cmap', result will be poor");
            }
            return this.cmap.getGlyphId(unicode.codePointAt(0));
        }
        int cid = this.codeToCID(code);
        if (this.cid2gid != null) {
            if (cid < this.cid2gid.length) {
                return this.cid2gid[cid];
            }
            return 0;
        }
        if (cid < this.ttf.getNumberOfGlyphs()) {
            return cid;
        }
        return 0;
    }

    @Override
    public float getHeight(int code) throws IOException {
        return (this.ttf.getHorizontalHeader().getAscender() + -this.ttf.getHorizontalHeader().getDescender()) / this.ttf.getUnitsPerEm();
    }

    @Override
    public float getWidthFromFont(int code) throws IOException {
        int gid = this.codeToGID(code);
        int width = this.ttf.getAdvanceWidth(gid);
        int unitsPerEM = this.ttf.getUnitsPerEm();
        if (unitsPerEM != 1000) {
            width = (int)((float)width * (1000.0f / (float)unitsPerEM));
        }
        return width;
    }

    @Override
    public byte[] encode(int unicode) {
        int cid = -1;
        if (this.isEmbedded) {
            if (this.parent.getCMap().getName().startsWith("Identity-")) {
                if (this.cmap != null) {
                    cid = this.cmap.getGlyphId(unicode);
                }
            } else if (this.parent.getCMapUCS2() != null) {
                cid = this.parent.getCMapUCS2().toCID(unicode);
            }
            if (cid == -1) {
                cid = 0;
            }
        } else {
            cid = this.cmap.getGlyphId(unicode);
        }
        if (cid == 0) {
            throw new IllegalArgumentException(String.format("No glyph for U+%04X (%c) in font %s", unicode, Character.valueOf((char)unicode), this.getName()));
        }
        return new byte[]{(byte)(cid >> 8 & 0xFF), (byte)(cid & 0xFF)};
    }

    @Override
    public boolean isEmbedded() {
        return this.isEmbedded;
    }

    @Override
    public boolean isDamaged() {
        return this.isDamaged;
    }

    public TrueTypeFont getTrueTypeFont() {
        return this.ttf;
    }

    @Override
    public Path getPath(int code) throws IOException {
        if (this.ttf instanceof OpenTypeFont && ((OpenTypeFont)this.ttf).isPostScript()) {
            int cid = this.codeToGID(code);
            Type2CharString charstring = ((OpenTypeFont)this.ttf).getCFF().getFont().getType2CharString(cid);
            return charstring.getPath();
        }
        int gid = this.codeToGID(code);
        GlyphData glyph = this.ttf.getGlyph().getGlyph(gid);
        if (glyph != null) {
            return glyph.getPath();
        }
        return new Path();
    }

    @Override
    public boolean hasGlyph(int code) throws IOException {
        return this.codeToGID(code) != 0;
    }
}

