/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.interactive.form;

import android.util.Log;
import com.tom_roush.pdfbox.cos.COSBase;
import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.pdmodel.common.COSObjectable;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import com.tom_roush.pdfbox.pdmodel.interactive.digitalsignature.PDSeedValue;
import com.tom_roush.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import com.tom_roush.pdfbox.pdmodel.interactive.form.PDAcroForm;
import com.tom_roush.pdfbox.pdmodel.interactive.form.PDField;
import com.tom_roush.pdfbox.pdmodel.interactive.form.PDNonTerminalField;
import com.tom_roush.pdfbox.pdmodel.interactive.form.PDTerminalField;
import java.io.IOException;
import java.util.HashSet;

public class PDSignatureField
extends PDTerminalField {
    public PDSignatureField(PDAcroForm acroForm) throws IOException {
        super(acroForm);
        this.getCOSObject().setItem(COSName.FT, (COSBase)COSName.SIG);
        this.getWidgets().get(0).setLocked(true);
        this.getWidgets().get(0).setPrinted(true);
        this.setPartialName(this.generatePartialName());
    }

    PDSignatureField(PDAcroForm acroForm, COSDictionary field, PDNonTerminalField parent) {
        super(acroForm, field, parent);
    }

    private String generatePartialName() {
        String fieldName = "Signature";
        HashSet<String> sigNames = new HashSet<String>();
        for (PDField field : this.getAcroForm().getFieldTree()) {
            if (!(field instanceof PDSignatureField)) continue;
            sigNames.add(field.getPartialName());
        }
        int i = 1;
        while (sigNames.contains(fieldName + i)) {
            ++i;
        }
        return fieldName + i;
    }

    @Deprecated
    public void setSignature(PDSignature value) throws IOException {
        this.setValue(value);
    }

    public PDSignature getSignature() {
        return this.getValue();
    }

    public void setValue(PDSignature value) throws IOException {
        this.getCOSObject().setItem(COSName.V, (COSObjectable)value);
        this.applyChange();
    }

    @Override
    public void setValue(String value) {
        throw new UnsupportedOperationException("Signature fields don't support setting the value as String - use setValue(PDSignature value) instead");
    }

    public void setDefaultValue(PDSignature value) throws IOException {
        this.getCOSObject().setItem(COSName.DV, (COSObjectable)value);
    }

    public PDSignature getValue() {
        COSBase value = this.getCOSObject().getDictionaryObject(COSName.V);
        if (value instanceof COSDictionary) {
            return new PDSignature((COSDictionary)value);
        }
        return null;
    }

    public PDSignature getDefaultValue() {
        COSBase value = this.getCOSObject().getDictionaryObject(COSName.DV);
        if (value == null) {
            return null;
        }
        return new PDSignature((COSDictionary)value);
    }

    @Override
    public String getValueAsString() {
        PDSignature signature = this.getValue();
        return signature != null ? signature.toString() : "";
    }

    public PDSeedValue getSeedValue() {
        COSDictionary dict = (COSDictionary)this.getCOSObject().getDictionaryObject(COSName.SV);
        PDSeedValue sv = null;
        if (dict != null) {
            sv = new PDSeedValue(dict);
        }
        return sv;
    }

    public void setSeedValue(PDSeedValue sv) {
        if (sv != null) {
            this.getCOSObject().setItem(COSName.SV, (COSObjectable)sv);
        }
    }

    @Override
    void constructAppearances() throws IOException {
        PDAnnotationWidget widget = this.getWidgets().get(0);
        if (widget != null) {
            if (widget.getRectangle() == null || widget.getRectangle().getHeight() == 0.0f && widget.getRectangle().getWidth() == 0.0f || widget.isNoView() || widget.isHidden()) {
                return;
            }
            Log.w((String)"PdfBox-Android", (String)"Appearance generation for signature fields not yet implemented - you need to generate/update that manually");
        }
    }
}

